/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.utils;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class IPAddressDocument
extends PlainDocument {
    int currentValue = 0;
    JTextField field = null;

    public IPAddressDocument(JTextField field) {
        this.field = field;
    }

    public int getValue() {
        return this.currentValue;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (str == null) {
            return;
        }
        if (str.equals(".")) {
            this.field.transferFocus();
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = str;
        } else {
            String currentContent = this.getText(0, length);
            StringBuffer currentBuffer = new StringBuffer(currentContent);
            currentBuffer.insert(offset, str);
            newValue = currentBuffer.toString();
        }
        this.currentValue = this.checkInput(newValue, offset);
        super.insertString(offset, str, attributes);
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        int currentLength = this.getLength();
        String currentContent = this.getText(0, currentLength);
        String before = currentContent.substring(0, offset);
        String after = currentContent.substring(length + offset, currentLength);
        String newValue = before + after;
        this.currentValue = this.checkInput(newValue, offset);
        super.remove(offset, length);
    }

    private int checkInput(String proposedValue, int offset) throws BadLocationException {
        if (proposedValue.length() <= 0) {
            return 0;
        }
        if (proposedValue.length() > 3) {
            throw new BadLocationException(proposedValue, offset);
        }
        try {
            int newValue = Integer.parseInt(proposedValue);
            return newValue;
        }
        catch (NumberFormatException e) {
            throw new BadLocationException(proposedValue, offset);
        }
    }
}

