/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.utils;

import open.dolphin.project.GlobalVariables;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class HibernateUtil {
    private static Configuration config;
    private static SessionFactory sessionFactory;
    private static Session session;
    private static String currentDbAddress;
    private static String currentDbPassword;
    private static boolean currentDbSSLState;

    private static void createSessionFactory() {
        try {
            currentDbAddress = GlobalVariables.getDbAddress();
            currentDbPassword = GlobalVariables.getDbPasswordWithoutHash();
            currentDbSSLState = GlobalVariables.getDbSSLState();
            String dbAddress = "jdbc:postgresql://" + currentDbAddress + ":5432/dolphin";
            if (currentDbSSLState) {
                dbAddress = dbAddress + "?ssl";
            }
            config = new Configuration().setProperty("hibernate.connection.url", dbAddress).setProperty("hibernate.connection.password", currentDbPassword);
            sessionFactory = config.configure().buildSessionFactory();
        }
        catch (Throwable ex) {
            System.err.println("Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static void createSchema() {
        if (config == null) {
            HibernateUtil.createSessionFactory();
        }
        new SchemaExport(config).create(false, true);
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static void openSession() {
        session = HibernateUtil.getSessionFactory().openSession();
    }

    public static void closeSession() {
        if (session == null) {
            return;
        }
        session.close();
    }

    private static boolean isStatusChange() {
        return !GlobalVariables.getDbAddress().equals(currentDbAddress) || !GlobalVariables.getDbPasswordWithoutHash().equals(currentDbPassword) || GlobalVariables.getDbSSLState() != currentDbSSLState;
    }

    private static void clearSession() {
        if (session != null) {
            session.close();
            session = null;
        }
    }

    public static Session getCurrentSesison() {
        if (HibernateUtil.isStatusChange()) {
            HibernateUtil.clearSession();
            HibernateUtil.createSessionFactory();
        }
        if (session == null || !session.isConnected()) {
            HibernateUtil.openSession();
        }
        return session;
    }
}

