/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service.remote;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.NoResultException;
import open.dolphin.infomodel.IStampTreeModel;
import open.dolphin.infomodel.PublishedTreeModel;
import open.dolphin.infomodel.StampModel;
import open.dolphin.infomodel.StampTreeModel;
import open.dolphin.infomodel.SubscribedTreeModel;
import open.dolphin.service.DolphinService;
import open.dolphin.service.IStampService;
import org.hibernate.HibernateException;

public class RemoteStampService
extends DolphinService
implements IStampService {
    @Override
    public long putTree(StampTreeModel model) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                this.getSession().saveOrUpdate((Object)model);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return model.getId();
    }

    @Override
    public List<IStampTreeModel> getTrees(long userPk) {
        ArrayList<IStampTreeModel> ret;
        block9: {
            this.roleAllowed("user");
            ret = new ArrayList<IStampTreeModel>();
            try {
                this.startTransaction();
                boolean newUser = false;
                try {
                    StampTreeModel personal = (StampTreeModel)this.getSession().createQuery("from StampTreeModel where user_id=:userPk").setParameter("userPk", (Object)userPk).uniqueResult();
                    ret.add(personal);
                }
                catch (NoResultException ne) {
                    newUser = true;
                }
                if (newUser) {
                    this.endTransaction();
                    return ret;
                }
                List subscribed = this.getSession().createQuery("from SubscribedTreeModel where user_id=:userPk").setParameter("userPk", (Object)userPk).list();
                for (SubscribedTreeModel sm : subscribed) {
                    try {
                        PublishedTreeModel published = (PublishedTreeModel)this.getSession().createQuery("from PublishedTreeModel where id = :treeId").setParameter("treeId", (Object)sm.getTreeId()).uniqueResult();
                        if (published == null) {
                            this.getSession().delete((Object)sm);
                            continue;
                        }
                        ret.add(published);
                    }
                    catch (NoResultException ne) {
                        this.getSession().delete((Object)sm);
                    }
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block9;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public long saveAndPublishTree(StampTreeModel model, byte[] publishBytes) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                this.getSession().persist((Object)model);
                PublishedTreeModel publishedModel = new PublishedTreeModel();
                publishedModel.setId(model.getId());
                publishedModel.setUser(model.getUser());
                publishedModel.setName(model.getName());
                publishedModel.setPublishType(model.getPublishType());
                publishedModel.setCategory(model.getCategory());
                publishedModel.setPartyName(model.getPartyName());
                publishedModel.setUrl(model.getUrl());
                publishedModel.setDescription(model.getDescription());
                publishedModel.setPublishedDate(model.getPublishedDate());
                publishedModel.setLastUpdated(model.getLastUpdated());
                publishedModel.setTreeBytes(publishBytes);
                this.getSession().persist((Object)publishedModel);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return model.getId();
    }

    @Override
    public int publishTree(StampTreeModel model, byte[] publishBytes) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                this.getSession().merge((Object)model);
                PublishedTreeModel publishedModel = new PublishedTreeModel();
                publishedModel.setId(model.getId());
                publishedModel.setUser(model.getUser());
                publishedModel.setName(model.getName());
                publishedModel.setPublishType(model.getPublishType());
                publishedModel.setCategory(model.getCategory());
                publishedModel.setPartyName(model.getPartyName());
                publishedModel.setUrl(model.getUrl());
                publishedModel.setDescription(model.getDescription());
                publishedModel.setPublishedDate(model.getPublishedDate());
                publishedModel.setLastUpdated(model.getLastUpdated());
                publishedModel.setTreeBytes(publishBytes);
                this.getSession().persist((Object)publishedModel);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return 1;
    }

    @Override
    public int updatePublishedTree(StampTreeModel model, byte[] publishBytes) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                this.getSession().merge((Object)model);
                PublishedTreeModel publishedModel = new PublishedTreeModel();
                publishedModel.setId(model.getId());
                publishedModel.setUser(model.getUser());
                publishedModel.setName(model.getName());
                publishedModel.setPublishType(model.getPublishType());
                publishedModel.setCategory(model.getCategory());
                publishedModel.setPartyName(model.getPartyName());
                publishedModel.setUrl(model.getUrl());
                publishedModel.setDescription(model.getDescription());
                publishedModel.setPublishedDate(model.getPublishedDate());
                publishedModel.setLastUpdated(model.getLastUpdated());
                publishedModel.setTreeBytes(publishBytes);
                this.getSession().merge((Object)publishedModel);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return 1;
    }

    @Override
    public int cancelPublishedTree(StampTreeModel model) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                this.getSession().merge((Object)model);
                PublishedTreeModel exist = (PublishedTreeModel)this.getSession().createQuery("from PublishedTreeModel where id = :id").setParameter("id", (Object)model.getId()).uniqueResult();
                this.getSession().delete((Object)exist);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return 1;
    }

    @Override
    public List<PublishedTreeModel> getPublishedTrees() {
        ArrayList<PublishedTreeModel> ret;
        block2: {
            this.roleAllowed("user");
            ret = new ArrayList<PublishedTreeModel>();
            try {
                this.startTransaction();
                String fid = this.getCallersFacilityId();
                List locals = this.getSession().createQuery("from PublishedTreeModel p where p.publishType=:fid").setParameter("fid", (Object)fid).list();
                ret.addAll(locals);
                List publics = this.getSession().createQuery("from PublishedTreeModel p where p.publishType='global'").list();
                ret.addAll(publics);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public List<Long> subscribeTrees(List<SubscribedTreeModel> addList) {
        ArrayList<Long> ret;
        block3: {
            this.roleAllowed("user");
            ret = new ArrayList<Long>();
            try {
                this.startTransaction();
                for (SubscribedTreeModel model : addList) {
                    this.getSession().persist((Object)model);
                    ret.add(new Long(model.getId()));
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public int unsubscribeTrees(List<SubscribedTreeModel> removeList) {
        int cnt;
        block3: {
            this.roleAllowed("user");
            cnt = 0;
            try {
                this.startTransaction();
                for (SubscribedTreeModel model : removeList) {
                    SubscribedTreeModel remove = (SubscribedTreeModel)this.getSession().createQuery("from SubscribedTreeModel s where s.user.id=:userPk and s.treeId=:treeId").setParameter("userPk", (Object)model.getUser().getId()).setParameter("treeId", (Object)model.getTreeId()).uniqueResult();
                    this.getSession().delete((Object)remove);
                    ++cnt;
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return cnt;
    }

    @Override
    public StampTreeModel getAspTree(String managerId) {
        StampTreeModel ret;
        block3: {
            this.roleAllowed("user");
            ret = null;
            try {
                this.startTransaction();
                ret = (StampTreeModel)this.getSession().createQuery("from StampTreeModel s where s.userId = :mid").setParameter("mid", (Object)managerId).uniqueResult();
                this.endTransaction();
            }
            catch (NoResultException e) {
                System.err.println("NoResultException: " + e.toString());
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public List<String> putStamp(List<StampModel> list) {
        ArrayList<String> ret;
        block3: {
            this.roleAllowed("user");
            ret = new ArrayList<String>();
            try {
                this.startTransaction();
                for (StampModel model : list) {
                    this.getSession().persist((Object)model);
                    ret.add(model.getId());
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public String putStamp(StampModel model) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                this.getSession().persist((Object)model);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return model.getId();
    }

    @Override
    public StampModel getStamp(String stampId) {
        StampModel result;
        block3: {
            this.roleAllowed("user");
            result = null;
            try {
                this.startTransaction();
                result = (StampModel)this.getSession().createQuery("from StampModel where id = :id").setParameter("id", (Object)stampId).uniqueResult();
                this.endTransaction();
            }
            catch (NoResultException e) {
                System.err.println("NoResultException: " + e.toString());
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return result;
    }

    @Override
    public List<StampModel> getStamp(List<String> ids) {
        ArrayList<StampModel> ret;
        block3: {
            this.roleAllowed("user");
            ret = new ArrayList<StampModel>();
            try {
                this.startTransaction();
                for (String stampId : ids) {
                    StampModel test = (StampModel)this.getSession().createQuery("from StampModel where id = :id").setParameter("id", (Object)stampId).uniqueResult();
                    ret.add(test);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return ret;
    }

    @Override
    public int removeStamp(String stampId) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                StampModel exist = (StampModel)this.getSession().createQuery("from StampModel whwre id = :id").setParameter("id", (Object)stampId).uniqueResult();
                this.getSession().delete((Object)exist);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
            }
        }
        return 1;
    }

    @Override
    public int removeStamp(List<String> ids) {
        int cnt;
        block3: {
            this.roleAllowed("user");
            cnt = 0;
            try {
                this.startTransaction();
                for (String stampId : ids) {
                    StampModel exist = (StampModel)this.getSession().createQuery("from StampModel where id = :id").setParameter("id", (Object)stampId).uniqueResult();
                    this.getSession().delete((Object)exist);
                    ++cnt;
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
        return cnt;
    }

    @Override
    public void cleanStamp(long userId) {
        block3: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                List stamps = this.getSession().createQuery("from StampModel where userid=:uid").setParameter("uid", (Object)userId).list();
                for (StampModel stamp : stamps) {
                    this.getSession().delete((Object)stamp);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block3;
                this.getSession().getTransaction().rollback();
            }
        }
    }
}

