/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service;

import java.security.Principal;
import open.dolphin.exception.SecurityException;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.HibernateUtil;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DolphinService
implements IInfoModel {
    private Session session;
    private int transactionCounter = 0;

    protected void startTransaction() {
        if (this.transactionCounter == 0) {
            this.getSession().beginTransaction();
            this.transactionCounter = 1;
        } else {
            ++this.transactionCounter;
        }
    }

    protected Session getSession() {
        return HibernateUtil.getCurrentSesison();
    }

    protected void endTransaction() {
        Transaction transaction;
        --this.transactionCounter;
        if (this.transactionCounter == 0 && (transaction = this.getSession().getTransaction()).isActive()) {
            this.getSession().flush();
            transaction.commit();
        }
    }

    public String checkIdAsComposite(String checkId) {
        int index = checkId.indexOf(":");
        if (index < 0) {
            throw new SecurityException(checkId);
        }
        String callerId = null;
        String callersFacilityId = null;
        String facilityId = checkId.substring(0, index);
        for (Principal principal : GlobalVariables.getSubject().getPrincipals()) {
            callerId = principal.getName();
            callersFacilityId = callerId.substring(0, index = callerId.indexOf(":"));
            if (!facilityId.equals(callersFacilityId)) continue;
            return checkId;
        }
        throw new SecurityException(checkId);
    }

    public String checkFacility(String checkId) {
        String requestKey;
        String callerKey = this.getCallersFacilityId();
        if (!callerKey.equals(requestKey = this.getRequestsFacilityId(checkId))) {
            throw new SecurityException(requestKey);
        }
        return checkId;
    }

    public String getIdAsComposite(String testId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCallersFacilityId());
        sb.append(":");
        sb.append(this.getIdAsLocal(testId));
        return sb.toString();
    }

    public String getCallersFacilityId() {
        String callerId = null;
        int index = 0;
        for (Principal principal : GlobalVariables.getSubject().getPrincipals()) {
            callerId = principal.getName();
            index = callerId.indexOf(":");
            if (index == 0) continue;
            return callerId.substring(0, index);
        }
        return null;
    }

    public String getIdAsQualified(String facilityId, String localIdd) {
        StringBuilder buf = new StringBuilder();
        buf.append(facilityId);
        buf.append(":");
        buf.append(localIdd);
        return buf.toString();
    }

    public String getIdAsLocal(String testId) {
        int index = testId.indexOf(":");
        return index > 0 ? testId.substring(index + 1) : testId;
    }

    private String getRequestsFacilityId(String checkId) {
        int index = checkId.indexOf(":");
        return index > 0 ? checkId.substring(0, index) : checkId;
    }

    protected void roleAllowed(String role) {
        for (Principal principal : GlobalVariables.getSubject().getPrincipals()) {
            if (!principal.getName().equalsIgnoreCase(role)) continue;
            return;
        }
        throw new SecurityException("Not allowed action");
    }
}

