/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.sendclaim;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JOptionPane;
import open.dolphin.client.ClaimMessageEvent;
import open.dolphin.client.IMainService;
import open.dolphin.client.IMainWindow;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.sendclaim.OrcaSocket;
import open.dolphin.utils.DebugDump;
import open.dolphin.utils.StringSubstitution;

public class SendClaimImpl
implements IMainService {
    private final int EOT = 4;
    private final int ACK = 6;
    private final int NAK = 21;
    private final int DEFAULT_TRY_COUNT = 3;
    private final long DEFAULT_SLEEP_TIME = 20000L;
    private final int MAX_QUEU_SIZE = 10;
    private final int TT_QUEUE_SIZE = 0;
    private final int TT_NAK_SIGNAL = 1;
    private final int TT_SENDING_TROUBLE = 2;
    private final int TT_CONNECTION_REJECT = 3;
    private final String proceedString = "\u7d99\u7d9a";
    private final String dumpString = "\u30ed\u30b0\u3078\u8a18\u9332";
    private LinkedBlockingQueue queue;
    private String host;
    private int port;
    private String enc;
    private int tryCount = 3;
    private long sleepTime = 20000L;
    private int alertQueueSize = 10;
    private ExecutorService sendService;
    private IMainWindow context;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    private void setup() {
        this.setHost(GlobalVariables.getClaimAddress());
        this.setPort(GlobalVariables.getClaimPort());
        this.setEncoding(GlobalVariables.getClaimEncoding());
        if (this.queue == null) {
            this.queue = new LinkedBlockingQueue();
        }
    }

    @Override
    public void start() {
        this.setup();
        OrcaSocket orcaSocket = new OrcaSocket(this.getHost(), this.getPort(), this.sleepTime, this.tryCount);
        this.sendService = Executors.newSingleThreadExecutor();
        this.sendService.execute(new Consumer(orcaSocket));
    }

    @Override
    public void stop() {
        try {
            if (this.sendService != null) {
                this.sendService.shutdownNow();
            }
            this.logDump();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getEncoding() {
        return this.enc;
    }

    public void setEncoding(String enc) {
        this.enc = enc;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int val) {
        this.tryCount = val;
    }

    public int getAlertQueueSize() {
        return this.alertQueueSize;
    }

    public void getAlertQueueSize(int val) {
        this.alertQueueSize = val;
    }

    public void claimMessageEvent(ClaimMessageEvent e) {
        this.queue.offer(e);
    }

    public Object getCLAIM() throws InterruptedException {
        return this.queue.take();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public void logDump() {
        for (ClaimMessageEvent evt : this.queue) {
            LogWriter.warn(SendClaimImpl.class, evt.getClaimInsutance());
        }
        this.queue.clear();
    }

    private int alertDialog(int code) {
        int option = -1;
        String title = "OpenDolphin: CLAIM \u9001\u4fe1";
        StringBuffer buf = null;
        switch (code) {
            case 0: {
                buf = new StringBuffer();
                buf.append("\u672a\u9001\u4fe1\u306eCLAIM(\u30ec\u30bb\u30d7\u30c8)\u30c7\u30fc\u30bf\u304c");
                buf.append(this.getQueueSize());
                buf.append(" \u500b\u3042\u308a\u307e\u3059\u3002CLAIM \u30b5\u30fc\u30d0\u3068\u306e\u63a5\u7d9a\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
                buf.append("1. \u3053\u306e\u307e\u307e\u51e6\u7406\u3092\u7d99\u7d9a\u3059\u308b\u3053\u3068\u3082\u3067\u304d\u307e\u3059\u3002\n");
                buf.append("2. \u672a\u9001\u4fe1\u30c7\u30fc\u30bf\u3092\u30ed\u30b0\u306b\u8a18\u9332\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002\n");
                buf.append("   \u3053\u306e\u5834\u5408\u3001\u30c7\u30fc\u30bf\u306f\u9001\u4fe1\u3055\u308c\u305a\u3001\u8a3a\u7642\u5831\u916c\u306f\u624b\u5165\u529b\u3068\u306a\u308a\u307e\u3059\u3002");
                option = JOptionPane.showOptionDialog(null, buf.toString(), title, -1, 2, null, new String[]{"\u7d99\u7d9a", "\u30ed\u30b0\u3078\u8a18\u9332"}, "\u7d99\u7d9a");
                break;
            }
            case 1: {
                buf = new StringBuffer();
                buf.append("CLAIM(\u30ec\u30bb\u30d7\u30c8)\u30c7\u30fc\u30bf\u304c\u30b5\u30fc\u30d0\u306b\u3088\u308a\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002\n");
                buf.append("\u9001\u4fe1\u4e2d\u306e\u30c7\u30fc\u30bf\u306f\u30ed\u30b0\u306b\u8a18\u9332\u3057\u307e\u3059\u3002\u8a3a\u7642\u5831\u916c\u306e\u81ea\u52d5\u5165\u529b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                JOptionPane.showMessageDialog(null, buf.toString(), title, 0);
                break;
            }
            case 2: {
                buf = new StringBuffer();
                buf.append("CLAIM(\u30ec\u30bb\u30d7\u30c8)\u30c7\u30fc\u30bf\u306e\u9001\u4fe1\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u304a\u304d\u307e\u3057\u305f\u3002\n");
                buf.append("\u9001\u4fe1\u4e2d\u306e\u30c7\u30fc\u30bf\u306f\u30ed\u30b0\u306b\u8a18\u9332\u3057\u307e\u3059\u3002\u8a3a\u7642\u5831\u916c\u306e\u81ea\u52d5\u5165\u529b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                JOptionPane.showMessageDialog(null, buf.toString(), title, 0);
                break;
            }
            case 3: {
                buf = new StringBuffer();
                buf.append("CLAIM(\u30ec\u30bb\u30d7\u30c8)\u30b5\u30fc\u30d0 ");
                buf.append("Host=");
                buf.append(this.host);
                buf.append(" Port=");
                buf.append(this.port);
                buf.append(" \u304c ");
                buf.append((long)this.tryCount * this.sleepTime);
                buf.append(" \u79d2\u4ee5\u4e0a\u5fdc\u7b54\u3057\u307e\u305b\u3093\u3002\u30b5\u30fc\u30d0\u306e\u96fb\u6e90\u53ca\u3073\u63a5\u7d9a\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n");
                buf.append("1. \u3053\u306e\u307e\u307e\u63a5\u7d9a\u3092\u5f85\u3064\u3053\u3068\u3082\u3067\u304d\u307e\u3059\u3002\n");
                buf.append("2. \u30c7\u30fc\u30bf\u3092\u30ed\u30b0\u306b\u8a18\u9332\u3059\u308b\u3053\u3068\u3082\u3067\u304d\u307e\u3059\u3002\n");
                buf.append("   \u3053\u306e\u5834\u5408\u3001\u30c7\u30fc\u30bf\u306f\u9001\u4fe1\u3055\u308c\u305a\u3001\u8a3a\u7642\u5831\u916c\u306f\u624b\u5165\u529b\u3068\u306a\u308a\u307e\u3059\u3002");
                option = JOptionPane.showOptionDialog(null, buf.toString(), title, -1, 2, null, new String[]{"\u7d99\u7d9a", "\u30ed\u30b0\u3078\u8a18\u9332"}, "\u7d99\u7d9a");
            }
        }
        return option;
    }

    private void warnLog(String result, ClaimMessageEvent evt) {
        LogWriter.warn(SendClaimImpl.class, this.getBasicInfo(result, evt));
        LogWriter.warn(SendClaimImpl.class, evt.getClaimInsutance());
    }

    private void log(String result, ClaimMessageEvent evt) {
        LogWriter.info(SendClaimImpl.class, this.getBasicInfo(result, evt));
    }

    private String getBasicInfo(String result, ClaimMessageEvent evt) {
        String id = evt.getPatientId();
        String nm = evt.getPatientName();
        String sex = evt.getPatientSex();
        String title = evt.getTitle();
        String timeStamp = evt.getConfirmDate();
        StringBuilder buf = new StringBuilder();
        buf.append(result);
        buf.append("[");
        buf.append(id);
        buf.append(" ");
        buf.append(nm);
        buf.append(" ");
        buf.append(sex);
        buf.append(" ");
        buf.append(title);
        buf.append(" ");
        buf.append(timeStamp);
        buf.append("]");
        return buf.toString();
    }

    protected class Consumer
    implements Runnable {
        private OrcaSocket orcaSocket;

        public Consumer(OrcaSocket orcaSocket) {
            this.orcaSocket = orcaSocket;
        }

        @Override
        public void run() {
            ClaimMessageEvent claimEvent = null;
            Socket socket = null;
            BufferedOutputStream writer = null;
            BufferedInputStream reader = null;
            String instance = null;
            while (true) {
                try {
                    while (true) {
                        claimEvent = (ClaimMessageEvent)SendClaimImpl.this.getCLAIM();
                        instance = StringSubstitution.Substitution(claimEvent.getClaimInsutance(), "\uff0d", "\u2015");
                        if (GlobalSettings.isKarteDataDump()) {
                            DebugDump.dump("lastclaim.log", instance);
                        }
                        if ((socket = this.orcaSocket.getSocket()) == null) {
                            int option = SendClaimImpl.this.alertDialog(3);
                            if (option == 1) {
                                SendClaimImpl.this.warnLog("CLAIM  Socket Error", claimEvent);
                                continue;
                            }
                            SendClaimImpl.this.claimMessageEvent(claimEvent);
                            continue;
                        }
                        writer = new BufferedOutputStream(new DataOutputStream(socket.getOutputStream()));
                        reader = new BufferedInputStream(new DataInputStream(socket.getInputStream()));
                        writer.write(instance.getBytes(SendClaimImpl.this.enc));
                        writer.write(4);
                        writer.flush();
                        int c = reader.read();
                        if (c == 6) {
                            SendClaimImpl.this.log("CLAIM ACK", claimEvent);
                        } else if (c == 21) {
                            SendClaimImpl.this.warnLog("CLAIM NAK", claimEvent);
                        }
                        socket.close();
                    }
                }
                catch (IOException e) {
                    SendClaimImpl.this.alertDialog(2);
                    if (instance == null) continue;
                    SendClaimImpl.this.warnLog("CLAIM IO Error", claimEvent);
                    continue;
                }
                catch (Exception e) {
                    LogWriter.warn(SendClaimImpl.class, "Exception " + e.getMessage());
                    return;
                }
                break;
            }
        }
    }
}

