/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdesktop.application.ApplicationContext;

public class SecurityDirectory {
    static final String SECURITY_DIRECTORY = "security";
    static final String SECURITY_CERTIFICATE_FILE = "/dolphin.trustStore";
    private File parentDirectory;
    private File securityDirectory;

    public SecurityDirectory(ApplicationContext context) {
        this.parentDirectory = context.getLocalStorage().getDirectory();
        this.securityDirectory = new File(this.parentDirectory, SECURITY_DIRECTORY);
    }

    public boolean CertificateFileExists() {
        File file = new File(this.securityDirectory.getAbsolutePath() + SECURITY_CERTIFICATE_FILE);
        return file.exists();
    }

    public File makeSecurityDirectory() {
        if (!this.securityDirectory.exists() && this.securityDirectory.canWrite()) {
            this.securityDirectory.mkdir();
        }
        return this.securityDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCertificateFile(InputStream content) throws FileNotFoundException, IOException {
        FileOutputStream stream = new FileOutputStream(this.securityDirectory.getAbsolutePath() + SECURITY_CERTIFICATE_FILE);
        try {
            int data;
            while ((data = content.read()) != -1) {
                ((OutputStream)stream).write(data);
            }
        }
        finally {
            ((OutputStream)stream).close();
        }
    }
}

