/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import open.dolphin.security.EncryptUtil;
import open.dolphin.security.SecurityPrincipal;
import open.dolphin.utils.HibernateUtil;
import org.hibernate.classic.Session;

public class DolphinLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username = null;
    private String password = null;
    private char[] credential;
    private SecurityPrincipal userPrincipal;
    private List<SecurityPrincipal> rolePrincipals = new ArrayList<SecurityPrincipal>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    private void getUserNamePassword() throws LoginException {
        NameCallback nameCallback = new NameCallback("Username: ");
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
        Callback[] callBacks = new Callback[]{nameCallback, passwordCallback};
        try {
            this.callbackHandler.handle(callBacks);
            this.username = nameCallback.getName();
            char[] passwordChars = passwordCallback.getPassword();
            if (passwordChars != null) {
                this.password = new String(passwordChars);
            }
            for (int i = 0; i < passwordChars.length; ++i) {
                passwordChars[i] = 42;
            }
            passwordChars = null;
            passwordCallback.clearPassword();
        }
        catch (IOException exp) {
            LoginException loginException = new LoginException("Failed to get username/password.");
            loginException.initCause(exp);
            throw loginException;
        }
        catch (UnsupportedCallbackException exp) {
            LoginException loginException = new LoginException("Callback Handler does not support.");
            loginException.initCause(exp);
            throw loginException;
        }
        if (this.password == null) {
            throw new LoginException("Failed to get username/password.");
        }
    }

    private void createPasswordHash() {
        this.password = EncryptUtil.createPasswordHash(this.password);
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: No callback handler available.");
        }
        this.getUserNamePassword();
        this.createPasswordHash();
        String expectedPassword = (String)HibernateUtil.getCurrentSesison().createSQLQuery("select password from d_users where userid = :userId").setParameter("userId", (Object)this.username).uniqueResult();
        HibernateUtil.getCurrentSesison().flush();
        this.succeeded = expectedPassword.equals(this.password);
        expectedPassword = null;
        return this.succeeded;
    }

    private List<String> getRoles() {
        Session session = HibernateUtil.getSessionFactory().openSession();
        List role = session.createSQLQuery("select c_role from d_roles where user_id = :userId").setParameter("userId", (Object)this.username).list();
        session.flush();
        session.close();
        return role;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new SecurityPrincipal(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        for (String role : this.getRoles()) {
            SecurityPrincipal rolePrincipal = new SecurityPrincipal(role);
            if (!this.subject.getPrincipals().contains(rolePrincipal)) {
                this.subject.getPrincipals().add(rolePrincipal);
            }
            this.rolePrincipals.add(rolePrincipal);
        }
        this.username = null;
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                this.password = null;
            }
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        for (SecurityPrincipal rolePrincipal : this.rolePrincipals) {
            this.subject.getPrincipals().remove(rolePrincipal);
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.username = null;
        this.password = null;
        this.userPrincipal = null;
        this.rolePrincipals = null;
        return true;
    }
}

