/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.message;

import java.util.List;
import java.util.Set;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.order.OutOfServiceTable;
import open.dolphin.project.GlobalVariables;

public class ClaimHelper {
    private String confirmDate;
    private String creatorId;
    private String creatorName;
    private String creatorDept;
    private String creatorDeptDesc;
    private String creatorLicense;
    private String patientId;
    private String generationPurpose;
    private String docId;
    private String healthInsuranceGUID;
    private String healthInsuranceClassCode;
    private String healthInsuranceDesc;
    private String timeClass;
    private ClaimBundle[] claimBundle;
    private String deptName;
    private String deptCode;
    private String doctorName;
    private String doctorId;
    private String jmariCode;
    private String facilityName;
    private boolean admitFlag;

    public ClaimHelper(DocumentModel sendModel, boolean admitFlag) {
        DocInfoModel docInfo = sendModel.getDocInfo();
        Set<ModuleModel> modules = sendModel.getModules();
        String confirmedStr = ModelUtils.getDateTimeAsString(docInfo.getConfirmDate());
        this.setConfirmDate(confirmedStr);
        this.setCreatorDeptDesc(docInfo.getDepartmentName());
        this.setCreatorDept(docInfo.getDepartmentCode());
        String _doctorName = docInfo.getAssignedDoctorName();
        if (_doctorName == null) {
            _doctorName = GlobalVariables.getUserModel().getCommonName();
        }
        this.setCreatorName(_doctorName);
        String _doctorId = docInfo.getAssignedDoctorId();
        if (_doctorId == null) {
            _doctorId = GlobalVariables.getUserModel().getUserId();
        }
        this.setCreatorId(_doctorId);
        String _jamriCode = docInfo.getJMARICode();
        if (_jamriCode == null) {
            _jamriCode = GlobalVariables.getJMARICode();
        }
        this.setJmariCode(_jamriCode);
        this.setCreatorId(sendModel.getCreator().getUserId());
        this.setCreatorName(sendModel.getCreator().getCommonName());
        this.setCreatorDept(docInfo.getDepartment());
        this.setCreatorDeptDesc(docInfo.getDepartmentDesc());
        this.setCreatorLicense(sendModel.getCreator().getLicenseModel().getLicense());
        this.setGenerationPurpose(docInfo.getPurpose());
        this.setDocId(docInfo.getDocId());
        this.setHealthInsuranceGUID(docInfo.getHealthInsuranceGUID());
        this.setHealthInsuranceClassCode(docInfo.getHealthInsurance());
        this.setHealthInsuranceDesc(docInfo.getHealthInsuranceDesc());
        this.setFacilityName(GlobalVariables.getUserModel().getFacility().getFacilityName());
        this.setPatientId(sendModel.getKarte().getPatient().getPatientId());
        this.setTimeClass("");
        this.setAdmitFlag(admitFlag);
    }

    public Boolean hasTimeClass() {
        if (this.timeClass != null) {
            return !this.timeClass.equals("");
        }
        return false;
    }

    public void setTimeClass(String timeClass) {
        this.timeClass = timeClass;
    }

    public String getTimeClass() {
        return this.timeClass;
    }

    public void setConfirmDate(String confirmDate) {
        this.confirmDate = confirmDate;
    }

    public String getConfirmDate() {
        return this.confirmDate;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorLicense(String creatorLicense) {
        this.creatorLicense = creatorLicense;
    }

    public String getCreatorLicense() {
        return this.creatorLicense;
    }

    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public String getPatientId() {
        return this.patientId;
    }

    public void setGenerationPurpose(String generationPurpose) {
        this.generationPurpose = generationPurpose;
    }

    public String getGenerationPurpose() {
        return this.generationPurpose;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setHealthInsuranceGUID(String healthInsuranceGUID) {
        this.healthInsuranceGUID = healthInsuranceGUID;
    }

    public String getHealthInsuranceGUID() {
        return this.healthInsuranceGUID;
    }

    public void setHealthInsuranceClassCode(String healthInsuranceClassCode) {
        this.healthInsuranceClassCode = healthInsuranceClassCode;
    }

    public String getHealthInsuranceClassCode() {
        return this.healthInsuranceClassCode;
    }

    public void setHealthInsuranceDesc(String healthInsuranceDesc) {
        this.healthInsuranceDesc = healthInsuranceDesc;
    }

    public String getHealthInsuranceDesc() {
        return this.healthInsuranceDesc;
    }

    public void setClaimBundle(ClaimBundle[] claimBundle) {
        this.claimBundle = claimBundle;
    }

    public ClaimBundle[] getClaimBundle() {
        return this.claimBundle;
    }

    public void addClaimBundle(ClaimBundle val) {
        if (this.claimBundle == null) {
            this.claimBundle = new ClaimBundle[1];
            this.claimBundle[0] = val;
        } else {
            int len = this.claimBundle.length;
            ClaimBundle[] dest = new ClaimBundle[len + 1];
            System.arraycopy(this.claimBundle, 0, dest, 0, len);
            this.claimBundle = dest;
            this.claimBundle[len] = val;
        }
        ClaimItem[] claims = val.getClaimItem();
        OutOfServiceTable outOfService = new OutOfServiceTable();
        for (ClaimItem claim : claims) {
            String code = outOfService.timeClass(claim.getCode());
            if (code == null) continue;
            this.setTimeClass(code);
            break;
        }
        for (ClaimItem claim : claims) {
            if (!claim.getClassCode().equals("540")) continue;
            val.setClassCode("540");
            break;
        }
        List<MedicineEntry> alternateEntry = null;
        for (ClaimItem claim : claims) {
            SqlMasterDao dao;
            String alternateCode;
            if (!claim.getCode().startsWith("058") || (alternateCode = (dao = (SqlMasterDao)SqlDaoFactory.create("dao.master")).getIdokanren(claim.getCode())) == null || alternateCode.isEmpty() || alternateCode.equals("000000000") || (alternateEntry = dao.getMedicine(alternateCode)).isEmpty()) continue;
            MedicineEntry entry = alternateEntry.get(0);
            ClaimItem item = new ClaimItem();
            item.setName(entry.getName());
            item.setCode(entry.getCode());
            item.setClassCode(claim.getClassCode());
            item.setClassCodeSystem(claim.getClassCodeSystem());
            item.setNumber(claim.getNumber());
            item.setUnit(entry.getUnit());
            item.setNumberCode(claim.getNumberCode());
            item.setYkzKbn(entry.getYkzKbn());
            item.setKana(entry.getKana());
            item.setStartDate(entry.getStartDate());
            item.setEndDate(entry.getEndDate());
            item.setDisUseDate(entry.getDisUseDate());
            val.addClaimItem(item);
        }
    }

    public String getCreatorDept() {
        return this.creatorDept;
    }

    public void setCreatorDept(String creatorDept) {
        this.creatorDept = creatorDept;
    }

    public String getCreatorDeptDesc() {
        return this.creatorDeptDesc;
    }

    public void setCreatorDeptDesc(String creatorDeptDesc) {
        this.creatorDeptDesc = creatorDeptDesc;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public String getDoctorName() {
        return this.doctorName;
    }

    public void setDoctorName(String doctorName) {
        this.doctorName = doctorName;
    }

    public String getDoctorId() {
        return this.doctorId;
    }

    public void setDoctorId(String doctorId) {
        this.doctorId = doctorId;
    }

    public String getJmariCode() {
        return this.jmariCode;
    }

    public void setJmariCode(String jmariCode) {
        this.jmariCode = jmariCode;
    }

    public String getFacilityName() {
        return this.facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    public boolean getAdmitFlag() {
        return this.admitFlag;
    }

    public void setAdmitFlag(boolean admitFlag) {
        this.admitFlag = admitFlag;
    }
}

