/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import open.dolphin.infomodel.BeanUtils;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.queries.DolphinQuery;
import org.hibernate.lob.BlobImpl;

public class StampModel
extends InfoModel {
    private String id;
    private long userId;
    private String entity;
    private Blob stampBlob;
    private byte[] stampBytes;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userid) {
        this.userId = userid;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public byte[] getStampBytes() {
        return this.stampBytes;
    }

    public void setStampBytes(byte[] stampBytes) {
        this.stampBytes = stampBytes;
        if (stampBytes == null) {
            stampBytes = null;
        } else {
            this.stampBlob = new BlobImpl(stampBytes);
        }
    }

    public Blob getStampBlob() {
        return this.stampBlob;
    }

    public void setStampBlob(Blob stampBlob) throws SQLException {
        if (stampBlob != null) {
            this.stampBlob = stampBlob;
            this.stampBytes = stampBlob.getBytes(1L, (int)stampBlob.length());
        }
    }

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public void initialize(String id, long userId, String entity, byte[] stampBytes) throws SQLException {
        this.setId(id);
        this.setUserId(userId);
        this.setEntity(entity);
        this.setStampBytes(stampBytes);
    }

    public void initialize(String id, long userId, String entity, String stampXml) {
        this.setId(id);
        this.setUserId(userId);
        this.setEntity(entity);
        this.setXml(stampXml);
    }

    public String getXml() {
        if (this.stampBytes != null) {
            try {
                return new String(this.stampBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }

    public void setXml(String xml) {
        if (xml != null) {
            try {
                this.stampBytes = xml.getBytes("UTF-8");
                this.stampBlob = this.stampBytes == null ? null : new BlobImpl(this.stampBytes);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public IInfoModel toInfoModel() {
        return (IInfoModel)BeanUtils.xmlDecode(this.getStampBytes());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StampModel other = (StampModel)obj;
        return this.getId().equals(other.getId());
    }

    public void serialize(Writer result) throws IOException {
    }

    public void deserialize(Writer result) throws IOException {
    }
}

