/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import open.dolphin.infomodel.BundleMed;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.GenericAdapter;
import open.dolphin.infomodel.MasterEntry;
import open.dolphin.utils.DateExpire;
import open.dolphin.utils.StringTool;

public class MasterItem
implements Serializable {
    private static final long serialVersionUID = -6359300744722498857L;
    private int classCode;
    private String name;
    private String code;
    private String masterTableId;
    private String number;
    private String unit;
    private String claimDiseaseCode;
    private String claimClassCode;
    private String ykzKbn;
    private String dummy;
    private String bundleNumber;
    private List<String> sstKijunCdSet;
    private String kana;
    private String startDate;
    private String endDate;
    private String disUseDate;
    private static final String ADMIN_MARK = "[\u7528\u6cd5] ";

    public MasterItem(int classCode, MasterEntry entry) {
        this.setClassCode(classCode);
        this.setCode(entry.getCode());
        this.setName(entry.getName());
        this.setKana(entry.getKana());
        this.setStartDate(entry.getStartDate());
        this.setEndDate(entry.getEndDate());
        this.setDisUseDate(entry.getDisUseDate());
    }

    public MasterItem(int classCode, ClaimItem item) {
        this.setClassCode(classCode);
        this.setCode(item.getCode());
        this.setName(item.getName());
        this.setKana(item.getKana());
        this.setStartDate(item.getStartDate());
        this.setEndDate(item.getEndDate());
        this.setDisUseDate(item.getDisUseDate());
    }

    public MasterItem(int classCode, BundleMed item) {
        this.setClassCode(classCode);
        this.setCode(item.getAdminCode());
        this.setName(ADMIN_MARK + item.getAdmin());
        this.setDummy("X");
    }

    public String toString() {
        return this.getName();
    }

    public void setClassCode(int classCode) {
        this.classCode = classCode;
    }

    public int getClassCode() {
        return this.classCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setMasterTableId(String masterTableId) {
        this.masterTableId = masterTableId;
    }

    public String getMasterTableId() {
        return this.masterTableId;
    }

    public void setNumber(String number) {
        this.number = StringTool.zenkakuNumToHankaku(number.trim());
    }

    public String getNumber() {
        return this.number;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setClaimDiseaseCode(String claimDiseaseCode) {
        this.claimDiseaseCode = claimDiseaseCode;
    }

    public String getClaimDiseaseCode() {
        return this.claimDiseaseCode;
    }

    public void setClaimClassCode(String claimClassCode) {
        this.claimClassCode = claimClassCode;
    }

    public String getClaimClassCode() {
        return this.claimClassCode;
    }

    public String getYkzKbn() {
        return this.ykzKbn;
    }

    public void setYkzKbn(String ykzKbn) {
        this.ykzKbn = ykzKbn;
    }

    public String getDummy() {
        return this.dummy;
    }

    public void setDummy(String dummy) {
        this.dummy = dummy;
    }

    public String getBundleNumber() {
        return this.bundleNumber;
    }

    public void setBundleNumber(String bundleNumber) {
        this.bundleNumber = bundleNumber;
    }

    public List<String> getSstKijunCdSet() {
        return this.sstKijunCdSet;
    }

    public void setSstKijunCdSet(List<String> ary) {
        this.sstKijunCdSet = ary;
    }

    public String getKana() {
        return this.kana;
    }

    private void setKana(String kana) {
        this.kana = kana;
    }

    public String getStartDate() {
        return this.startDate;
    }

    private void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    private void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getDisUseDate() {
        return this.disUseDate;
    }

    private void setDisUseDate(String disUseDate) {
        this.disUseDate = disUseDate;
    }

    protected boolean isExpired() {
        return DateExpire.expire(this.startDate, this.endDate);
    }

    public boolean isUpdateAvailable(Map<String, String> resultSet, GenericAdapter adapter) {
        try {
            adapter.onResult(this.getCode(), resultSet);
            if (resultSet != null && !resultSet.isEmpty()) {
                return true;
            }
        }
        catch (Exception ex) {
            adapter.onError(ex);
        }
        return false;
    }
}

