/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater.error.processor;

import open.dolphin.delegater.BusinessDelegater;
import open.dolphin.log.LogWriter;

public abstract class DelegatingErrorProcessor {
    private String errorMessages;
    private final Exception originalException;
    private BusinessDelegater ownerDelegater;

    public DelegatingErrorProcessor(BusinessDelegater owner, Exception exception) {
        this.originalException = exception;
        this.ownerDelegater = owner;
    }

    public BusinessDelegater getOwnerDelegater() {
        return this.ownerDelegater;
    }

    public void process(String message) {
        LogWriter.error(this.getOwnerDelegater().getClass(), this.getDefaultLogMessage(), (Throwable)this.getOriginalException());
        if (message == null) {
            this.setErrorMessage(this.getDefaultMessage());
        } else {
            this.setErrorMessage(message);
        }
    }

    public abstract String getDefaultMessage();

    public abstract String getDefaultLogMessage();

    public Exception getOriginalException() {
        return this.originalException;
    }

    public boolean isError() {
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessages;
    }

    public void setErrorMessage(String message) {
        this.errorMessages = message;
    }
}

