/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater;

import java.lang.reflect.UndeclaredThrowableException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import open.dolphin.delegater.error.processor.CommunicationErrorProcessor;
import open.dolphin.delegater.error.processor.DelegatingErrorProcessor;
import open.dolphin.delegater.error.processor.NamingErrorProcessor;
import open.dolphin.delegater.error.processor.NoErrorProcessor;
import open.dolphin.delegater.error.processor.SeutityErrorProcessor;
import open.dolphin.delegater.error.processor.UnKnownErrorprocessor;
import open.dolphin.delegater.error.processor.UndeclaredErrorProcessor;

public abstract class BusinessDelegater {
    private DelegatingErrorProcessor errorProcessor = new NoErrorProcessor();

    public boolean isError() {
        return this.errorProcessor.isError();
    }

    public boolean isNoError() {
        return !this.isError();
    }

    public String getErrorMessage() {
        if (this.isError()) {
            return this.errorProcessor.getErrorMessage();
        }
        return null;
    }

    public void processError(Exception exception) {
        this.processError(exception, null);
    }

    public void processError(Exception exception, String message) {
        this.errorProcessor = exception instanceof CommunicationException ? new CommunicationErrorProcessor(this, exception) : (exception instanceof LoginException ? new SeutityErrorProcessor(this, exception) : (exception instanceof UndeclaredThrowableException ? new UndeclaredErrorProcessor(this, exception) : (exception instanceof NamingException ? new NamingErrorProcessor(this, exception) : new UnKnownErrorprocessor(this, exception))));
        this.errorProcessor.process(message);
    }
}

