/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import open.dolphin.client.DoBodyObject;
import open.dolphin.container.Pair;
import open.dolphin.dao.OrcaUnitTranslater;
import open.dolphin.dao.SqlDaoBean;
import open.dolphin.infomodel.AdminEntry;
import open.dolphin.infomodel.DiseaseEntry;
import open.dolphin.infomodel.GenericAdapter;
import open.dolphin.infomodel.InteractEntry;
import open.dolphin.infomodel.MasterEntry;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.infomodel.SsKijyoEntry;
import open.dolphin.infomodel.ToolMaterialEntry;
import open.dolphin.infomodel.TreatmentEntry;
import open.dolphin.order.ClaimConst;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.DateExpire;
import open.dolphin.utils.StringTool;

public final class SqlMasterDao
extends SqlDaoBean {
    private static final String YKZKBN = "4";
    private int totalCount;
    private static final String CODE_FILLER = "ZZZ";
    private static final String PREFIX_CODE1 = "ZZZ1";
    private static final String PREFIX_CODE2 = "ZZZ2";
    private static final String TYPE_CODE1 = "ZZZ3";
    private static final String TYPE_CODE2 = "ZZZ4";
    private static final String PART_CODE = "ZZZ7";
    private static final String POSTFIX_CODE = "ZZZ8";

    public int getTotalCount() {
        return this.totalCount;
    }

    public String toLongCode(String code) {
        if (code.length() == 4) {
            return CODE_FILLER + code;
        }
        return code;
    }

    public String getSerchClass(String code) {
        String longCode = this.toLongCode(code).substring(0, 4);
        if (longCode.equals(PREFIX_CODE1) || longCode.equals(PREFIX_CODE2)) {
            return ClaimConst.SubTypeSet.PREFIX.getName();
        }
        if (longCode.equals(TYPE_CODE1) || longCode.equals(TYPE_CODE2)) {
            return ClaimConst.SubTypeSet.TYPE.getName();
        }
        if (longCode.equals(PART_CODE)) {
            return ClaimConst.SubTypeSet.PART.getName();
        }
        if (longCode.equals(POSTFIX_CODE)) {
            return ClaimConst.SubTypeSet.POSTFIX.getName();
        }
        return "";
    }

    public List getByName(String master, String name, boolean startsWith, String serchClassCode, String sortBy, String order) {
        List<MasterEntry> results = null;
        String zenkakuRoman = StringTool.toZenkakuUpperLower(name);
        if (master.equals(ClaimConst.MasterSet.DIAGNOSIS.getName())) {
            if (serchClassCode.equals("")) {
                results = StringTool.isAllDigit(name) ? this.getDiseaseByCode(name, startsWith, sortBy, order) : this.getDiseaseByName(name, startsWith, sortBy, order);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.NAMES.getName())) {
                results = this.getDiseaseNames(name);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.PREFIX.getName())) {
                results = this.getDiseasePrefix(name, sortBy);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.TYPE.getName())) {
                results = this.getDiseaseType(name, sortBy);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.PART.getName())) {
                results = this.getDiseasePart(name, sortBy);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.POSTFIX.getName())) {
                results = this.getDiseasePostfix(name, sortBy);
            }
        } else if (master.equals(ClaimConst.MasterSet.MEDICAL_SUPPLY.getName())) {
            if (serchClassCode.equals("20")) {
                results = this.getMedicineByName(zenkakuRoman, startsWith, sortBy, order);
            } else if (serchClassCode.equals("40")) {
                results = this.getInjectionByName(zenkakuRoman, startsWith, sortBy, order);
            }
        } else if (master.equals(ClaimConst.MasterSet.TREATMENT.getName())) {
            results = this.getTreatmentByName(zenkakuRoman, startsWith, serchClassCode, sortBy, order);
        } else if (master.equals(ClaimConst.MasterSet.TOOL_MATERIAL.getName())) {
            results = this.getToolMaterialByName(zenkakuRoman, startsWith, sortBy, order);
        } else if (master.equals(ClaimConst.MasterSet.ADMINISTRATION.getName())) {
            results = this.getAdminByName(zenkakuRoman, startsWith, sortBy, order);
        } else {
            throw new RuntimeException("Unsupported master: " + master);
        }
        return results;
    }

    private List<DiseaseEntry> getDiseaseByName(String text, boolean startsWith, String sortBy, String order) {
        List<DiseaseEntry> ret = null;
        String sql = null;
        if (!startsWith) {
            sql = this.buildDiseaseSql("byomei ~ ", text, sortBy, order, true);
            ret = this.getDiseaseCollection(sql);
        }
        if (this.isNoError() && (ret == null || ret.isEmpty())) {
            sql = this.buildDiseaseSql("byomei ~ ", text, sortBy, order, false);
            ret = this.getDiseaseCollection(sql);
        }
        return ret;
    }

    private List<DiseaseEntry> getDiseaseByCode(String text, boolean startsWith, String sortBy, String order) {
        List<DiseaseEntry> ret = null;
        String sql = null;
        if (!startsWith) {
            sql = this.buildDiseaseSql("byomeicd ~ ", text, sortBy, order, true);
            ret = this.getDiseaseCollection(sql);
        }
        if (this.isNoError() && (ret == null || ret.isEmpty())) {
            sql = this.buildDiseaseSql("byomeicd ~ ", text, sortBy, order, true);
            ret = this.getDiseaseCollection(sql);
        }
        return ret;
    }

    private List<DiseaseEntry> getDiseaseNames(String text) {
        int end_index;
        ArrayList<DiseaseEntry> result = new ArrayList<DiseaseEntry>();
        String key = text;
        ArrayList<String> keyList = new ArrayList<String>();
        int start_index = 0;
        while (key.length() != 0 && (end_index = this.matchMostLongKeyword(key)) != 0) {
            keyList.add(key.substring(start_index, end_index));
            key = key.substring(end_index, key.length());
        }
        for (String _key : keyList) {
            List<DiseaseEntry> diseases = this.getDiseaseName(_key);
            result.addAll(diseases);
        }
        return result;
    }

    private int matchMostLongKeyword(String text) {
        int index;
        List<DiseaseEntry> result = null;
        for (index = 0; index < text.length(); ++index) {
            String key = text.substring(0, index + 1);
            result = this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10, haisiymd from tbl_byomei where byomei ~ '^" + key + "'");
            if (result.isEmpty()) break;
        }
        return index;
    }

    private List<DiseaseEntry> getDiseaseName(String text) {
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10, haisiymd from tbl_byomei where byomei = '" + text + "'");
    }

    public List<DiseaseEntry> getDiseaseCode(String text) {
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10, haisiymd from tbl_byomei where byomeicd = '" + this.toLongCode(text) + "'");
    }

    private List<DiseaseEntry> getDiseasePrefix(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        String query = "select byomeicd, byomei, byomeikana, icd10, haisiymd from tbl_byomei where byomeicd ~ '^ZZZ1' or byomeicd ~ '^ZZZ2'" + order;
        if (!StringTool.isEmptyString(text)) {
            query = "select byomeicd, byomei, byomeikana, icd10, haisiymd from tbl_byomei where (byomei ~ '" + text + "') and (byomeicd ~ '^" + PREFIX_CODE1 + "' or byomeicd ~ '^" + PREFIX_CODE2 + "')" + order;
        }
        return this.getDiseaseCollection(query);
    }

    private List<DiseaseEntry> getDiseaseType(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10, haisiymd from tbl_byomei where (byomei ~ '" + text + "') and (byomeicd ~ '^" + TYPE_CODE1 + "' or byomeicd ~ '^" + TYPE_CODE2 + "')" + order);
    }

    private List<DiseaseEntry> getDiseasePart(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10, haisiymd from tbl_byomei where (byomei ~ '" + text + "') and byomeicd ~ '^" + PART_CODE + "'" + order);
    }

    private List<DiseaseEntry> getDiseasePostfix(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        return this.getDiseaseCollection("select byomeicd, byomei, byomeikana, icd10, haisiymd from tbl_byomei where (byomei ~ '" + text + "') and byomeicd ~ '^" + POSTFIX_CODE + "'" + order);
    }

    private String buildDiseaseSql(String field, String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select byomeicd, byomei, byomeikana, icd10, haisiymd from tbl_byomei where ");
        word = text;
        buf.append(field);
        if (forward) {
            buf.append(this.addSingleQuote("^" + word));
        } else {
            buf.append(this.addSingleQuote(word));
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by byomeikana";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        this.debug(sql);
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DiseaseEntry> getDiseaseCollection(String sql) {
        Connection con = null;
        ArrayList<DiseaseEntry> collection = null;
        ArrayList<DiseaseEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            DiseaseEntry de = null;
            collection = new ArrayList<DiseaseEntry>();
            outUse = new ArrayList<DiseaseEntry>();
            while (rs.next()) {
                de = new DiseaseEntry();
                de.setCode(rs.getString(1));
                de.setName(rs.getString(2));
                de.setKana(rs.getString(3));
                de.setIcdTen(rs.getString(4));
                de.setDisUseDate(rs.getString(5));
                if (de.isInUse()) {
                    collection.add(de);
                    continue;
                }
                outUse.add(de);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            ArrayList<DiseaseEntry> arrayList = collection;
            return arrayList;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeConnection(con);
            this.closeStatement(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MedicineEntry> getMedicine(String code) {
        final ArrayList<MedicineEntry> collection = new ArrayList<MedicineEntry>();
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd,name,kananame,tanicd,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd = ");
        sql.append(this.addSingleQuote(code));
        this.executeQuery(sql.toString(), null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                if (!DateExpire.expire(records.getString(9), records.getString(10))) {
                    MedicineEntry me = new MedicineEntry();
                    me.setCode(records.getString(1));
                    me.setName(records.getString(2));
                    me.setKana(records.getString(3));
                    me.setUnit(OrcaUnitTranslater.toName(records.getString(4)));
                    me.setCostFlag(records.getString(5));
                    me.setCost(records.getString(6));
                    me.setYkzKbn(records.getString(7));
                    me.setJNCD(records.getString(8));
                    me.setStartDate(records.getString(9));
                    me.setEndDate(records.getString(10));
                    collection.add(me);
                }
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    private List<MedicineEntry> getMedicineByName(String text, boolean startsWith, String sortBy, String order) {
        String sql = this.getMedicineSql(text, sortBy, order, startsWith);
        List<MedicineEntry> ret = this.getMedicineCollection(sql);
        return ret;
    }

    private String getMedicineSql(String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd,name,kananame,taniname,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd ~ '^6' and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            sql.append("srycd ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            sql.append("(name ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(" or formalname ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(") ");
        }
        sql.append(" and ykzkbn != ");
        sql.append(this.addSingleQuote(YKZKBN));
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        sql.append(orderBy);
        this.printTrace(sql.toString());
        return sql.toString();
    }

    private List<MedicineEntry> getMedicineCollection(String sql) {
        Connection con = null;
        ArrayList<MedicineEntry> collection = null;
        ArrayList<MedicineEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            MedicineEntry medicine = null;
            collection = new ArrayList<MedicineEntry>();
            outUse = new ArrayList<MedicineEntry>();
            while (rs.next()) {
                medicine = new MedicineEntry();
                medicine.setCode(rs.getString(1));
                medicine.setName(rs.getString(2));
                medicine.setKana(rs.getString(3));
                medicine.setUnit(rs.getString(4));
                medicine.setCostFlag(rs.getString(5));
                medicine.setCost(rs.getString(6));
                medicine.setYkzKbn(rs.getString(7));
                medicine.setJNCD(rs.getString(8));
                medicine.setStartDate(rs.getString(9));
                medicine.setEndDate(rs.getString(10));
                if (medicine.isInUse()) {
                    collection.add(medicine);
                    continue;
                }
                outUse.add(medicine);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    private List<MedicineEntry> getInjectionByName(String text, boolean startsWith, String sortBy, String order) {
        String sql = this.getInjectionSql(text, sortBy, order, startsWith);
        List<MedicineEntry> ret = this.getInjectionCollection(sql);
        return ret;
    }

    private String getInjectionSql(String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd,name,kananame,taniname,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("(srycd ~ ").append(this.addSingleQuote("^09930")).append(" or ");
        sql.append("(srycd ~ '^6' and ykzkbn = ");
        sql.append(this.addSingleQuote(YKZKBN));
        sql.append(")) and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            sql.append("srycd ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            sql.append("(name ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(" or formalname ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(") ");
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        sql.append(orderBy);
        this.printTrace(sql.toString());
        return sql.toString();
    }

    private List<MedicineEntry> getInjectionCollection(String sql) {
        Connection con = null;
        ArrayList<MedicineEntry> collection = null;
        ArrayList<MedicineEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            MedicineEntry me = null;
            collection = new ArrayList<MedicineEntry>();
            outUse = new ArrayList<MedicineEntry>();
            while (rs.next()) {
                me = new MedicineEntry();
                me.setCode(rs.getString(1));
                me.setName(rs.getString(2));
                me.setKana(rs.getString(3));
                me.setUnit(rs.getString(4));
                me.setCostFlag(rs.getString(5));
                me.setCost(rs.getString(6));
                me.setYkzKbn(rs.getString(7));
                me.setJNCD(rs.getString(8));
                me.setStartDate(rs.getString(9));
                me.setEndDate(rs.getString(10));
                if (me.isInUse()) {
                    collection.add(me);
                    continue;
                }
                outUse.add(me);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    private List<TreatmentEntry> getTreatmentByName(String text, boolean startsWith, String orderClassCode, String sortBy, String order) {
        String sql = this.getTreatmentSql(text, orderClassCode, sortBy, order, startsWith);
        List<TreatmentEntry> ret = this.getTreatmentCollection(sql);
        return ret;
    }

    private String getTreatmentSql(String text, String orderClassCode, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,formalname,tensikibetu,ten,nyugaitekkbn,routekkbn,srysyukbn,hospsrykbn,yukostymd,yukoedymd ");
        buf.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        buf.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("( (srycd ~ '^095') or ");
        buf.append("(srycd ~ '^096') or ");
        buf.append("(srycd ~ '^0082') or ");
        buf.append("(srycd ~ '^0083') or ");
        buf.append("(srycd ~ '^0084') or ");
        buf.append("(srycd ~ '^0085') or ");
        buf.append("(srycd ~ '^810000001') or ");
        buf.append("(srycd ~ '^82') or ");
        buf.append("(srycd ~ '^83') or ");
        buf.append("(srycd ~ '^84') or ");
        buf.append("(srycd ~ '^85') or ");
        buf.append("(srycd ~ '^09930') or ");
        buf.append("(srycd ~ '^1' or srycd ~ '^00' ");
        StringBuilder sbd = new StringBuilder();
        if (orderClassCode != null) {
            String[] cClass = new String[]{"", ""};
            int index = 0;
            StringTokenizer tokenizer = new StringTokenizer(orderClassCode, "-");
            while (tokenizer.hasMoreTokens()) {
                cClass[index++] = tokenizer.nextToken();
            }
            String min = cClass[0];
            String max = cClass[1];
            if (!min.equals("") && max.equals("")) {
                sbd.append(" and srysyukbn = ");
                sbd.append(this.addSingleQuote(min));
            } else if (!min.equals("") && !max.equals("")) {
                sbd.append(" and srysyukbn >= ");
                sbd.append(this.addSingleQuote(min));
                sbd.append(" and srysyukbn <= ");
                sbd.append(this.addSingleQuote(max));
            }
        }
        String sql2 = sbd.toString();
        buf.append(sql2);
        buf.append(" ) ) and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            buf.append("srycd ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            buf.append("(name ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(" or formalname ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(") ");
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        this.printTrace(sql);
        return sql;
    }

    private List<TreatmentEntry> getTreatmentCollection(String sql) {
        Connection con = null;
        ArrayList<TreatmentEntry> collection = null;
        ArrayList<TreatmentEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            TreatmentEntry te = null;
            collection = new ArrayList<TreatmentEntry>();
            outUse = new ArrayList<TreatmentEntry>();
            while (rs.next()) {
                te = new TreatmentEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                te.setKana(rs.getString(3));
                te.setCostFlag(rs.getString(4));
                te.setCost(rs.getString(5));
                te.setInOutFlag(rs.getString(6));
                te.setOldFlag(rs.getString(7));
                te.setClaimClassCode(rs.getString(8));
                te.setHospitalClinicFlag(rs.getString(9));
                te.setStartDate(rs.getString(10));
                te.setEndDate(rs.getString(11));
                ArrayList<String> ary = new ArrayList<String>();
                for (int i = 0; i < 10; ++i) {
                    ary.add(rs.getString(i + 12));
                }
                te.setSstKijunCdSet(ary);
                if (te.isInUse()) {
                    collection.add(te);
                    continue;
                }
                outUse.add(te);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    public List<TreatmentEntry> getByClaimClass(String master, String claimClass, String sortBy, String order) {
        Connection con = null;
        ArrayList<TreatmentEntry> collection = null;
        ArrayList<TreatmentEntry> outUse = null;
        Statement st = null;
        String[] cClass = new String[]{"", ""};
        int index = 0;
        StringTokenizer tokenizer = new StringTokenizer(claimClass, "-");
        while (tokenizer.hasMoreTokens()) {
            cClass[index++] = tokenizer.nextToken();
        }
        String min = cClass[0];
        String max = cClass[1];
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,kananame,tensikibetu,ten,nyugaitekkbn,routekkbn,srysyukbn,hospsrykbn,yukostymd,yukoedymd ");
        buf.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        buf.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("(srycd ~ '^095') or ");
        buf.append("(srycd ~ '^096') or ");
        buf.append("(srycd ~ '^0082') or ");
        buf.append("(srycd ~ '^0083') or ");
        buf.append("(srycd ~ '^0084') or ");
        buf.append("(srycd ~ '^0085') or ");
        buf.append("(srycd ~ '^810000001') or ");
        buf.append("(srycd ~ '^82') or ");
        buf.append("(srycd ~ '^83') or ");
        buf.append("(srycd ~ '^84') or ");
        buf.append("(srycd ~ '^85') or ");
        buf.append("(srycd ~ '^09930') or ");
        buf.append("(srycd ~ '^1' ");
        if (!min.equals("") && max.equals("")) {
            buf.append(" and srysyukbn = ");
            buf.append(this.addSingleQuote(min));
        } else if (!min.equals("") && !max.equals("")) {
            buf.append(" and srysyukbn >= ");
            buf.append(this.addSingleQuote(min));
            buf.append(" and srysyukbn <= ");
            buf.append(this.addSingleQuote(max));
        }
        buf.append(" ) ");
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy != null) {
            buf.append(orderBy);
        } else {
            buf.append(" order by srycd");
        }
        String sql = buf.toString();
        this.printTrace(sql);
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            TreatmentEntry te = null;
            collection = new ArrayList<TreatmentEntry>();
            outUse = new ArrayList<TreatmentEntry>();
            while (rs.next()) {
                te = new TreatmentEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                te.setKana(rs.getString(3));
                te.setCostFlag(rs.getString(4));
                te.setCost(rs.getString(5));
                te.setInOutFlag(rs.getString(6));
                te.setOldFlag(rs.getString(7));
                te.setClaimClassCode(rs.getString(8));
                te.setHospitalClinicFlag(rs.getString(9));
                te.setStartDate(rs.getString(10));
                te.setEndDate(rs.getString(11));
                ArrayList<String> ary = new ArrayList<String>();
                for (int i = 0; i < 10; ++i) {
                    ary.add(rs.getString(i + 12));
                }
                te.setSstKijunCdSet(ary);
                if (te.isInUse()) {
                    collection.add(te);
                    continue;
                }
                outUse.add(te);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    public List<TreatmentEntry> getRadLocation(String master, String sortBy, String order) {
        Connection con = null;
        ArrayList<TreatmentEntry> collection = null;
        ArrayList<TreatmentEntry> outUse = null;
        Statement st = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,kananame,srysyukbn,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("srycd ~ '^002'");
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy != null) {
            buf.append(orderBy);
        } else {
            buf.append(" order by srycd");
        }
        String sql = buf.toString();
        this.printTrace(sql);
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            TreatmentEntry te = null;
            collection = new ArrayList<TreatmentEntry>();
            outUse = new ArrayList<TreatmentEntry>();
            while (rs.next()) {
                te = new TreatmentEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                te.setKana(rs.getString(3));
                te.setClaimClassCode(rs.getString(4));
                te.setStartDate(rs.getString(5));
                te.setEndDate(rs.getString(6));
                if (te.isInUse()) {
                    collection.add(te);
                    continue;
                }
                outUse.add(te);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    private List<ToolMaterialEntry> getToolMaterialByName(String text, boolean startsWith, String sortBy, String order) {
        String sql = this.getToolMaterialSql(text, sortBy, order, startsWith);
        List<ToolMaterialEntry> ret = this.getToolMaterialCollection(sql);
        return ret;
    }

    private String getToolMaterialSql(String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,kananame,taniname,tensikibetu,ten,yukostymd,yukoedymd,idokanren from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("(srycd ~ '^7' or srycd ~ '^058' or srycd ~ '^059') and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            buf.append("srycd ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            buf.append("(name ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(" or formalname ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(") ");
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        this.printTrace(sql);
        return sql;
    }

    private List<ToolMaterialEntry> getToolMaterialCollection(String sql) {
        Connection con = null;
        ArrayList<ToolMaterialEntry> collection = null;
        ArrayList<ToolMaterialEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            ToolMaterialEntry te = null;
            collection = new ArrayList<ToolMaterialEntry>();
            outUse = new ArrayList<ToolMaterialEntry>();
            while (rs.next()) {
                te = new ToolMaterialEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                te.setKana(rs.getString(3));
                te.setUnit(rs.getString(4));
                te.setCostFlag(rs.getString(5));
                te.setCost(rs.getString(6));
                te.setStartDate(rs.getString(7));
                te.setEndDate(rs.getString(8));
                te.setRequiredMaterialCode(rs.getString(9));
                if (te.isInUse()) {
                    collection.add(te);
                    continue;
                }
                outUse.add(te);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ToolMaterialEntry> getToolMaterialByCode(String code) {
        final ArrayList<ToolMaterialEntry> collection = new ArrayList<ToolMaterialEntry>();
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,kananame,tanicd,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("srycd = ");
        buf.append(this.addSingleQuote(code));
        String sql = buf.toString();
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                if (!DateExpire.expire(records.getString(9), records.getString(10))) {
                    ToolMaterialEntry me = new ToolMaterialEntry();
                    me.setCode(records.getString(1));
                    me.setName(records.getString(2));
                    me.setKana(records.getString(3));
                    me.setUnit(OrcaUnitTranslater.toName(records.getString(4)));
                    me.setCostFlag(records.getString(5));
                    me.setCost(records.getString(6));
                    me.setStartDate(records.getString(9));
                    me.setEndDate(records.getString(10));
                    collection.add(me);
                }
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    private List<AdminEntry> getAdminByName(String text, boolean startsWith, String sortBy, String order) {
        String sql = this.getAdminByNameSql(text, sortBy, order, startsWith);
        List<AdminEntry> ret = this.getAdminCollection(sql);
        return ret;
    }

    private String getAdminByNameSql(String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd, name ");
        buf.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        buf.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append(" ( ");
        buf.append("srycd ~ '^001' or ");
        buf.append("srycd ~ '^810000001$' or ");
        buf.append("srycd ~ '^0082' or srycd ~ '^82' or ");
        buf.append("srycd ~ '^0083' or srycd ~ '^83' or ");
        buf.append("srycd ~ '^0084' or srycd ~ '^84' or ");
        buf.append("srycd ~ '^0085' or srycd ~ '^85' ");
        buf.append(" ) and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            buf.append("srycd ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            buf.append("(name ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(" or formalname ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(") ");
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        this.printTrace(sql);
        return sql;
    }

    private List<AdminEntry> getAdminCollection(String sql) {
        Connection con = null;
        ArrayList<AdminEntry> collection = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            AdminEntry te = null;
            collection = new ArrayList<AdminEntry>();
            while (rs.next()) {
                te = new AdminEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                ArrayList<String> ary = new ArrayList<String>();
                for (int i = 0; i < 10; ++i) {
                    ary.add(rs.getString(i + 3));
                }
                te.setSstKijunCdSet(ary);
                collection.add(te);
            }
            rs.close();
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    public List<AdminEntry> getAdminByCategory(String category) {
        Connection con = null;
        ArrayList<AdminEntry> collection = null;
        Statement st = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd, name ");
        sql.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        sql.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append(" ( srycd ~ '^");
        int index = category.indexOf(32);
        if (index > 0) {
            String s1 = category.substring(0, index);
            String s2 = category.substring(index + 1);
            sql.append(s1);
            sql.append("' or srycd ~ '^");
            sql.append(s2);
            sql.append("'");
        } else {
            sql.append(category);
            sql.append("'");
        }
        sql.append(" or ");
        sql.append("srycd ~ '^810000001$' or ");
        sql.append("srycd ~ '^0082' or srycd ~'^82' or ");
        sql.append("srycd ~ '^0083' or srycd ~'^83' or ");
        sql.append("srycd ~ '^0084' or srycd ~'^84')");
        sql.append(" order by srycd");
        this.printTrace(sql.toString());
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            AdminEntry te = null;
            collection = new ArrayList<AdminEntry>();
            while (rs.next()) {
                te = new AdminEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                collection.add(te);
            }
            rs.close();
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    private String getOrderBy(String sortBy, String order) {
        StringBuilder buf = null;
        if (sortBy != null) {
            buf = new StringBuilder();
            buf.append(" order by ");
            buf.append(sortBy);
        }
        if (order != null) {
            buf.append(" ");
            buf.append(order);
        }
        return buf != null ? buf.toString() : null;
    }

    public List<Pair<String, String>> getNameByCodes(String code) {
        final ArrayList<Pair<String, String>> collection = new ArrayList<Pair<String, String>>();
        String sql = "select srycd, name from tbl_tensu where srycd = " + this.addSingleQuote(code);
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(new Pair<String, String>(records.getString(1), records.getString(2)));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    public String getNameByCode(String code) {
        Pair<String, String> codePair;
        List<Pair<String, String>> codes = this.getNameByCodes(code);
        if (!codes.isEmpty() && (codePair = codes.get(0)) != null) {
            return (String)codePair.value;
        }
        return "";
    }

    private List<InteractEntry> getInteract(String code) {
        final ArrayList<InteractEntry> collection = new ArrayList<InteractEntry>();
        String sql = "select drugcd, drugcd2, syojyoucd from tbl_interact where drugcd = " + this.addSingleQuote(code);
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(new InteractEntry(records.getString(1), records.getString(2), records.getString(3)));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    public List<SsKijyoEntry> getSsKijyo(String code) {
        final ArrayList<SsKijyoEntry> collection = new ArrayList<SsKijyoEntry>();
        String sql = "select syojyoucd, syojyou, sayokijyo from tbl_sskijyo where syojyoucd = " + this.addSingleQuote(code);
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(new SsKijyoEntry(records.getString(1), records.getString(2), records.getString(3)));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    public void getSsKijyoEntry(String interact_code, List<String> onKarteCode, List<Pair<InteractEntry, SsKijyoEntry>> symptoms) {
        List<InteractEntry> interactsFrom = this.getInteract(interact_code);
        for (InteractEntry interact : interactsFrom) {
            for (String code : onKarteCode) {
                if (!interact.getPharmaceuticalsCodeTo().equals(code)) continue;
                List<SsKijyoEntry> sskijyos = this.getSsKijyo(interact.getSymptomsCode());
                for (SsKijyoEntry sskijyo : sskijyos) {
                    symptoms.add(new Pair<InteractEntry, SsKijyoEntry>(interact, sskijyo));
                }
            }
        }
    }

    public boolean getAlternateEntry(String code, List<MedicineEntry> collection) {
        if (this.getAlternateEntryAtOriginal(code, collection)) {
            return false;
        }
        ArrayList<String> alternateCodes = new ArrayList<String>();
        if (this.getUpdates(code, alternateCodes)) {
            for (String alternateCode : alternateCodes) {
                if (!this.getAlternateEntryAtOriginal(alternateCode, collection)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getAlternateEntryAtOriginal(String code, final List<MedicineEntry> collection) {
        String sql = "select srycd,name,kananame,tanicd,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where srycd= " + this.addSingleQuote(code) + " order by yukoedymd desc offset 0 limit 1";
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                if (!DateExpire.expire(records.getString(9), records.getString(10))) {
                    MedicineEntry me = new MedicineEntry();
                    me.setCode(records.getString(1));
                    me.setName(records.getString(2));
                    me.setKana(records.getString(3));
                    me.setUnit(OrcaUnitTranslater.toName(records.getString(4)));
                    me.setCostFlag(records.getString(5));
                    me.setCost(records.getString(6));
                    me.setYkzKbn(records.getString(7));
                    me.setJNCD(records.getString(8));
                    me.setStartDate(records.getString(9));
                    me.setEndDate(records.getString(10));
                    collection.add(me);
                }
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return !collection.isEmpty();
    }

    public boolean getMedicineEntry(String code, final List<MedicineEntry> collection) {
        String sql = "select srycd,name,kananame,tanicd,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where srycd= " + this.addSingleQuote(code) + " order by yukoedymd desc offset 0 limit 1";
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                if (!DateExpire.expire(records.getString(9), records.getString(10))) {
                    MedicineEntry me = new MedicineEntry();
                    me.setCode(records.getString(1));
                    me.setName(records.getString(2));
                    me.setKana(records.getString(3));
                    me.setUnit(OrcaUnitTranslater.toName(records.getString(4)));
                    me.setCostFlag(records.getString(5));
                    me.setCost(records.getString(6));
                    me.setYkzKbn(records.getString(7));
                    me.setJNCD(records.getString(8));
                    me.setStartDate(records.getString(9));
                    me.setEndDate(records.getString(10));
                    collection.add(me);
                }
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return !collection.isEmpty();
    }

    private boolean getUpdates(String code, final List<String> collection) {
        String sql = "select ipnsrycd, rjnsrycd from tbl_srycdchg where ipnsrycd = " + this.addSingleQuote(code);
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, List<String>>(){

            @Override
            public boolean onResult(ResultSet records, List<String> result) throws Exception {
                collection.add(records.getString(2));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return !collection.isEmpty();
    }

    public boolean isCodeNoLongerAvailable(String code, Date now) {
        final HashSet result = new HashSet();
        String sql = "select yukostymd, yukoedymd from tbl_tensu where srycd= " + this.addSingleQuote(code) + " order by yukoedymd desc offset 0 limit 1";
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object d) throws Exception {
                if (!DateExpire.expire(records.getString(1), records.getString(2))) {
                    result.add(records.getString(2));
                }
                return false;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return result.isEmpty();
    }

    public List<String> getPeriodDates(String code) {
        final ArrayList<String> result = new ArrayList<String>();
        String sql = "select srycd,name,kananame,yukostymd,yukoedymd from tbl_tensu where srycd= " + this.addSingleQuote(code) + " order by yukoedymd desc offset 0 limit 1";
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object x) throws Exception {
                result.add(records.getString(1));
                result.add(records.getString(2));
                result.add(records.getString(3));
                result.add(records.getString(4));
                result.add(records.getString(5));
                return false;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassCode(String code) {
        final ArrayList collection = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append("select srysyukbn, yukostymd, yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd = ");
        sql.append(this.addSingleQuote(code));
        this.executeQuery(sql.toString(), null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(records.getString(1));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        if (collection.size() > 0) {
            return (String)collection.get(0);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdokanren(String code) {
        final ArrayList collection = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append("select idokanren from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd = ");
        sql.append(this.addSingleQuote(code));
        this.executeQuery(sql.toString(), null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(records.getString(1));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        if (collection.size() > 0) {
            return (String)collection.get(0);
        }
        return "";
    }

    public String[] get_TBL_TENSU(String srycd, Connection connection, Statement statement) {
        final String[] result = new String[3];
        try {
            String sql = "select NAME,TANINAME,SRYKBN from tbl_tensu where SRYCD=" + this.addSingleQuote(srycd);
            this.executeQueryContinueas(sql, null, connection, statement, new GenericAdapter<ResultSet, Object>(){

                @Override
                public boolean onResult(ResultSet records, Object x) throws Exception {
                    result[0] = records.getString(1);
                    result[1] = records.getString(2);
                    result[2] = records.getString(3);
                    return false;
                }

                @Override
                public void onError(Exception ex) {
                }
            });
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DoBodyObject> get_TBL_SRYACT(String ptid) {
        final ArrayList<DoBodyObject> result = new ArrayList<DoBodyObject>();
        try {
            final Connection connection = this.getConnection();
            final Statement statement = connection.createStatement();
            try {
                String sql = "select ptid,creymd,upymd,zainum,rennum,SRYCD1,SRYSURYO1,SRYKAISU1,SRYCD2,SRYSURYO2,SRYKAISU1,SRYCD3,SRYSURYO3,SRYKAISU1,SRYCD4,SRYSURYO4,SRYKAISU4,SRYCD5,SRYSURYO5,SRYKAISU5 from tbl_sryact where ptid=" + this.addSingleQuote(ptid);
                this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

                    @Override
                    public boolean onResult(ResultSet records, Object x) throws Exception {
                        for (int index = 6; index <= 20; index += 3) {
                            String[] tensu = SqlMasterDao.this.get_TBL_TENSU(records.getString(index), connection, statement);
                            if (tensu.length != 3) continue;
                            DoBodyObject record = new DoBodyObject(tensu[2], records.getString(3), records.getString(4), tensu[0], records.getDouble(index + 1), records.getInt(index + 2), tensu[1]);
                            result.add(record);
                        }
                        return true;
                    }

                    @Override
                    public void onError(Exception ex) {
                    }
                });
            }
            finally {
                this.closeStatement(statement);
                this.closeConnection(connection);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeQuery(String sql, Object userObject, GenericAdapter adapter) {
        try {
            this.semaphore.acquire();
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            ResultSet results = null;
            try {
                results = statement.executeQuery(sql);
                while (results.next()) {
                    if (adapter.onResult(results, userObject)) continue;
                    Object object = userObject;
                    return object;
                }
            }
            finally {
                results.close();
                this.closeStatement(statement);
                this.closeConnection(connection);
            }
        }
        catch (Exception ex) {
            adapter.onError(ex);
        }
        finally {
            this.semaphore.release();
        }
        return userObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeQueryContinueas(String sql, Object userObject, Connection connection, Statement statement, GenericAdapter adapter) {
        try {
            ResultSet results = null;
            try {
                results = statement.executeQuery(sql);
                do {
                    if (!results.next()) return userObject;
                } while (adapter.onResult(results, userObject));
                Object object = userObject;
                return object;
            }
            finally {
                results.close();
            }
        }
        catch (Exception ex) {
            adapter.onError(ex);
            return userObject;
        }
    }
}

