/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.stamp.convert;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import open.dolphin.client.stamp.convert.StampIDContentHandler;
import open.dolphin.client.stamp.convert.StampTreeValidateHandler;
import open.dolphin.client.stamp.convert.StampValidateHandler;
import open.dolphin.container.Pair;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.delegater.remote.RemoteStampDelegater;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.infomodel.StampModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class StampConverter {
    static String nullStamp = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><java version=\"1.6.0_14\" class=\"java.beans.XMLDecoder\"><object class=\"open.dolphin.infomodel.BundleDolphin\"><void property=\"claimItem\"><array class=\"open.dolphin.infomodel.ClaimItem\" length=\"0\"><void index=\"0\"><object class=\"open.dolphin.infomodel.ClaimItem\"></object></void></array></void><void property=\"classCode\"><string></string></void><void property=\"classCodeSystem\"><string>Claim007</string></void><string></string></void></object></java>";

    private static void setStringValue(Element node, String s) {
        List child_nodes = node.getChildren();
        for (int index = 0; index < child_nodes.size(); ++index) {
            Element string_node = (Element)child_nodes.get(index);
            String node_name = string_node.getName();
            if (node_name == null || !node_name.equals("string")) continue;
            string_node.setText(s);
        }
    }

    private static String getStringValue(Element node) {
        String result = "";
        List child_nodes = node.getChildren();
        for (int index = 0; index < child_nodes.size(); ++index) {
            Element string_node = (Element)child_nodes.get(index);
            if (!string_node.getName().equals("string")) continue;
            result = string_node.getValue();
        }
        return result;
    }

    private static void createDateNode(Element object_node, String attribute, String value) {
        Element property_node = new Element("void");
        Attribute property_attribute = new Attribute("property", attribute);
        property_node.getAttributes().add(property_attribute);
        Element string_node = new Element("string");
        string_node.setText(value);
        property_node.getChildren().add(string_node);
        object_node.getChildren().add(property_node);
    }

    private static void appendStratAndEndDate(SqlMasterDao dao, Element object_node) {
        boolean have_enddate = false;
        boolean have_startdate = false;
        String code = "";
        String startdate = "";
        String enddate = "";
        List child_nodes = object_node.getChildren();
        for (int index = 0; index < child_nodes.size(); ++index) {
            Element target_node = (Element)child_nodes.get(index);
            Attribute attribute = target_node.getAttribute("property");
            if (attribute == null) continue;
            String attribute_value = attribute.getValue();
            if (attribute_value.equals("code")) {
                code = StampConverter.getStringValue(target_node);
            }
            ArrayList<MedicineEntry> collection = new ArrayList<MedicineEntry>();
            dao.getMedicineEntry(code, collection);
            if (!collection.isEmpty()) {
                startdate = ((MedicineEntry)collection.get(0)).getStartDate();
                enddate = ((MedicineEntry)collection.get(0)).getEndDate();
            }
            if (attribute_value.equals("startDate")) {
                StampConverter.setStringValue(target_node, startdate);
                have_startdate = true;
            }
            if (!attribute_value.equals("endDate")) continue;
            StampConverter.setStringValue(target_node, enddate);
            have_enddate = true;
        }
        if (!have_startdate && !code.equals("")) {
            StampConverter.createDateNode(object_node, "startDate", startdate);
        }
        if (!have_enddate && !code.equals("")) {
            StampConverter.createDateNode(object_node, "endDate", enddate);
        }
    }

    private static void transformClaimItemObject(SqlMasterDao dao, Element object_node) {
        String object_class;
        if (object_node.getName().equals("object") && (object_class = object_node.getAttributeValue("class")).equals("open.dolphin.infomodel.ClaimItem")) {
            StampConverter.appendStratAndEndDate(dao, object_node);
        }
    }

    private static void transformClaimItemArray(SqlMasterDao dao, Element node) {
        if (node.getName().equals("array")) {
            List array_enveropes = node.getChildren();
            for (int index = 0; index < array_enveropes.size(); ++index) {
                List objects = ((Element)array_enveropes.get(index)).getChildren();
                for (int index1 = 0; index1 < objects.size(); ++index1) {
                    StampConverter.transformClaimItemObject(dao, (Element)objects.get(index1));
                }
            }
        }
    }

    private static void transformClaimItem(SqlMasterDao dao, Element node) {
        Attribute attribute_node = node.getAttribute("property");
        if (attribute_node != null && attribute_node.getValue().equals("claimItem")) {
            List child_nodes = node.getChildren();
            for (int index = 0; index < child_nodes.size(); ++index) {
                StampConverter.transformClaimItemArray(dao, (Element)child_nodes.get(index));
            }
        }
    }

    private static void transformObject(SqlMasterDao dao, Element object_node) {
        if (object_node.getName().equals("object")) {
            List content_of_object = object_node.getChildren();
            for (int index = 0; index < content_of_object.size(); ++index) {
                StampConverter.transformClaimItem(dao, (Element)content_of_object.get(index));
            }
        }
    }

    private static String transform(String stamp) {
        String result = "";
        if (stamp != null && !stamp.equals("")) {
            try {
                SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
                BufferedReader reader = new BufferedReader(new StringReader(stamp));
                SAXBuilder docBuilder = new SAXBuilder();
                Document document = docBuilder.build((Reader)reader);
                Element root = document.getRootElement();
                List children = root.getChildren();
                for (int index = 0; index < children.size(); ++index) {
                    Element child = (Element)children.get(index);
                    StampConverter.transformObject(dao, child);
                }
                XMLOutputter out = new XMLOutputter();
                result = out.outputString(document);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String buildStampXml(RemoteStampDelegater delegator, String stampTree) {
        StringBuilder result = new StringBuilder();
        result.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        result.append("<stampset>\n");
        result.append("<stamptree>\n");
        result.append("<![CDATA[");
        result.append(stampTree);
        result.append("]]>");
        result.append("</stamptree>\n");
        List<Pair<String, String>> idList = StampConverter.extractStampIds(stampTree);
        result.append("<stamps>\n");
        for (Pair<String, String> id : idList) {
            result.append("<stamp id='" + (String)id.key + "' entity='" + (String)id.value + "'>\n");
            result.append("<![CDATA[");
            String stamp = StampConverter.transform(StampConverter.getStamp(delegator, (String)id.key));
            result.append(stamp);
            result.append("]]>");
            result.append("</stamp>\n");
        }
        result.append("</stamps>\n");
        result.append("</stampset>\n");
        return result.toString();
    }

    private static org.w3c.dom.Element getRootElement(String stampSetXml) throws SAXException, IOException {
        try {
            StringReader reader = new StringReader(stampSetXml);
            InputSource source = new InputSource(reader);
            source.setEncoding("UTF-8");
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            org.w3c.dom.Document doc = builder.parse(source);
            return doc.getDocumentElement();
        }
        catch (ParserConfigurationException ex) {
            LogWriter.error(StampConverter.class, "", (Throwable)ex);
            return null;
        }
    }

    public static String extractStampTree(String stampSetXml) throws SAXException, IOException {
        org.w3c.dom.Element current;
        String tree;
        org.w3c.dom.Element root = StampConverter.getRootElement(stampSetXml);
        NodeList stamptree = root.getElementsByTagName("stamptree");
        if (stamptree.getLength() != 0 && StampConverter.checkStampTree(tree = (current = (org.w3c.dom.Element)stamptree.item(0)).getTextContent().trim())) {
            return tree;
        }
        throw new SAXException();
    }

    public static String changeStampIds(String originalStampXml, HashMap<String, String> convertIdMap) throws SAXException, IOException, TransformerException {
        org.w3c.dom.Element root = StampConverter.getRootElement(originalStampXml);
        NodeList stampInfos = root.getElementsByTagName("stampInfo");
        if (stampInfos.getLength() != 0) {
            for (int idx = 0; idx < stampInfos.getLength(); ++idx) {
                org.w3c.dom.Element stampInfo = (org.w3c.dom.Element)stampInfos.item(idx);
                String stampId = stampInfo.getAttribute("stampId");
                if (!convertIdMap.containsKey(stampId)) continue;
                stampInfo.setAttribute("stampId", convertIdMap.get(stampId));
            }
            return StampConverter.elementToString(root);
        }
        throw new SAXException();
    }

    private static String elementToString(org.w3c.dom.Element root) throws TransformerException {
        DOMSource source = new DOMSource(root);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(source, result);
        return writer.toString();
    }

    public static List<Pair<Pair<String, String>, String>> extractStamps(String stampSetXml) throws SAXException, IOException {
        ArrayList<Pair<Pair<String, String>, String>> result = new ArrayList<Pair<Pair<String, String>, String>>();
        org.w3c.dom.Element root = StampConverter.getRootElement(stampSetXml);
        NodeList stamps = root.getElementsByTagName("stamp");
        for (int index = 0; index < stamps.getLength(); ++index) {
            org.w3c.dom.Element current = (org.w3c.dom.Element)stamps.item(index);
            String tree = current.getTextContent().trim();
            String id = current.getAttribute("id");
            String entity = current.getAttribute("entity");
            if (StampConverter.checkStampId(id)) {
                if (!StampConverter.checkStamp(tree)) {
                    throw new SAXException();
                }
            } else {
                throw new SAXException();
            }
            result.add(new Pair<Pair<String, String>, String>(new Pair<String, String>(id, entity), tree));
        }
        return result;
    }

    private static boolean checkStampId(String id) {
        return true;
    }

    private static boolean checkStampTree(String stampTree) throws SAXException, IOException {
        StampTreeValidateHandler contentHandler = new StampTreeValidateHandler();
        XMLReader parser = XMLReaderFactory.createXMLReader();
        StringReader reader = new StringReader(stampTree);
        InputSource rource = new InputSource(reader);
        parser.setContentHandler(contentHandler);
        parser.parse(rource);
        return !contentHandler.hasError();
    }

    private static boolean checkStamp(String stamp) throws SAXException, IOException {
        if (!stamp.equals("")) {
            StampValidateHandler contentHandler = new StampValidateHandler();
            XMLReader parser = XMLReaderFactory.createXMLReader();
            StringReader reader = new StringReader(stamp);
            InputSource rource = new InputSource(reader);
            parser.setContentHandler(contentHandler);
            parser.parse(rource);
            return !contentHandler.hasError();
        }
        return true;
    }

    public static List<Pair<String, String>> extractStampIds(String stampTree) {
        try {
            StampIDContentHandler contentHandler = new StampIDContentHandler();
            XMLReader parser = XMLReaderFactory.createXMLReader();
            StringReader reader = new StringReader(stampTree);
            InputSource rource = new InputSource(reader);
            parser.setContentHandler(contentHandler);
            parser.parse(rource);
            return contentHandler.getIDs();
        }
        catch (IOException ex) {
            LogWriter.error(StampConverter.class, null, (Throwable)ex);
        }
        catch (SAXException ex) {
            LogWriter.error(StampConverter.class, null, (Throwable)ex);
        }
        return null;
    }

    public static String updateStamp(RemoteStampDelegater delegator, String id, String entity, String stamp) {
        try {
            StampModel result = delegator.getStamp(id);
            if (result != null && result.getUserId() == GlobalVariables.getUserModel().getId()) {
                return delegator.updateStamp(result, stamp);
            }
            return delegator.newStamp(entity, stamp);
        }
        catch (Exception e) {
            String a = e.getMessage();
            return "";
        }
    }

    public static String getStamp(RemoteStampDelegater delegator, String id) {
        try {
            StampModel result = delegator.getStamp(id);
            if (result != null) {
                return result.getXml();
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }
}

