/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AbstractCodeHelper;
import open.dolphin.client.settings.IAbstractSettingPanel;
import open.dolphin.client.settings.ProjectSettingDialog;
import open.dolphin.helper.GridBagBuilder;
import open.dolphin.project.GlobalConstants;

public class CodeHelperSettingPanel
extends JPanel
implements IAbstractSettingPanel {
    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    private IAbstractSettingPanel.State state = IAbstractSettingPanel.State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private static final String ID = "codeHelperSetting";
    private static final String TITLE = "\u30b3\u30fc\u30c9";
    private static final String ICON = "help_24.gif";
    private JRadioButton ctrlMask;
    private JRadioButton metaMask;
    private JTextField text;
    private JTextField path;
    private JTextField general;
    private JTextField other;
    private JTextField treatment;
    private JTextField surgery;
    private JTextField radiology;
    private JTextField labo;
    private JTextField physiology;
    private JTextField injection;
    private JTextField rp;
    private JTextField baseCharge;
    private JTextField instraction;
    private JTextField stay_on_home;
    private JTextField orca;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JLabel label6;
    private JLabel label7;
    private JLabel label8;
    private JLabel label9;
    private JLabel label10;
    private JLabel label11;
    private JLabel label12;
    private JLabel label13;
    private JLabel label14;
    private JLabel label15;
    private JLabel label16;
    private JPanel keyBind;
    private JPanel stamp;
    private IAbstractSettingPanel.State curState = IAbstractSettingPanel.State.NONE_STATE;
    private HelperModel model;

    public CodeHelperSettingPanel() {
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
        this.setLayout(new GridBagLayout());
        this.setId(ID);
        this.setTitle(TITLE);
        this.setIcon(ICON);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public void start() {
        this.initCustomComponents();
        this.model = new HelperModel();
        this.model.populate();
        this.connect();
        this.checkState();
    }

    @Override
    public void save() {
        this.model.restore();
    }

    private void initCustomComponents() {
        this.ctrlMask = new JRadioButton("\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb");
        String str = GlobalConstants.isMac() ? "\u30a2\u30c3\u30d7\u30eb" : "\u30e1\u30bf";
        this.metaMask = new JRadioButton(str);
        this.text = new JTextField(5);
        this.path = new JTextField(5);
        this.general = new JTextField(5);
        this.other = new JTextField(5);
        this.treatment = new JTextField(5);
        this.surgery = new JTextField(5);
        this.radiology = new JTextField(5);
        this.labo = new JTextField(5);
        this.physiology = new JTextField(5);
        this.injection = new JTextField(5);
        this.rp = new JTextField(5);
        this.baseCharge = new JTextField(5);
        this.instraction = new JTextField(5);
        this.stay_on_home = new JTextField(5);
        this.orca = new JTextField(5);
        this.keyBind = new JPanel(new BorderLayout());
        GridBagBuilder gbl = new GridBagBuilder(this.keyBind, "\u4fee\u98fe\u30ad\u30fc + \u30b9\u30da\u30fc\u30b9 = \u88dc\u5b8c\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7");
        this.label1 = new JLabel("\u4fee\u98fe\u30ad\u30fc:");
        gbl.add(this.label1, 0, 0, 13);
        JPanel p1 = new JPanel(new FlowLayout(0, 5, 0));
        p1.add(this.ctrlMask);
        p1.add(this.metaMask);
        gbl.add(p1, 1, 0, 10);
        this.stamp = new JPanel(new BorderLayout());
        gbl = new GridBagBuilder(this.stamp, "\u30b9\u30bf\u30f3\u30d7\u7bb1\u306e\u30ad\u30fc\u30ef\u30fc\u30c9");
        this.label2 = new JLabel("\u30c6\u30ad\u30b9\u30c8:");
        gbl.add(this.label2, 0, 0, 13);
        gbl.add(this.text, 1, 0, 17);
        this.label3 = new JLabel("\u30d1\u30b9:");
        gbl.add(this.label3, 2, 0, 13);
        gbl.add(this.path, 3, 0, 17);
        this.label4 = new JLabel("\u6c4e \u7528:");
        gbl.add(this.label4, 0, 1, 13);
        gbl.add(this.general, 1, 1, 17);
        this.label5 = new JLabel("\u305d\u306e\u4ed6:");
        gbl.add(this.label5, 2, 1, 13);
        gbl.add(this.other, 3, 1, 17);
        this.label6 = new JLabel("\u51e6 \u7f6e:");
        gbl.add(this.label6, 0, 2, 13);
        gbl.add(this.treatment, 1, 2, 17);
        this.label7 = new JLabel("\u624b \u8853:");
        gbl.add(this.label7, 2, 2, 13);
        gbl.add(this.surgery, 3, 2, 17);
        this.label8 = new JLabel("\u753b\u50cf\u8a3a\u65ad:");
        gbl.add(this.label8, 0, 3, 13);
        gbl.add(this.radiology, 1, 3, 17);
        this.label9 = new JLabel("\u691c\u4f53\u691c\u67fb:");
        gbl.add(this.label9, 2, 3, 13);
        gbl.add(this.labo, 3, 3, 17);
        this.label10 = new JLabel("\u751f\u4f53\u691c\u67fb:");
        gbl.add(this.label10, 0, 4, 13);
        gbl.add(this.physiology, 1, 4, 17);
        this.label11 = new JLabel("\u6ce8 \u5c04:");
        gbl.add(this.label11, 0, 5, 13);
        gbl.add(this.injection, 1, 5, 17);
        this.label12 = new JLabel("\u51e6 \u65b9:");
        gbl.add(this.label12, 2, 5, 13);
        gbl.add(this.rp, 3, 5, 17);
        this.label13 = new JLabel("\u8a3a\u65ad\u6599:");
        gbl.add(this.label13, 0, 6, 13);
        gbl.add(this.baseCharge, 1, 6, 17);
        this.label14 = new JLabel("\u6307\u5c0e:");
        gbl.add(this.label14, 2, 6, 13);
        gbl.add(this.instraction, 3, 6, 17);
        this.label15 = new JLabel("\u5728\u5b85:");
        gbl.add(this.label15, 0, 7, 13);
        gbl.add(this.stay_on_home, 1, 7, 17);
        this.label16 = new JLabel("ORCA:");
        gbl.add(this.label16, 2, 7, 13);
        gbl.add(this.orca, 3, 7, 17);
        gbl = new GridBagBuilder(this);
        gbl.add((Component)this.keyBind, 0, 0, 2, 1.0, 0.0);
        gbl.add((Component)this.stamp, 0, 1, 2, 1.0, 0.0);
        gbl.add((Component)new JLabel(""), 0, 2, 1, 1.0, 1.0);
    }

    private void connect() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.ctrlMask);
        bg.add(this.metaMask);
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CodeHelperSettingPanel.this.checkState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CodeHelperSettingPanel.this.checkState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CodeHelperSettingPanel.this.checkState();
            }
        };
        this.text.getDocument().addDocumentListener(dl);
        this.path.getDocument().addDocumentListener(dl);
        this.general.getDocument().addDocumentListener(dl);
        this.other.getDocument().addDocumentListener(dl);
        this.treatment.getDocument().addDocumentListener(dl);
        this.surgery.getDocument().addDocumentListener(dl);
        this.radiology.getDocument().addDocumentListener(dl);
        this.labo.getDocument().addDocumentListener(dl);
        this.physiology.getDocument().addDocumentListener(dl);
        this.injection.getDocument().addDocumentListener(dl);
        this.rp.getDocument().addDocumentListener(dl);
        this.baseCharge.getDocument().addDocumentListener(dl);
        this.instraction.getDocument().addDocumentListener(dl);
        this.stay_on_home.getDocument().addDocumentListener(dl);
        this.orca.getDocument().addDocumentListener(dl);
    }

    private void checkState() {
        IAbstractSettingPanel.State newState = IAbstractSettingPanel.State.NONE_STATE;
        newState = this.text.getText().trim().equals("") || this.path.getText().trim().equals("") || this.general.getText().trim().equals("") || this.other.getText().trim().equals("") || this.treatment.getText().trim().equals("") || this.surgery.getText().trim().equals("") || this.radiology.getText().trim().equals("") || this.labo.getText().trim().equals("") || this.physiology.getText().trim().equals("") || this.injection.getText().trim().equals("") || this.injection.getText().trim().equals("") || this.rp.getText().trim().equals("") || this.baseCharge.getText().trim().equals("") || this.instraction.getText().trim().equals("") || this.stay_on_home.getText().trim().equals("") || this.orca.getText().trim().equals("") ? IAbstractSettingPanel.State.INVALID_STATE : IAbstractSettingPanel.State.VALID_STATE;
        if (this.curState != newState) {
            this.curState = newState;
            this.setState(this.curState);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public ProjectSettingDialog getContext() {
        return this.context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener("stateProp", context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return this.loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        this.loginState = login;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    @Override
    public void setState(IAbstractSettingPanel.State state) {
        this.state = state;
        this.boundSupport.firePropertyChange("stateProp", null, (Object)this.state);
    }

    @Override
    public IAbstractSettingPanel.State getState() {
        return this.state;
    }

    class HelperModel {
        HelperModel() {
        }

        public void restore() {
            Preferences prefs = Preferences.userNodeForPackage(AbstractCodeHelper.class);
            String mask = CodeHelperSettingPanel.this.ctrlMask.isSelected() ? "ctrl" : "meta";
            prefs.put("modifier", mask);
            prefs.put("text", CodeHelperSettingPanel.this.text.getText().trim());
            prefs.put("path", CodeHelperSettingPanel.this.path.getText().trim());
            prefs.put("generalOrder", CodeHelperSettingPanel.this.general.getText().trim());
            prefs.put("otherOrder", CodeHelperSettingPanel.this.other.getText().trim());
            prefs.put("treatmentOrder", CodeHelperSettingPanel.this.treatment.getText().trim());
            prefs.put("surgeryOrder", CodeHelperSettingPanel.this.surgery.getText().trim());
            prefs.put("radiologyOrder", CodeHelperSettingPanel.this.radiology.getText().trim());
            prefs.put("testOrder", CodeHelperSettingPanel.this.labo.getText().trim());
            prefs.put("physiologyOrder", CodeHelperSettingPanel.this.physiology.getText().trim());
            prefs.put("injectionOrder", CodeHelperSettingPanel.this.injection.getText().trim());
            prefs.put("medOrder", CodeHelperSettingPanel.this.rp.getText().trim());
            prefs.put("baseChargeOrder", CodeHelperSettingPanel.this.baseCharge.getText().trim());
            prefs.put("instractionChargeOrder", CodeHelperSettingPanel.this.instraction.getText().trim());
            prefs.put("stayOnHomeChargeOrder", CodeHelperSettingPanel.this.stay_on_home.getText().trim());
            prefs.put("orcaSet", CodeHelperSettingPanel.this.orca.getText().trim());
        }

        private void populate() {
            String mask;
            Preferences prefs = Preferences.userNodeForPackage(AbstractCodeHelper.class);
            String modifier = prefs.get("modifier", mask = GlobalConstants.isMac() ? "meta" : "ctrl");
            if (modifier.equals("ctrl")) {
                CodeHelperSettingPanel.this.ctrlMask.setSelected(true);
                CodeHelperSettingPanel.this.metaMask.setSelected(false);
            } else {
                CodeHelperSettingPanel.this.ctrlMask.setSelected(false);
                CodeHelperSettingPanel.this.metaMask.setSelected(true);
            }
            CodeHelperSettingPanel.this.text.setText(prefs.get("text", "tx").trim());
            CodeHelperSettingPanel.this.path.setText(prefs.get("path", "pat").trim());
            CodeHelperSettingPanel.this.general.setText(prefs.get("generalOrder", "gen").trim());
            CodeHelperSettingPanel.this.other.setText(prefs.get("otherOrder", "oth").trim());
            CodeHelperSettingPanel.this.treatment.setText(prefs.get("treatmentOrder", "tr").trim());
            CodeHelperSettingPanel.this.surgery.setText(prefs.get("surgeryOrder", "sur").trim());
            CodeHelperSettingPanel.this.radiology.setText(prefs.get("radiologyOrder", "rad").trim());
            CodeHelperSettingPanel.this.labo.setText(prefs.get("testOrder", "lab").trim());
            CodeHelperSettingPanel.this.physiology.setText(prefs.get("physiologyOrder", "phy").trim());
            CodeHelperSettingPanel.this.injection.setText(prefs.get("injectionOrder", "inj").trim());
            CodeHelperSettingPanel.this.rp.setText(prefs.get("medOrder", "rp").trim());
            CodeHelperSettingPanel.this.baseCharge.setText(prefs.get("baseChargeOrder", "base").trim());
            CodeHelperSettingPanel.this.instraction.setText(prefs.get("instractionChargeOrder", "ins").trim());
            CodeHelperSettingPanel.this.stay_on_home.setText(prefs.get("stayOnHomeChargeOrder", "sty").trim());
            CodeHelperSettingPanel.this.orca.setText(prefs.get("orcaSet", "orca").trim());
        }
    }
}

