/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.schemaeditor;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import open.dolphin.client.schemaeditor.IDrawingHolder;

public class AreaHolder
implements IDrawingHolder {
    private Area area;
    private Stroke stroke;
    private Paint paint;
    private AlphaComposite ac;
    private boolean fill;

    public AreaHolder() {
    }

    public AreaHolder(Area area, Stroke stroke, Paint paint, AlphaComposite ac, boolean fill) {
        this();
        this.setArea(area);
        this.setStroke(stroke);
        this.setPaint(paint);
        this.setAlphaComposite(ac);
        this.setFill(fill);
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint color) {
        this.paint = color;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public AlphaComposite getAlphaComposite() {
        return this.ac;
    }

    public void setAlphaComposite(AlphaComposite ac) {
        this.ac = ac;
    }

    @Override
    public boolean contains(Point p) {
        return this.area.contains(p.getX(), p.getY());
    }

    @Override
    public void draw(Graphics2D g2d) {
        Stroke saveStroke = g2d.getStroke();
        Paint savePaint = g2d.getPaint();
        Composite saveComposite = g2d.getComposite();
        g2d.setComposite(this.getAlphaComposite());
        g2d.setPaint(this.getPaint());
        if (this.isFill()) {
            if (this.getStroke() != null) {
                g2d.setStroke(this.getStroke());
            }
            g2d.fill(this.getArea());
        } else {
            if (this.getStroke() != null) {
                g2d.setStroke(this.getStroke());
            }
            g2d.draw(this.getArea());
        }
        g2d.setStroke(saveStroke);
        g2d.setPaint(savePaint);
        g2d.setComposite(saveComposite);
    }

    @Override
    public void translate(double x, double y) {
        AffineTransform trans = AffineTransform.getTranslateInstance(x, y);
        this.area.transform(trans);
    }
}

