/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.patientinfodocument;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IChartDocument;
import open.dolphin.delegater.remote.RemotePatientDelegater;
import open.dolphin.helper.DBTask;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.infomodel.PVTPublicInsuranceItemModel;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.OddEvenRowRenderer;

public class PatientInfoDocumentPanel
extends JPanel
implements IChartDocument,
IChartCommandAccepter {
    public static final String TITLE = "\u60a3\u8005\u60c5\u5831";
    private static final String[] PATIENT_ATTRS = new String[]{"\u60a3\u8005 ID", "\u6c0f  \u540d", "\u30ab\u30ca", "\u30ed\u30fc\u30de\u5b57 *", "\u6027  \u5225", "\u751f\u5e74\u6708\u65e5", "\u56fd  \u7c4d *", "\u5a5a\u59fb\u72b6\u6cc1 *", "\u90f5\u4fbf\u756a\u53f7", "\u4f4f  \u6240", "\u96fb  \u8a71", "\u643a\u5e2f\u96fb\u8a71 *", "\u96fb\u5b50\u30e1\u30fc\u30eb *"};
    private static final String INFO_BUTTON_IMAGE = "about_16.gif";
    private static final String INFO = "* \u306e\u9805\u76ee\u306f\u7de8\u96c6\u304c\u53ef\u80fd\u3067\u3059";
    private static final String[] COLUMN_NAMES = new String[]{"\u9805   \u76ee", "\u5024"};
    private static final int[] EDITABLE_ROWS = new int[]{3, 6, 7, 11, 12};
    private static final String SAVE_ICON = "save_16.gif";
    private JButton saveBtn;
    private PatientInfoTableModel pModel;
    private JTable pTable;
    private StateContext stateMgr;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title;
    private boolean dirty;

    public PatientInfoDocumentPanel(IChart parent) {
        this.parent = parent;
        this.title = TITLE;
        this.initComponents();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.PatientInfoDocumentPanel;
    }

    private void initialize() {
        JComponent compo = this.createComponent();
        compo.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new BorderLayout());
        JPanel cmdPanel = new JPanel(new FlowLayout(2));
        cmdPanel.add(new JLabel(GlobalConstants.getImageIcon(INFO_BUTTON_IMAGE)));
        cmdPanel.add(new JLabel(INFO));
        this.saveBtn = new JButton(GlobalConstants.getImageIcon(SAVE_ICON));
        this.saveBtn.setEnabled(false);
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatientInfoDocumentPanel.this.save();
            }
        });
        cmdPanel.add(this.saveBtn);
        this.add((Component)cmdPanel, "North");
        this.add((Component)compo, "Center");
        this.stateMgr = new StateContext();
        this.enter();
    }

    @Override
    public void start() {
        this.initialize();
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
        this.parent.getStatusPanel().setMessage("");
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.getParentContext().enabledAction("newKarte", true);
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        if (this.stateMgr != null) {
            this.stateMgr.enter();
        }
    }

    @Override
    public boolean isDirty() {
        if (this.stateMgr != null) {
            return this.stateMgr.isDirtyState();
        }
        return this.dirty;
    }

    private boolean save() {
        final PatientModel update = this.getParentContext().getPatient();
        final RemotePatientDelegater pdl = new RemotePatientDelegater();
        DBTask<Void> task = new DBTask<Void>(this.getParentContext()){

            @Override
            public Void doInBackground() throws Exception {
                pdl.updatePatient(update);
                return null;
            }

            @Override
            public void succeeded(Void result) {
                PatientInfoDocumentPanel.this.stateMgr.processSavedEvent();
            }
        };
        task.execute();
        return true;
    }

    private JComponent createComponent() {
        PatientModel patient = this.getParentContext().getPatient();
        List<PVTHealthInsuranceModel> insList = patient.getPvtHealthInsurances();
        this.pModel = new PatientInfoTableModel(patient, PATIENT_ATTRS, COLUMN_NAMES);
        this.pTable = new JTable(this.pModel);
        this.pTable.setDefaultRenderer(Object.class, new OddEvenRowRenderer());
        TableColumn column = this.pTable.getColumnModel().getColumn(1);
        DefaultCellEditor de = new DefaultCellEditor(new JTextField());
        de.setClickCountToStart(2);
        column.setCellEditor(de);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.pTable);
        if (insList != null) {
            for (PVTHealthInsuranceModel insurance : insList) {
                HealthInsuranceTableModel hModel = new HealthInsuranceTableModel(insurance, COLUMN_NAMES);
                JTable hTable = new JTable(hModel);
                hTable.setDefaultRenderer(Object.class, new OddEvenRowRenderer());
                panel.add(Box.createVerticalStrut(7));
                panel.add(hTable);
            }
        }
        JScrollPane scroller = new JScrollPane(panel);
        scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        return scroller;
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.getParentContext().isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parentWindow, message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case save: {
                return this.save();
            }
            case print: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    class StateContext {
        private CleanState cleanState;
        private DirtyState dirtyState;
        private State curState;

        public StateContext() {
            this.cleanState = new CleanState();
            this.dirtyState = new DirtyState();
            this.curState = this.cleanState;
        }

        public void enter() {
            this.curState.enter();
        }

        public void processSavedEvent() {
            this.curState = this.cleanState;
            this.enter();
        }

        public void processDirtyEvent() {
            if (!this.isDirtyState()) {
                this.curState = this.dirtyState;
                this.enter();
            }
        }

        public boolean isDirtyState() {
            return this.curState == this.dirtyState;
        }
    }

    class DirtyState
    extends State {
        DirtyState() {
        }

        @Override
        public void enter() {
            PatientInfoDocumentPanel.this.saveBtn.setEnabled(true);
        }
    }

    class CleanState
    extends State {
        CleanState() {
        }

        @Override
        public void enter() {
            PatientInfoDocumentPanel.this.saveBtn.setEnabled(false);
            PatientInfoDocumentPanel.this.setDirty(false);
        }
    }

    abstract class State {
        State() {
        }

        public abstract void enter();
    }

    protected class HealthInsuranceTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private List<String[]> data;

        public HealthInsuranceTableModel(PVTHealthInsuranceModel insurance, String[] columnNames) {
            this.columnNames = columnNames;
            this.data = this.getData(insurance);
        }

        private List getData(PVTHealthInsuranceModel insurance) {
            if (insurance == null) {
                return null;
            }
            ArrayList<String[]> list = new ArrayList<String[]>();
            String[] rowData = new String[]{"\u4fdd\u967a\u7a2e\u5225", insurance.getInsuranceClass()};
            list.add(rowData);
            rowData = new String[]{"\u4fdd\u967a\u7a2e\u5225\u30b3\u30fc\u30c9", insurance.getInsuranceClassCode()};
            list.add(rowData);
            rowData = new String[]{"\u4fdd\u967a\u8005\u756a\u53f7", insurance.getInsuranceNumber()};
            list.add(rowData);
            rowData = new String[]{"\u88ab\u4fdd\u967a\u8005\u8a18\u53f7", insurance.getClientGroup()};
            list.add(rowData);
            rowData = new String[]{"\u88ab\u4fdd\u967a\u8005\u756a\u53f7", insurance.getClientNumber()};
            list.add(rowData);
            rowData = new String[]{"\u672c\u4eba\u5bb6\u65cf\u533a\u5206", insurance.getFamilyClass()};
            rowData[1] = rowData[1].equals("true") ? "\u672c\u4eba" : (rowData[1].equals("false") ? "\u5bb6\u65cf" : "");
            list.add(rowData);
            rowData = new String[]{"\u958b\u59cb\u65e5", insurance.getStartFormatDate()};
            list.add(rowData);
            rowData = new String[]{"\u6709\u52b9\u671f\u9650", insurance.getExpiredFormatDate()};
            list.add(rowData);
            String[] vals = insurance.getContinuedDisease();
            if (vals != null) {
                int count = vals.length;
                for (int i = 0; i < count; ++i) {
                    rowData = new String[]{"\u7d99\u7d9a\u9069\u5fdc\u75be\u60a3\u540d", vals[i]};
                    list.add(rowData);
                }
            }
            rowData = new String[]{"\u5165\u9662\u6642\u306e\u8ca0\u62c5\u7387", insurance.getPayInRatio()};
            list.add(rowData);
            rowData = new String[]{"\u5916\u6765\u6642\u306e\u8ca0\u62c5\u7387", insurance.getPayOutRatio()};
            list.add(rowData);
            PVTPublicInsuranceItemModel[] pbi = insurance.getPVTPublicInsuranceItem();
            if (pbi == null) {
                return list;
            }
            for (PVTPublicInsuranceItemModel item : pbi) {
                rowData = new String[]{"\u516c\u8cbb\u306e\u512a\u5148\u9806\u4f4d", item.getPriority()};
                list.add(rowData);
                rowData = new String[]{"\u516c\u8cbb\u8ca0\u62c5\u540d\u79f0", item.getProviderName()};
                list.add(rowData);
                rowData = new String[]{"\u8ca0\u62c5\u8005\u756a\u53f7", item.getProvider()};
                list.add(rowData);
                rowData = new String[]{"\u53d7\u7d66\u8005\u756a\u53f7", item.getRecipient()};
                list.add(rowData);
                rowData = new String[]{"\u958b\u59cb\u65e5", item.getStartFormatDate()};
                list.add(rowData);
                rowData = new String[]{"\u6709\u52b9\u671f\u9650", item.getExpiredFormatDate()};
                list.add(rowData);
                rowData = new String[]{"\u8ca0\u62c5\u7387", item.getPaymentRatio()};
                list.add(rowData);
                rowData = new String[]{"\u8ca0\u62c5\u7387\u307e\u305f\u306f\u8ca0\u62c5\u91d1", item.getPaymentRatioType()};
                list.add(rowData);
            }
            return list;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 5;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.data == null) {
                return null;
            }
            if (row >= this.data.size()) {
                return null;
            }
            String[] rowData = this.data.get(row);
            return rowData[col];
        }
    }

    protected class PatientInfoTableModel
    extends AbstractTableModel {
        private PatientModel patient;
        private String[] attributes;
        private String[] columnNames;

        public PatientInfoTableModel(PatientModel patient, String[] attrs, String[] columnNames) {
            this.patient = patient;
            this.attributes = attrs;
            this.columnNames = columnNames;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return PATIENT_ATTRS.length;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            boolean ret = false;
            if (col == 1) {
                for (int i = 0; i < EDITABLE_ROWS.length; ++i) {
                    if (row != EDITABLE_ROWS[i]) continue;
                    ret = true;
                    break;
                }
            }
            return ret;
        }

        @Override
        public Object getValueAt(int row, int col) {
            String ret = null;
            if (col == 0) {
                ret = this.attributes[row];
            } else if (col == 1 && this.patient != null) {
                switch (row) {
                    case 0: {
                        ret = this.patient.getPatientId();
                        break;
                    }
                    case 1: {
                        ret = this.patient.getFullName();
                        break;
                    }
                    case 2: {
                        ret = this.patient.getKanaName();
                        break;
                    }
                    case 3: {
                        ret = this.patient.getRomanName();
                        break;
                    }
                    case 4: {
                        ret = this.patient.getGender();
                        break;
                    }
                    case 5: {
                        ret = this.patient.getAgeBirthday();
                        break;
                    }
                    case 6: {
                        ret = this.patient.getNationality();
                        break;
                    }
                    case 7: {
                        ret = this.patient.getMaritalStatus();
                        break;
                    }
                    case 8: {
                        ret = this.patient.contactZipCode();
                        break;
                    }
                    case 9: {
                        ret = this.patient.contactAddress();
                        if (ret == null) break;
                        ret = ret.replaceAll("\u3000", " ");
                        break;
                    }
                    case 10: {
                        ret = this.patient.getTelephone();
                        break;
                    }
                    case 11: {
                        ret = this.patient.getMobilePhone();
                        break;
                    }
                    case 12: {
                        ret = this.patient.getEmail();
                    }
                }
            }
            return ret;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value == null || value.equals("") || col == 0) {
                return;
            }
            String strValue = (String)value;
            switch (row) {
                case 3: {
                    this.patient.setRomanName(strValue);
                    PatientInfoDocumentPanel.this.stateMgr.processDirtyEvent();
                    break;
                }
                case 6: {
                    this.patient.setNationality(strValue);
                    PatientInfoDocumentPanel.this.stateMgr.processDirtyEvent();
                    break;
                }
                case 7: {
                    this.patient.setMaritalStatus(strValue);
                    PatientInfoDocumentPanel.this.stateMgr.processDirtyEvent();
                    break;
                }
                case 11: {
                    this.patient.setMobilePhone(strValue);
                    PatientInfoDocumentPanel.this.stateMgr.processDirtyEvent();
                    break;
                }
                case 12: {
                    this.patient.setEmail(strValue);
                    PatientInfoDocumentPanel.this.stateMgr.processDirtyEvent();
                }
            }
        }
    }
}

