/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestimporter;

import java.util.Date;
import java.util.List;
import java.util.Set;
import open.dolphin.client.labotestimporter.AverageInformation;
import open.dolphin.client.labotestimporter.LaboTestInformation;
import open.dolphin.client.labotestimporter.LaboTestResultInformation;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.LaboItemValue;
import open.dolphin.infomodel.LaboModuleValue;
import open.dolphin.infomodel.LaboSpecimenValue;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.UserModel;
import open.dolphin.labotestimporter.translater.HkkInspectionStatus;
import open.dolphin.labotestimporter.translater.HkkInspectionSubjectName;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.GUIDGenerator;

public class MedisBuilder {
    private List<LaboModuleValue> allModules;

    public MedisBuilder(List<LaboModuleValue> allModules) {
        this.allModules = allModules;
    }

    private boolean updateModule(LaboTestInformation information) {
        String id = information.getSampleTime().substring(8);
        for (LaboModuleValue value : this.allModules) {
            if (!value.getPatientId().equals(id)) continue;
            this.buildOneModule(value, information);
            return true;
        }
        return false;
    }

    private void insertModule(LaboTestInformation information) {
        LaboModuleValue value = new LaboModuleValue();
        if (this.buildOneModule(value, information)) {
            this.allModules.add(value);
        }
    }

    public void build(List<LaboTestInformation> laboTestInformations) {
        for (LaboTestInformation laboTestInformation : laboTestInformations) {
            if (this.updateModule(laboTestInformation)) continue;
            this.insertModule(laboTestInformation);
        }
    }

    private String formatDate(String yyyymmdd) {
        return yyyymmdd.substring(0, 4) + "-" + yyyymmdd.substring(4, 6) + "-" + yyyymmdd.substring(6, 8) + "T00:00:00";
    }

    private boolean buildOneModule(LaboModuleValue laboModuleValue, LaboTestInformation laboTestInformation) {
        if (laboTestInformation.getStatus().equals("E")) {
            LaboSpecimenValue laboSpecimenValue;
            UserModel user = GlobalVariables.getUserModel();
            FacilityModel facility = user.getFacility();
            String facilityName = facility.getFacilityName();
            String facilityId = facility.getFacilityId();
            laboModuleValue.setSetName("");
            laboModuleValue.setSetCode("");
            laboModuleValue.setSetCodeId("");
            laboModuleValue.setCreator(user);
            String sampleTime = laboTestInformation.getSampleTime().substring(0, 8);
            String patientId = laboTestInformation.getSampleTime().substring(8);
            laboModuleValue.setPatientId(patientId);
            laboModuleValue.setPatientIdType("local");
            laboModuleValue.setPatientIdTypeCodeSys("MML0024");
            laboModuleValue.setDocId(GUIDGenerator.generate(this));
            Date confirmed = ModelUtils.getDateFromString(laboTestInformation.getConfirmedDate(), "yyyyMMdd");
            laboModuleValue.setConfirmed(confirmed);
            laboModuleValue.setStarted(confirmed);
            laboModuleValue.setRecorded(new Date());
            laboModuleValue.setStatus("F");
            laboModuleValue.setRegistId("");
            laboModuleValue.setSampleTime(this.formatDate(sampleTime));
            laboModuleValue.setRegistTime(this.formatDate(laboTestInformation.getRegistTime()));
            laboModuleValue.setReportTime(this.formatDate(laboTestInformation.getRegistTime()));
            laboModuleValue.setReportStatus(HkkInspectionStatus.toName(laboTestInformation.getStatus()));
            laboModuleValue.setReportStatusCode("final");
            laboModuleValue.setReportStatusCodeId("mmlLb0001");
            laboModuleValue.setClientFacility(facilityName);
            laboModuleValue.setClientFacilityCode(facilityId);
            laboModuleValue.setClientFacilityCodeId("JMARI");
            laboModuleValue.setLaboratoryCenter(laboTestInformation.getCenterCode());
            laboModuleValue.setLaboratoryCenterCode(laboTestInformation.getCenterCode());
            laboModuleValue.setLaboratoryCenterCodeId("JMARI");
            if (laboModuleValue.getLaboSpecimens() == null) {
                laboSpecimenValue = new LaboSpecimenValue();
                laboSpecimenValue.setSpecimenName("\u8840\u6e05");
                laboSpecimenValue.setSpecimenCode("99");
                laboSpecimenValue.setSpecimenCodeId("Nihonrinsyo_ZaiCode");
                laboSpecimenValue.setLaboModule(laboModuleValue);
                laboModuleValue.addLaboSpecimen(laboSpecimenValue);
            } else {
                Set<LaboSpecimenValue> c = laboModuleValue.getLaboSpecimens();
                laboSpecimenValue = c.iterator().next();
            }
            int laboTestInformationSize = laboTestInformation.laboTestResultInformationSize();
            for (int index = 0; index < laboTestInformationSize; ++index) {
                LaboItemValue laboItemValue = new LaboItemValue();
                LaboTestResultInformation item = laboTestInformation.getLaboTestResultInformation(index);
                laboItemValue.setItemName(HkkInspectionSubjectName.toName(item.getItemCode()));
                laboItemValue.setItemCode(item.getItemCode());
                laboItemValue.setItemCodeId("HokenKagaku_ItCode");
                laboItemValue.setItemValue(item.getValue());
                laboItemValue.setAcode(item.getComment1());
                laboItemValue.setIcode(item.getComment2());
                AverageInformation average = laboTestInformation.getAverageInformation(index);
                laboItemValue.setUp(average.getUp());
                laboItemValue.setLow(average.getLow());
                laboItemValue.setNormal(average.getNormal());
                laboItemValue.setNout("N");
                laboItemValue.setUnit(average.getUnit());
                laboItemValue.setUnitCode(average.getUnitCode());
                laboItemValue.setUnitCodeId(average.getUnitCodeId());
                laboItemValue.setLaboSpecimen(laboSpecimenValue);
                laboSpecimenValue.addLaboItem(laboItemValue);
            }
            return true;
        }
        return false;
    }
}

