/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.karte;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import open.dolphin.client.CalendarCardPanel;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IChartDocument;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.project.GlobalConstants;

public final class PatientVisitInspector
extends CalendarCardPanel
implements IChartDocument {
    public static final String TITLE = "\u6765\u9662\u6b74";
    private String pvtEvent;
    private IChart parent;
    private String title = "\u6765\u9662\u6b74";

    public PatientVisitInspector(IChart parent) {
        super(GlobalConstants.getEventColorTable());
        this.parent = parent;
        this.initCustomComponents();
        this.update();
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.PatientVisitInspector;
    }

    private void initCustomComponents() {
        this.pvtEvent = "PVT";
        this.setCalendarRange(new int[]{-12, 0});
    }

    private void update() {
        List latestVisit = this.getParentContext().getKarte().getEntryCollection("visit");
        if (latestVisit != null && latestVisit.size() > 0) {
            ArrayList<SimpleDate> simpleDates = new ArrayList<SimpleDate>(latestVisit.size());
            for (String pvtDate : latestVisit) {
                SimpleDate sd = SimpleDate.mmlDateToSimpleDate(pvtDate);
                sd.setEventCode(this.pvtEvent);
                simpleDates.add(sd);
            }
            this.setMarkList(simpleDates);
        }
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void enter() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }
}

