/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.imagebrowserdocument;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.ImageEntry;
import open.dolphin.client.ImageTableModel;
import open.dolphin.client.imagebrowserdocument.ImageTableTransferHandler;
import open.dolphin.helper.ImageHelper;
import open.dolphin.helper.TaskProgressMonitor;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class ImageBrowserDocumentPanel
extends JPanel
implements IChartDocument {
    public static final String TITLE = "\u30a4\u30e1\u30fc\u30b8";
    private static final int MAX_IMAGE_SIZE = 120;
    private static final int CELL_WIDTH_MARGIN = 20;
    private static final int CELL_HEIGHT_MARGIN = 20;
    private ImageTableModel tableModel;
    private int columnCount;
    private boolean showFileName;
    private final int imageSize = 120;
    private final int cellWidth = 140;
    private final int cellHeight = 140;
    private Properties properties;
    private IChart parent;
    private String title = "\u30a4\u30e1\u30fc\u30b8";
    private Application app;
    private ApplicationContext appCtx;
    private TaskMonitor taskMonitor;
    private boolean dirty;
    private String imageLocation;
    private PatientModel patient;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private JScrollPane jScrollPane1;
    private JTextField locationFld;
    private JTable table;
    private JButton updateBtn;

    public ImageBrowserDocumentPanel(IChart parent) {
        this.parent = parent;
        this.appCtx = GlobalConstants.getApplicationContext();
        this.app = this.appCtx.getApplication();
        this.taskMonitor = this.appCtx.getTaskMonitor();
        this.setDirty(false);
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.ImageBrowserDocumentPanel;
    }

    private ImageIcon getIcon(String res) {
        return new ImageIcon(this.getClass().getResource(res));
    }

    private ImageIcon getPdfIcon() {
        return this.getIcon("/open/dolphin/resources/images/pdf.gif");
    }

    public void setImageLocation(String loc) {
        if (!loc.isEmpty()) {
            this.imageLocation = loc;
            this.locationFld.setText(this.imageLocation);
            File image_directory = new File(loc);
            image_directory.mkdir();
            this.scan();
        }
    }

    private String getSuffix(String path) {
        String test = path.toLowerCase();
        int index = test.lastIndexOf(46);
        if (index > 0) {
            return test.substring(index + 1);
        }
        return null;
    }

    private String getPatientDirectoryName() {
        return this.patient.getFullName() + "(" + this.patient.getPatientId() + ")";
    }

    private void initComponents() {
        this.updateBtn = new JButton();
        this.locationFld = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.updateBtn.setText("\u66f4\u65b0");
        this.updateBtn.setName("updateBtn");
        this.updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageBrowserDocumentPanel.this.updateBtnActionPerformed(evt);
            }
        });
        this.locationFld.setEditable(false);
        this.locationFld.setName("locationFld");
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setName("table");
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.locationFld, -1, 613, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateBtn)).addComponent(this.jScrollPane1, -1, 677, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationFld, -2, -1, -2).addComponent(this.updateBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 289, Short.MAX_VALUE)));
    }

    private void updateBtnActionPerformed(ActionEvent evt) {
        this.scan();
    }

    private void scan() {
        if (this.imageLocation == null) {
            JOptionPane.showMessageDialog(null, "\u30d9\u30fc\u30b9\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n\u74b0\u5883\u8a2d\u5b9a-\u753b\u50cf\u3088\u308a\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            return;
        }
        File imageDirectory = new File(this.imageLocation);
        if (!imageDirectory.exists() || !imageDirectory.isDirectory()) {
            return;
        }
        final File[] imageFiles = imageDirectory.listFiles();
        if (imageFiles == null || imageFiles.length == 0) {
            return;
        }
        Task<List<ImageEntry>, Integer> task = new Task<List<ImageEntry>, Integer>(this.app){

            protected List<ImageEntry> doInBackground() throws Exception {
                ArrayList<ImageEntry> imageList = new ArrayList<ImageEntry>();
                int cnt = 0;
                int total = imageFiles.length;
                for (File file : imageFiles) {
                    ++cnt;
                    String path = file.getPath();
                    String fileName = file.getName();
                    StringBuilder sb = new StringBuilder();
                    sb.append(fileName);
                    sb.append("[");
                    sb.append(cnt);
                    sb.append("/");
                    sb.append(total);
                    sb.append("]\u3092\u51e6\u7406\u3057\u3066\u3044\u307e\u3059...");
                    this.setMessage(sb.toString());
                    String suffix = ImageBrowserDocumentPanel.this.getSuffix(path);
                    if (suffix == null) {
                        this.setProgress(new Integer(cnt));
                        continue;
                    }
                    Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffix);
                    if (!readers.hasNext()) {
                        if (suffix.equals("pdf")) {
                            ImageEntry entry = new ImageEntry();
                            URL url = file.toURI().toURL();
                            entry.setUrl(url.toString());
                            entry.setPath(path);
                            entry.setFileName(fileName);
                            entry.setImageIcon(ImageBrowserDocumentPanel.this.getPdfIcon());
                            imageList.add(entry);
                        }
                        this.setProgress(new Integer(cnt));
                        continue;
                    }
                    ImageReader reader = readers.next();
                    try {
                        reader.setInput(new FileImageInputStream(file), true);
                    }
                    catch (Exception e) {
                        LogWriter.warn(ImageBrowserDocumentPanel.class, e.getMessage());
                        continue;
                    }
                    int numImages = 1;
                    if (suffix.equals("dcm")) {
                        try {
                            numImages = reader.getNumImages(true);
                            if (numImages > 1) {
                                sb = new StringBuilder();
                                sb.append(fileName);
                                sb.append(" M");
                                sb.append(numImages);
                                fileName = sb.toString();
                            }
                        }
                        catch (Exception e) {
                            LogWriter.debug(ImageBrowserDocumentPanel.class, e.getMessage());
                        }
                    }
                    try {
                        int width = reader.getWidth(0);
                        int height = reader.getHeight(0);
                        BufferedImage image = reader.read(0);
                        image = ImageHelper.getFirstScaledInstance(image, 120);
                        ImageIcon icon = new ImageIcon(image);
                        ImageEntry entry = new ImageEntry();
                        URL url = file.toURI().toURL();
                        entry.setUrl(url.toString());
                        entry.setPath(path);
                        entry.setFileName(fileName);
                        entry.setImageIcon(icon);
                        entry.setNumImages(numImages);
                        entry.setWidth(width);
                        entry.setHeight(height);
                        imageList.add(entry);
                    }
                    catch (Exception e) {
                        LogWriter.debug(ImageBrowserDocumentPanel.class, e.getMessage());
                    }
                    this.setProgress(new Integer(cnt));
                }
                return imageList;
            }

            protected void succeeded(List<ImageEntry> result) {
                ImageBrowserDocumentPanel.this.tableModel.setImageList(result);
            }

            protected void cancelled() {
            }

            protected void failed(Throwable cause) {
            }

            protected void interrupted(InterruptedException e) {
            }
        };
        String message = "\u30a4\u30e1\u30fc\u30b8\u30d6\u30e9\u30a6\u30b6";
        String note = this.imageLocation + "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u30b9\u30ad\u30e3\u30f3\u3057\u3066\u3044\u307e\u3059...";
        int min = 0;
        int max = imageFiles.length;
        new TaskProgressMonitor((Task)task, this.taskMonitor, null, message, note, min, max);
        this.appCtx.getTaskService().execute((Task)task);
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public void start() {
        this.initComponents();
        this.initCustomComponents();
    }

    @Override
    public void stop() {
        LocalStorage ls = this.appCtx.getLocalStorage();
    }

    private void openImage(ImageEntry entry) {
        try {
            String path = entry.getPath();
            String ext = path.toLowerCase();
            String appli = null;
            appli = ext.endsWith(".pdf") ? this.properties.getProperty("pdfView") : (ext.endsWith(".dcm") ? this.properties.getProperty("dicomView") : this.properties.getProperty("jpegView"));
            if (appli == null || appli.equals("")) {
                return;
            }
            if (GlobalConstants.isMac()) {
                new ProcessBuilder("open", "-a", appli, path).start();
            } else {
                new ProcessBuilder(appli, path).start();
            }
        }
        catch (IOException ex) {
            LogWriter.error(ImageBrowserDocumentPanel.class, "", (Throwable)ex);
        }
    }

    private void initCustomComponents() {
        String baseDir;
        this.patient = this.getParentContext().getPatient();
        ApplicationActionMap map = this.appCtx.getActionMap((Object)this);
        ResourceMap resource = this.appCtx.getResourceMap(ImageBrowserDocumentPanel.class);
        try {
            LocalStorage ls = this.appCtx.getLocalStorage();
            this.properties = (Properties)ls.load("imageBrowserProp.xml");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.properties == null) {
            this.properties = new Properties();
            this.properties.setProperty("columnCount", "5");
            this.properties.setProperty("showFileName", "true");
            this.properties.setProperty("baseDir", "");
            this.properties.setProperty("jpegView", "");
            this.properties.setProperty("pdfView", "");
            this.properties.setProperty("dicomView", "");
        }
        if ((baseDir = this.properties.getProperty("baseDir")) != null && !baseDir.equals("")) {
            this.setImageLocation(baseDir + "/" + this.getPatientDirectoryName());
        }
        this.columnCount = Integer.parseInt(this.properties.getProperty("columnCount"));
        this.showFileName = Boolean.parseBoolean(this.properties.getProperty("showFileName"));
        this.tableModel = new ImageTableModel(null, this.columnCount);
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(0);
        TableColumn column = null;
        for (int i = 0; i < this.columnCount; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(140);
        }
        this.table.setRowHeight(140);
        ImageRenderer imageRenderer = new ImageRenderer();
        imageRenderer.setHorizontalAlignment(0);
        this.table.setDefaultRenderer(Object.class, imageRenderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ImageEntry entry;
                    int row = ImageBrowserDocumentPanel.this.table.getSelectedRow();
                    int col = ImageBrowserDocumentPanel.this.table.getSelectedColumn();
                    if (row != -1 && col != -1 && (entry = (ImageEntry)ImageBrowserDocumentPanel.this.tableModel.getValueAt(row, col)) != null) {
                        ImageBrowserDocumentPanel.this.openImage(entry);
                    }
                }
            }
        });
        this.table.setTransferHandler(new ImageTableTransferHandler());
        this.table.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int ctrlMask = 128;
                int action = (e.getModifiersEx() & ctrlMask) == ctrlMask ? 1 : 2;
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, e, action);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    @Override
    public void enter() {
        this.getParentContext().getStatusPanel().setMessage("");
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.getParentContext().enabledAction("newKarte", true);
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        return false;
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    class ImageRenderer
    extends DefaultTableCellRenderer {
        public ImageRenderer() {
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            Component compo = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
            JLabel l = (JLabel)compo;
            if (value != null) {
                ImageEntry entry = (ImageEntry)value;
                l.setIcon(entry.getImageIcon());
                if (ImageBrowserDocumentPanel.this.showFileName) {
                    l.setText(entry.getFileName());
                } else {
                    l.setText(null);
                }
            } else {
                l.setIcon(null);
                l.setText(null);
            }
            return compo;
        }
    }
}

