/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import open.dolphin.client.AbstractStampTreeBuilder;
import open.dolphin.client.OrcaTree;
import open.dolphin.client.TreeInfo;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeModel;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.log.LogWriter;

public class DefaultStampTreeBuilder
extends AbstractStampTreeBuilder {
    private static final String[] REPLACES = new String[]{"<", ">", "&", "'", "\""};
    private static final String[] MATCHES = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    public static final String FROM_EDITOR = "\u30a8\u30c7\u30a3\u30bf\u304b\u3089\u767a\u884c...";
    private String rootName;
    private boolean hasEditor;
    private StampTreeNode rootNode;
    private StampTreeNode node;
    private ModuleInfoBean info;
    private LinkedList<StampTreeNode> linkedList;
    private List<StampTree> products;

    protected DefaultStampTreeBuilder() {
    }

    @Override
    public List<StampTree> getProduct() {
        return this.products;
    }

    @Override
    public void buildStart() {
        this.products = new ArrayList<StampTree>();
        LogWriter.debug(this.getClass(), "Build StampTree start");
    }

    @Override
    public void buildRoot(String name, String entity) {
        LogWriter.debug(this.getClass(), "Root=" + name);
        this.linkedList = new LinkedList();
        TreeInfo treeInfo = new TreeInfo();
        treeInfo.setName(name);
        treeInfo.setEntity(entity);
        this.rootNode = new StampTreeNode(treeInfo);
        this.hasEditor = false;
        this.rootName = name;
        this.linkedList.addFirst(this.rootNode);
    }

    @Override
    public void buildNode(String name) {
        LogWriter.debug(this.getClass(), "Node=" + name);
        this.node = new StampTreeNode(this.toXmlText(name));
        this.getCurrentNode().add(this.node);
        this.linkedList.addFirst(this.node);
    }

    @Override
    public void buildStampInfo(String name, String role, String entity, String editable, String memo, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(",");
        sb.append(role);
        sb.append(",");
        sb.append(entity);
        sb.append(",");
        sb.append(editable);
        sb.append(",");
        sb.append(memo);
        sb.append(",");
        sb.append(id);
        LogWriter.debug(this.getClass(), sb.toString());
        this.info = new ModuleInfoBean();
        this.info.initialize(null, this.toXmlText(name), null, entity, role);
        if (editable != null) {
            this.info.setEditable(Boolean.valueOf(editable));
        }
        if (memo != null) {
            this.info.setStampMemo(this.toXmlText(memo));
        }
        if (id != null) {
            this.info.setStampId(id);
        }
        this.node = new StampTreeNode(this.info);
        this.getCurrentNode().add(this.node);
        if (this.info.getStampName().equals(FROM_EDITOR) && !this.info.isSerialized()) {
            this.hasEditor = true;
            this.info.setEditable(false);
        }
    }

    @Override
    public void buildNodeEnd() {
        LogWriter.debug(this.getClass(), "End node");
        this.linkedList.removeFirst();
    }

    @Override
    public void buildRootEnd() {
        if (!(this.hasEditor || DefaultStampTreeBuilder.getEntity(this.rootName) == null || DefaultStampTreeBuilder.getEntity(this.rootName).equals("text") || DefaultStampTreeBuilder.getEntity(this.rootName).equals("path"))) {
            ModuleInfoBean si = new ModuleInfoBean();
            si.initialize(null, FROM_EDITOR, null, DefaultStampTreeBuilder.getEntity(this.rootName), "p");
            si.setEditable(false);
            StampTreeNode sn = new StampTreeNode(si);
            this.rootNode.add(sn);
        }
        StampTree tree = new StampTree(new StampTreeModel(this.rootNode));
        this.products.add(tree);
        LogWriter.debug(this.getClass(), "End root count=" + this.products.size());
    }

    @Override
    public void buildEnd() {
        LogWriter.debug(this.getClass(), "Build end");
        boolean hasOrca = false;
        for (StampTree st : this.products) {
            String entity = st.getTreeInfo().getEntity();
            if (!entity.equals("orcaSet")) continue;
            hasOrca = true;
        }
        if (!hasOrca) {
            TreeInfo treeInfo = new TreeInfo();
            treeInfo.setName("ORCA");
            treeInfo.setEntity("orcaSet");
            this.rootNode = new StampTreeNode(treeInfo);
            OrcaTree tree = new OrcaTree(new StampTreeModel(this.rootNode));
            this.products.add(3, tree);
            LogWriter.debug(this.getClass(), "ORCA\u30bb\u30c3\u30c8\u3092\u52a0\u3048\u307e\u3057\u305f");
        }
    }

    private StampTreeNode getCurrentNode() {
        return this.linkedList.getFirst();
    }

    private String toXmlText(String text) {
        for (int i = 0; i < REPLACES.length; ++i) {
            text = text.replaceAll(MATCHES[i], REPLACES[i]);
        }
        return text;
    }
}

