/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.diagnosis;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import open.dolphin.client.MasterRenderer;
import open.dolphin.infomodel.DiseaseEntry;
import open.dolphin.project.GlobalConstants;

public final class DiseaseMasterRenderer
extends MasterRenderer {
    private static final Color[] masterColors = GlobalConstants.getColorArray("masterSearch.masterColors");
    private static final long serialVersionUID = -5209120802971568080L;
    private final int CODE_COLUMN = 0;
    private final int NAME_COLUMN = 1;
    private final int KANA_COLUMN = 2;
    private final int ICD10_COLUMN = 3;
    private final int DISUSES_COLUMN = 4;

    public DiseaseMasterRenderer() {
        this.setBeforStartColor(masterColors[0]);
        this.setInUseColor(masterColors[1]);
        this.setAfterEndColor(masterColors[2]);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        JLabel label = (JLabel)c;
        if (value != null && value instanceof DiseaseEntry) {
            DiseaseEntry entry = (DiseaseEntry)value;
            String disUseDate = entry.getDisUseDate();
            this.setColor(label, disUseDate);
            switch (col) {
                case 0: {
                    label.setText(entry.getCode());
                    break;
                }
                case 1: {
                    label.setText(entry.getName());
                    break;
                }
                case 2: {
                    label.setText(entry.getKana());
                    break;
                }
                case 3: {
                    label.setText(entry.getIcdTen());
                    break;
                }
                case 4: {
                    if (disUseDate == null) break;
                    if (disUseDate.startsWith("9")) {
                        label.setText("");
                        break;
                    }
                    label.setText(disUseDate);
                }
            }
        } else {
            label.setBackground(Color.white);
            label.setText(value == null ? "" : value.toString());
        }
        return c;
    }
}

