/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.diagnosis;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.TaskTimerMonitor;
import open.dolphin.client.editor.diagnosis.DiseaseMasterRenderer;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.infomodel.DiseaseEntry;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.order.ClaimConst;
import open.dolphin.order.RegisteredDiagnosisTransferHandler;
import open.dolphin.project.GlobalConstants;
import open.dolphin.table.ObjectTableModel;
import open.dolphin.utils.CombinedStringParser;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class DiagnosisEditorDialog
extends JDialog {
    private static final String[] diseaseColumns = new String[]{"\u30b3\u30fc\u30c9", "\u540d  \u79f0", "\u30ab \u30ca", "ICD10", "\u6709\u52b9\u671f\u9650"};
    private final int START_NUM_ROWS = 20;
    private RegisteredDiagnosisModel model;
    private CombinedStringParser diagnosisName;
    private CombinedStringParser diagnosisCode;
    private String master;
    private String sortBy;
    private String order;
    private ObjectTableModel sourceTableModel;
    private ObjectTableModel resultTableModel;
    private String currentSearchType = "";
    final SqlMasterDao dao;
    private boolean isDirty;
    private JButton cancelButton;
    private JMenuItem deleteMenuItem;
    private JTextField diagnosisField;
    private JButton diseaseButton;
    private JPopupMenu diseasePopupMenu;
    private JScrollPane diseaseScroller;
    private JMenuItem downMenuItem;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okButton;
    private JButton partsButton;
    private JTable resultTable;
    private JScrollPane sourceScroller;
    private JTextField sourceSearchField;
    private JTable sourceTable;
    private JButton suffixButton;
    private JButton typeButton;
    private JMenuItem upMenuItem;

    public DiagnosisEditorDialog(Frame parent, boolean modal, RegisteredDiagnosisModel model) {
        super(parent, modal);
        this.initComponents();
        this.dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
        this.sortBy = "byomeikana";
        this.isDirty = false;
        this.model = model;
        this.diagnosisName = new CombinedStringParser(this.model.getDiagnosis());
        this.diagnosisCode = new CombinedStringParser(this.model.getDiagnosisCode());
        this.master = ClaimConst.MasterSet.DIAGNOSIS.getName();
        this.InitialSourceTable();
        this.InitialDiseaseTable();
        TextChenge myListener = new TextChenge();
        this.diagnosisField.getDocument().addDocumentListener(myListener);
        this.diagnosisField.setText(this.diagnosisName.toPlainString());
        this.diagnosisField.addFocusListener(AutoKanjiListener.getInstance());
        this.sourceSearchField.addFocusListener(AutoKanjiListener.getInstance());
    }

    private void initComponents() {
        this.diseasePopupMenu = new JPopupMenu();
        this.upMenuItem = new JMenuItem();
        this.downMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.diseaseScroller = new JScrollPane();
        this.resultTable = new JTable();
        this.jPanel1 = new JPanel();
        this.diagnosisField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.partsButton = new JButton();
        this.typeButton = new JButton();
        this.diseaseButton = new JButton();
        this.suffixButton = new JButton();
        this.sourceSearchField = new JTextField();
        this.jLabel1 = new JLabel();
        this.sourceScroller = new JScrollPane();
        this.sourceTable = new JTable();
        this.diseasePopupMenu.setName("diseasePopupMenu");
        this.upMenuItem.setText("\u4e0a\u3078");
        this.upMenuItem.setName("upMenuItem");
        this.upMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.upMenuItemActionPerformed(evt);
            }
        });
        this.diseasePopupMenu.add(this.upMenuItem);
        this.downMenuItem.setText("\u4e0b\u3078");
        this.downMenuItem.setName("downMenuItem");
        this.downMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.downMenuItemActionPerformed(evt);
            }
        });
        this.diseasePopupMenu.add(this.downMenuItem);
        this.deleteMenuItem.setText("\u524a\u9664");
        this.deleteMenuItem.setName("deleteMenuItem");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.diseasePopupMenu.add(this.deleteMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("\u50b7\u75c5\u540d\u7de8\u96c6\u30c0\u30a4\u30a2\u30ed\u30b0");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DiagnosisEditorDialog.this.formWindowClosing(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.diseaseScroller.setName("diseaseScroller");
        this.resultTable.setBorder(BorderFactory.createEtchedBorder());
        this.resultTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"\u30b3\u30fc\u30c9", "\u540d  \u79f0", "\u30ab \u30ca", "ICD10", "\u6709\u52b9\u671f\u9650"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.resultTable.setComponentPopupMenu(this.diseasePopupMenu);
        this.resultTable.setName("resultTable");
        this.resultTable.setSelectionMode(0);
        this.resultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagnosisEditorDialog.this.resultTableMouseClicked(evt);
            }
        });
        this.resultTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                DiagnosisEditorDialog.this.resultTableMouseDragged(evt);
            }
        });
        this.diseaseScroller.setViewportView(this.resultTable);
        this.resultTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.resultTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.resultTable.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.resultTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.resultTable.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setName("jPanel1");
        this.diagnosisField.setName("diagnosisField");
        this.diagnosisField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.diagnosisFieldActionPerformed(evt);
            }
        });
        this.diagnosisField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DiagnosisEditorDialog.this.diagnosisFieldPropertyChange(evt);
            }
        });
        this.jLabel2.setText("\u50b7\u75c5\u540d\uff1a");
        this.jLabel2.setName("jLabel2");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.diagnosisField, -1, 515, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.diagnosisField, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setName("jPanel2");
        this.partsButton.setText("\u90e8\u4f4d");
        this.partsButton.setName("partsButton");
        this.partsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.partsButtonActionPerformed(evt);
            }
        });
        this.typeButton.setText("\u7279\u6027");
        this.typeButton.setName("typeButton");
        this.typeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.typeButtonActionPerformed(evt);
            }
        });
        this.diseaseButton.setText("\u75c5\u540d");
        this.diseaseButton.setName("diseaseButton");
        this.diseaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.diseaseButtonActionPerformed(evt);
            }
        });
        this.suffixButton.setText("\u63a5\u5c3e");
        this.suffixButton.setName("suffixButton");
        this.suffixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.suffixButtonActionPerformed(evt);
            }
        });
        this.sourceSearchField.setName("sourceSearchField");
        this.sourceSearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisEditorDialog.this.sourceSearchFieldActionPerformed(evt);
            }
        });
        this.jLabel1.setText("\u691c\u7d22\u8a9e\uff1a");
        this.jLabel1.setName("jLabel1");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sourceSearchField, -1, 265, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.partsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.diseaseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.suffixButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.suffixButton).addComponent(this.diseaseButton).addComponent(this.typeButton).addComponent(this.partsButton).addComponent(this.sourceSearchField, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.sourceScroller.setName("sourceScroller");
        this.sourceTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, new String[]{"\u30b3\u30fc\u30c9", "\u540d  \u79f0", "\u30ab \u30ca", "ICD10", "\u6709\u52b9\u671f\u9650"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.sourceTable.setName("sourceTable");
        this.sourceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DiagnosisEditorDialog.this.sourceTableMouseClicked(evt);
            }
        });
        this.sourceTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DiagnosisEditorDialog.this.sourceTableKeyTyped(evt);
            }
        });
        this.sourceScroller.setViewportView(this.sourceTable);
        this.sourceTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.sourceTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.sourceTable.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.sourceTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.sourceTable.getColumnModel().getColumn(4).setPreferredWidth(50);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.diseaseScroller, -1, 603, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(259, 259, 259).addComponent(this.okButton).addGap(18, 18, 18).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.sourceScroller, -1, 603, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.diseaseScroller, -2, 135, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceScroller, -1, 387, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void partsButtonActionPerformed(ActionEvent evt) {
        this.currentSearchType = ClaimConst.SubTypeSet.PREFIX.getName();
        String key = this.sourceSearchField.getText().trim();
        this.search(key, true, this.currentSearchType, this.sourceTableModel);
    }

    private void typeButtonActionPerformed(ActionEvent evt) {
        this.currentSearchType = ClaimConst.SubTypeSet.TYPE.getName();
        String key = this.sourceSearchField.getText().trim();
        this.search(key, true, this.currentSearchType, this.sourceTableModel);
    }

    private void diseaseButtonActionPerformed(ActionEvent evt) {
        this.currentSearchType = "";
        String key = this.sourceSearchField.getText().trim();
        if (!key.equals("")) {
            this.search(key, true, this.currentSearchType, this.sourceTableModel);
        }
    }

    private void suffixButtonActionPerformed(ActionEvent evt) {
        this.currentSearchType = ClaimConst.SubTypeSet.POSTFIX.getName();
        String key = this.sourceSearchField.getText().trim();
        this.search(key, true, this.currentSearchType, this.sourceTableModel);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setResult();
        this.model.setDiagnosis(this.diagnosisName.toCombinedString());
        this.model.setDiagnosisCode(this.diagnosisCode.toCombinedString());
        this.isDirty = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void diagnosisFieldActionPerformed(ActionEvent evt) {
        String key = this.diagnosisField.getText().trim();
        this.search(key, true, ClaimConst.SubTypeSet.NAMES.getName(), this.resultTableModel);
    }

    private void formWindowClosing(WindowEvent evt) {
    }

    private void resultTableMouseClicked(MouseEvent evt) {
        int selected = this.resultTable.getSelectedRow();
        DiseaseEntry diseaseEntry = (DiseaseEntry)this.resultTableModel.getValueAt(selected, 0);
        if (diseaseEntry != null && diseaseEntry.getCode() != null) {
            this.search("", true, this.dao.getSerchClass(diseaseEntry.getCode()), this.sourceTableModel);
        }
    }

    private void resultTableMouseDragged(MouseEvent evt) {
    }

    private void sourceTableMouseClicked(MouseEvent evt) {
        int selected;
        DiseaseEntry sourceEntry;
        if (evt.getClickCount() == 2 && (sourceEntry = (DiseaseEntry)this.sourceTableModel.getValueAt(selected = this.sourceTable.getSelectedRow(), 0)) != null) {
            int chenged = this.resultTable.getSelectedRow();
            DiseaseEntry diseaseEntry = (DiseaseEntry)this.resultTableModel.getValueAt(chenged, 0);
            if (diseaseEntry == null) {
                diseaseEntry = new DiseaseEntry();
                this.resultTableModel.addRow(diseaseEntry);
            }
            diseaseEntry.copyFrom(sourceEntry);
            this.redrawDiseaseTable();
        }
    }

    private void upMenuItemActionPerformed(ActionEvent evt) {
        DiseaseEntry toEntry;
        int selected = this.resultTable.getSelectedRow();
        DiseaseEntry fromEntry = (DiseaseEntry)this.resultTableModel.getValueAt(selected, 0);
        if (fromEntry != null && (toEntry = (DiseaseEntry)this.resultTableModel.getValueAt(selected - 1, 0)) != null) {
            fromEntry.swapEntry(toEntry);
            this.redrawDiseaseTable();
            this.isDirty = true;
        }
    }

    private void downMenuItemActionPerformed(ActionEvent evt) {
        DiseaseEntry toEntry;
        int selected = this.resultTable.getSelectedRow();
        DiseaseEntry fromEntry = (DiseaseEntry)this.resultTableModel.getValueAt(selected, 0);
        if (fromEntry != null && (toEntry = (DiseaseEntry)this.resultTableModel.getValueAt(selected + 1, 0)) != null) {
            fromEntry.swapEntry(toEntry);
            this.redrawDiseaseTable();
            this.isDirty = true;
        }
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        int selected = this.resultTable.getSelectedRow();
        DiseaseEntry deleteEntry = (DiseaseEntry)this.resultTableModel.getValueAt(selected, 0);
        if (deleteEntry != null) {
            this.resultTableModel.deleteRow(selected);
            this.redrawDiseaseTable();
            this.isDirty = true;
        }
    }

    private void sourceTableKeyTyped(KeyEvent evt) {
    }

    private void sourceSearchFieldActionPerformed(ActionEvent evt) {
        String key = this.sourceSearchField.getText().trim();
        this.search(key, true, this.currentSearchType, this.sourceTableModel);
    }

    private void diagnosisFieldPropertyChange(PropertyChangeEvent evt) {
        String key = this.diagnosisField.getText().trim();
        this.search(key, true, ClaimConst.SubTypeSet.NAMES.getName(), this.resultTableModel);
    }

    private void InitialSourceTable() {
        this.sourceTableModel = new ObjectTableModel(diseaseColumns, 20){

            public Class getColumnClass(int col) {
                return DiseaseEntry.class;
            }
        };
        JTableHeader header = this.sourceTable.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.sourceTable.setModel(this.sourceTableModel);
        DiseaseMasterRenderer diseaseRenderer = new DiseaseMasterRenderer();
        this.sourceTable.setDefaultRenderer(DiseaseEntry.class, diseaseRenderer);
    }

    private void InitialDiseaseTable() {
        this.resultTableModel = new ObjectTableModel(diseaseColumns, 20){

            public Class getColumnClass(int col) {
                return DiseaseEntry.class;
            }
        };
        this.resultTableModel.setObjectList(this.getInitialValues());
        ListSelectionModel selection = this.resultTable.getSelectionModel();
        selection.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        this.resultTable.setTransferHandler(new RegisteredDiagnosisTransferHandler(null));
        this.resultTable.setSelectionMode(0);
        this.resultTable.setRowSelectionAllowed(true);
        ListSelectionModel m = this.resultTable.getSelectionModel();
        this.resultTable.setModel(this.resultTableModel);
        DiseaseMasterRenderer diseaseRenderer = new DiseaseMasterRenderer();
        this.resultTable.setDefaultRenderer(DiseaseEntry.class, diseaseRenderer);
    }

    private List getInitialValues() {
        ArrayList<DiseaseEntry> result = new ArrayList<DiseaseEntry>();
        for (String code : this.diagnosisCode) {
            List<DiseaseEntry> bycode = this.dao.getDiseaseCode(code);
            if (bycode.size() == 1) {
                DiseaseEntry entry = bycode.get(0);
                result.add(entry);
                continue;
            }
            System.err.print("code not found");
        }
        return result;
    }

    private void redrawDiseaseTable() {
        this.setResult();
        this.diseaseScroller.setViewportView(this.resultTable);
        this.diagnosisField.setText(this.diagnosisName.toPlainString());
    }

    protected void search(final String text, final boolean startsWith, final String subtype, final ObjectTableModel resultModel) {
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        Task<Object, Void> task = new Task<Object, Void>(app){

            protected Object doInBackground() throws Exception {
                return DiagnosisEditorDialog.this.dao.getByName(DiagnosisEditorDialog.this.master, text, startsWith, subtype, DiagnosisEditorDialog.this.sortBy, DiagnosisEditorDialog.this.order);
            }

            protected void succeeded(Object result) {
                if (DiagnosisEditorDialog.this.dao.isNoError()) {
                    resultModel.setObjectList((List)result);
                }
            }

            protected void cancelled() {
            }

            protected void failed(Throwable cause) {
            }

            protected void interrupted(InterruptedException e) {
            }
        };
        TaskMonitor taskMonitor = appCtx.getTaskMonitor();
        String message = "\u30de\u30b9\u30bf\u691c\u7d22";
        String note = text + "\u3092\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...";
        Window c = SwingUtilities.getWindowAncestor(this);
        TaskTimerMonitor w = new TaskTimerMonitor((Task)task, taskMonitor, c, message, note, 200, 60000);
        taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
        appCtx.getTaskService().execute((Task)task);
    }

    private void setResult() {
        DiseaseEntry o;
        this.diagnosisName.clear();
        this.diagnosisCode.clear();
        int rowCount = this.resultTableModel.getRowCount();
        for (int index = 0; index < rowCount && (o = (DiseaseEntry)this.resultTableModel.getObject(index)) != null; ++index) {
            this.diagnosisName.add(o.getName());
            this.diagnosisCode.add(o.getCode());
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private class TextChenge
    implements DocumentListener {
        private TextChenge() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DiagnosisEditorDialog.this.okButton.setEnabled(!DiagnosisEditorDialog.this.diagnosisField.getText().trim().isEmpty());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DiagnosisEditorDialog.this.okButton.setEnabled(!DiagnosisEditorDialog.this.diagnosisField.getText().trim().isEmpty());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DiagnosisEditorDialog.this.okButton.setEnabled(!DiagnosisEditorDialog.this.diagnosisField.getText().trim().isEmpty());
        }
    }
}

