/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import open.dolphin.client.TimeoutWarning;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.dao.SqlOrcaSetDao;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.OrcaInputCd;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.ReflectMonitor;

public class OrcaTree
extends StampTree {
    private boolean fetched;

    public OrcaTree(TreeModel model) {
        super(model);
    }

    public boolean isFetched() {
        return this.fetched;
    }

    public void setFetched(boolean fetched) {
        this.fetched = fetched;
    }

    @Override
    public void enter() {
        if (!this.fetched) {
            String address = GlobalVariables.getClaimAddress();
            if (address == null || address.equals("")) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.fetchOrcaSet();
            } else {
                this.fetchOrcaSet2();
            }
        }
    }

    private void fetchOrcaSet2() {
        try {
            SqlOrcaSetDao dao = new SqlOrcaSetDao();
            List<OrcaInputCd> inputSet = dao.getOrcaInputSet();
            StampTreeNode root = (StampTreeNode)this.getModel().getRoot();
            for (OrcaInputCd set : inputSet) {
                ModuleInfoBean stampInfo = set.getStampInfo();
                StampTreeNode node = new StampTreeNode(stampInfo);
                root.add(node);
            }
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.reload(root);
            this.setFetched(true);
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), "KarteSaveTask succeeded", (Throwable)e);
        }
    }

    private void fetchOrcaSet() {
        final SqlOrcaSetDao dao = new SqlOrcaSetDao();
        final ReflectMonitor rm = new ReflectMonitor();
        rm.setReflection(dao, "getOrcaInputSet", null, null);
        rm.setMonitor(SwingUtilities.getWindowAncestor(this), "ORCA\u30bb\u30c3\u30c8\u691c\u7d22", "\u5165\u529b\u30bb\u30c3\u30c8\u3092\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...  ", 200, 60000);
        PropertyChangeListener pl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int state = (Integer)e.getNewValue();
                switch (state) {
                    case 0: {
                        OrcaTree.this.processResult(dao.isNoError(), rm.getResult(), dao.getErrorMessage());
                        break;
                    }
                    case 1: {
                        Window parent = SwingUtilities.getWindowAncestor(OrcaTree.this);
                        String title = "ORCA\u30bb\u30c3\u30c8\u691c\u7d22";
                        new TimeoutWarning(parent, title, null).start();
                        break;
                    }
                }
            }
        };
        rm.addPropertyChangeListener(pl);
        rm.start();
    }

    private void processResult(boolean noErr, Object result, String message) {
        if (noErr) {
            List inputSet = (List)result;
            StampTreeNode root = (StampTreeNode)this.getModel().getRoot();
            for (OrcaInputCd set : inputSet) {
                ModuleInfoBean stampInfo = set.getStampInfo();
                StampTreeNode node = new StampTreeNode(stampInfo);
                root.add(node);
            }
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.reload(root);
            this.setFetched(true);
        } else {
            String title = GlobalConstants.getFrameTitle("ORCA\u30bb\u30c3\u30c8\u691c\u7d22");
            JOptionPane.showMessageDialog(this, message, title, 2);
        }
    }
}

