/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import open.dolphin.client.TaskTimerMonitor;
import open.dolphin.configure.GlobalSettings;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.security.LoginHandler;
import open.dolphin.service.ISystemService;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class OIDGetter
extends JPanel {
    private static final long serialVersionUID = 1666003906485274645L;
    public static final String NEXT_OID_PROP = "nextOidProp";
    private static final int MAX_ESTIMATION = 30000;
    private static final int DELAY = 200;
    private static final String PROGRESS_NOTE = "\u901a\u4fe1\u30c6\u30b9\u30c8\u3092\u3057\u3066\u3044\u307e\u3059...";
    private static final String SUCCESS_NOTE = "\u901a\u4fe1\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002\u6b21\u9805\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u6b21\u306b\u9032\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002";
    private static final String TASK_TITLE = "\u901a\u4fe1\u30c6\u30b9\u30c8";
    private String helloReply;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private JButton comTest = new JButton("\u901a\u4fe1\u30c6\u30b9\u30c8");

    public OIDGetter() {
        this.initComponents();
        this.initialize();
        this.connect();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public String getHelloReply() {
        return this.helloReply;
    }

    public void setHelloReply(String oid) {
        this.helloReply = oid;
        this.boundSupport.firePropertyChange(NEXT_OID_PROP, "", this.helloReply);
    }

    public void addOidPropertyListener(PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(NEXT_OID_PROP, l);
    }

    public void removeOidPropertyListener(PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(NEXT_OID_PROP, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        try {
            InputStream in = GlobalConstants.getResourceAsStream("account-make-info.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "SHIFT_JIS"));
            try {
                String line = null;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
                JTextArea infoArea = new JTextArea();
                infoArea.setEditable(false);
                infoArea.setLineWrap(true);
                infoArea.setMargin(new Insets(10, 10, 10, 10));
                infoArea.setText(sb.toString());
                JScrollPane scroller = new JScrollPane(infoArea, 20, 31);
                scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
                JPanel btnPanel = new JPanel(new FlowLayout(0));
                btnPanel.add(new JLabel("\u6b21\u306e\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3057\u3001\u901a\u4fe1\u3067\u304d\u308b\u304b\u3069\u3046\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002"));
                btnPanel.add(this.comTest);
                this.setLayout(new BorderLayout());
                this.add((Component)scroller, "Center");
                this.add((Component)btnPanel, "South");
            }
            finally {
                in.close();
                reader.close();
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    private void connect() {
        this.comTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OIDGetter.this.doTest();
            }
        });
    }

    private void doTest() {
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        OidTask task = new OidTask(app);
        TaskMonitor taskMonitor = appCtx.getTaskMonitor();
        String message = TASK_TITLE;
        Window c = SwingUtilities.getWindowAncestor(this);
        TaskTimerMonitor w = new TaskTimerMonitor(task, taskMonitor, c, message, PROGRESS_NOTE, 200, 30000);
        taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
        appCtx.getTaskService().execute((Task)task);
    }

    class OidTask
    extends Task<String, Void> {
        public OidTask(Application app) {
            super(app);
        }

        protected String doInBackground() throws Exception {
            String qid = "minagawa";
            String password = "hanagui+";
            String securityDomain = "openDolphinSysAd";
            String providerURL = "jnp://210.153.124.60:1099";
            LoginHandler h = new LoginHandler(qid, password);
            LoginContext lc = new LoginContext(securityDomain, h);
            lc.login();
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            props.setProperty("java.naming.provider.url", providerURL);
            props.setProperty("java.naming.factory.url.pkgs", "org.jboss.namingrg.jnp.interfaces");
            InitialContext ctx = new InitialContext(props);
            ISystemService service = (ISystemService)ctx.lookup("openDolphin/RemoteSystemService");
            String result = service.helloDolphin();
            return result;
        }

        protected void succeeded(String result) {
            Window myParent = SwingUtilities.getWindowAncestor(OIDGetter.this);
            String title = GlobalConstants.getFrameTitle(OIDGetter.TASK_TITLE);
            JOptionPane.showMessageDialog(myParent, OIDGetter.SUCCESS_NOTE, title, 1);
            OIDGetter.this.setHelloReply(result);
        }

        protected void failed(Throwable cause) {
            StringBuilder sb;
            String errMsg = null;
            if (cause instanceof CommunicationException) {
                LogWriter.error(OIDGetter.class, "ASP\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093", cause);
                sb = new StringBuilder();
                sb.append("ASP\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3002");
                sb.append("\n");
                sb.append("\u30d5\u30a1\u30a4\u30e4\u30fc\u30a6\u30a9\u30fc\u30eb\u7b49\u304c\u30b5\u30fc\u30d3\u30b9\u3092\u5229\u7528\u3067\u304d\u306a\u3044\u8a2d\u5b9a\u306b\u306a\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
                errMsg = sb.toString();
            } else if (cause instanceof NamingException) {
                LogWriter.error(OIDGetter.class, "\u30b5\u30fc\u30d0\u30fc\u304c\u30d3\u30b8\u30fc\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u3057\u3070\u3089\u304f\u9593\u3092\u304a\u3044\u3066\u518d\u5ea6\u5b9f\u884c\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002", cause);
                sb = new StringBuilder();
                sb.append("\u30b5\u30fc\u30d0\u30fc\u304c\u30d3\u30b8\u30fc\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u3057\u3070\u3089\u304f\u9593\u3092\u304a\u3044\u3066\u518d\u5ea6\u5b9f\u884c\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002(OIDGrtter)");
                errMsg = sb.toString();
            } else if (cause instanceof LoginException) {
                LogWriter.error(OIDGetter.class, "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306e\u74b0\u5883\u304c\u5b9f\u884c\u3092\u8a31\u53ef\u3055\u308c\u306a\u3044\u8a2d\u5b9a\u306b\u306a\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059", cause);
                sb = new StringBuilder();
                sb.append("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306e\u74b0\u5883\u304c\u5b9f\u884c\u3092\u8a31\u53ef\u3055\u308c\u306a\u3044\u8a2d\u5b9a\u306b\u306a\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                errMsg = sb.toString();
            } else if (cause instanceof Exception) {
                LogWriter.error(OIDGetter.class, "\u30b5\u30fc\u30d0\u30fc\u304c\u30d3\u30b8\u30fc\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059", cause);
                sb = new StringBuilder();
                sb.append("\u30b5\u30fc\u30d0\u30fc\u304c\u30d3\u30b8\u30fc\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u3057\u3070\u3089\u304f\u9593\u3092\u304a\u3044\u3066\u518d\u5ea6\u5b9f\u884c\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002");
                errMsg = sb.toString();
            }
            Window myParent = SwingUtilities.getWindowAncestor(OIDGetter.this);
            String title = GlobalConstants.getFrameTitle(OIDGetter.TASK_TITLE);
            JOptionPane.showMessageDialog(myParent, errMsg, title, 2);
            OIDGetter.this.setHelloReply(null);
        }

        private String appendExceptionInfo(Throwable cause) {
            StringBuilder sb = new StringBuilder();
            sb.append("\u4f8b\u5916\u30af\u30e9\u30b9: ");
            sb.append(cause.getClass().getName());
            sb.append("\n");
            if (cause.getCause() != null) {
                sb.append("\u539f\u56e0: ");
                sb.append(cause.getCause().getMessage());
                sb.append("\n");
            }
            if (cause.getMessage() != null) {
                sb.append("\u5185\u5bb9: ");
                sb.append(cause.getMessage());
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

