/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.util.GregorianCalendar;
import open.dolphin.infomodel.AppointmentModel;

public class MedicalEvent {
    private int year;
    private int month;
    private int day;
    private int dayOfWeek;
    private String displayDate;
    private boolean today;
    private boolean outOfMonth;
    private String medicalCode;
    private AppointmentModel appo;

    public MedicalEvent() {
    }

    public MedicalEvent(int year, int month, int day, int dayOfWeek) {
        this();
        this.year = year;
        this.month = month;
        this.day = day;
        this.dayOfWeek = dayOfWeek;
        this.setDisplayDate();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public boolean isOutOfMonth() {
        return this.outOfMonth;
    }

    public void setOutOfMonth(boolean b) {
        this.outOfMonth = b;
    }

    public boolean isToday() {
        return this.today;
    }

    public void setToday(boolean b) {
        this.today = b;
    }

    public String getMedicalCode() {
        return this.medicalCode;
    }

    public void setMedicalCode(String val) {
        this.medicalCode = val;
    }

    public boolean before(GregorianCalendar gc) {
        GregorianCalendar me = new GregorianCalendar(this.year, this.month, this.day);
        return me.before(gc);
    }

    public AppointmentModel getAppointEntry() {
        return this.appo;
    }

    public void setAppointEntry(AppointmentModel val) {
        this.appo = val;
    }

    public String getAppointmentName() {
        return this.appo == null ? null : this.appo.getName();
    }

    public String toString() {
        return String.valueOf(this.day);
    }

    public String getDisplayDate() {
        return this.displayDate;
    }

    private void setDisplayDate() {
        StringBuffer buf = new StringBuffer();
        String val = String.valueOf(this.year);
        buf.append(val);
        buf.append("-");
        val = String.valueOf(this.month + 1);
        if (val.length() == 1) {
            buf.append("0");
        }
        buf.append(val);
        buf.append("-");
        val = String.valueOf(this.day);
        if (val.length() == 1) {
            buf.append("0");
        }
        buf.append(val);
        this.displayDate = buf.toString();
    }
}

