/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ActionMap;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import open.dolphin.log.LogWriter;

public class BaseTextPane
implements FocusListener,
CaretListener,
MouseListener,
DocumentListener,
UndoableEditListener {
    private static final String EDITOR_PROP = "editorProp";
    private static final String DIRTY_PROP = "dirtyProp";
    private static final String CAN_UNDO = "canUndoProp";
    private static final String CAN_REDO = "canRedoProp";
    private static final String CAN_CUT_COPY = "canCutCopyProp";
    private static final String CAN_PASTE = "canPsteProp";
    private JTextPane textPane;
    private boolean selected;
    private boolean canUndo;
    private boolean canRedo;
    private boolean canCutCopy;
    private boolean canPaste;
    private int initialLength;
    private boolean dirty;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    protected UndoManager undoManager;

    private BaseTextPane() {
        this.initCustomComponents(new DefaultStyledDocument());
    }

    private BaseTextPane(StyledDocument doc) {
        this.initCustomComponents(doc);
    }

    private void initCustomComponents(StyledDocument doc) {
        this.textPane = new JTextPane(doc);
        this.textPane.addFocusListener(this);
        this.textPane.addCaretListener(this);
        this.textPane.addMouseListener(this);
        this.textPane.getDocument().addDocumentListener(this);
        this.textPane.getDocument().addUndoableEditListener(this);
        this.undoManager = new UndoManager();
        this.canPaste = true;
        this.textPane.putClientProperty("baseTextPane", this);
        this.printActions();
    }

    private JTextPane getTextPane() {
        return this.textPane;
    }

    private ActionMap getActionMap() {
        return this.textPane.getActionMap();
    }

    private void addPropertyChangeListener(PropertyChangeListener listener) {
        this.boundSupport.addPropertyChangeListener(listener);
    }

    private void removePropertyChangeListener(PropertyChangeListener listener) {
        this.boundSupport.removePropertyChangeListener(listener);
    }

    private void printActions() {
        ActionMap map = this.textPane.getActionMap();
        if (map != null) {
            Object[] keys = map.allKeys();
            if (keys != null) {
                for (Object o : keys) {
                    LogWriter.info(this.getClass(), o.toString());
                }
            } else {
                LogWriter.info(this.getClass(), "keys are null");
            }
        } else {
            LogWriter.info(this.getClass(), "ActionMap is null");
        }
    }

    private boolean isCanUndo() {
        return this.canUndo;
    }

    private void setCanUndo(boolean b) {
        boolean old = this.canUndo;
        this.canUndo = b;
        this.boundSupport.firePropertyChange(CAN_UNDO, old, this.canUndo);
    }

    private boolean isCanRedo() {
        return this.canRedo;
    }

    private void setCanRedo(boolean b) {
        boolean old = this.canRedo;
        this.canRedo = b;
        this.boundSupport.firePropertyChange(CAN_REDO, old, this.canRedo);
    }

    private boolean isCanCutCopy() {
        return this.canCutCopy;
    }

    private void setCanCutCopy(boolean b) {
        boolean old = this.canCutCopy;
        this.canCutCopy = b;
        this.boundSupport.firePropertyChange(CAN_CUT_COPY, old, this.canCutCopy);
    }

    private boolean isCanPaste() {
        return this.canPaste;
    }

    public void setCanPaste(boolean b) {
        boolean old = this.canPaste;
        this.canPaste = b;
        this.boundSupport.firePropertyChange(CAN_PASTE, old, this.canPaste);
    }

    private boolean isSelected() {
        return this.selected;
    }

    private void setSelected(boolean selected) {
        boolean old = this.selected;
        this.selected = selected;
        if (old != this.selected) {
            this.setCanCutCopy(this.isSelected());
        }
    }

    private void undo() {
        this.undoManager.undo();
        this.update();
    }

    private void redo() {
        this.undoManager.redo();
        this.update();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (e.getDot() != e.getMark()) {
            LogWriter.info(this.getClass(), "selected");
            this.setSelected(true);
        } else {
            LogWriter.info(this.getClass(), "no selection");
            this.setSelected(false);
        }
    }

    private void popup(Component c, int x, int y) {
    }

    private void mabeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mabeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mabeShowPopup(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean dirty) {
        boolean old = this.dirty;
        this.dirty = dirty;
        if (old != this.dirty) {
            this.boundSupport.firePropertyChange(DIRTY_PROP, old, this.dirty);
        }
    }

    private void changed() {
        int len = this.textPane.getDocument().getLength();
        boolean d = this.initialLength != len;
        this.setDirty(d);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changed();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changed();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.changed();
    }

    private void update() {
        this.setCanUndo(this.undoManager.canUndo());
        this.setCanRedo(this.undoManager.canRedo());
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoManager.addEdit(e.getEdit());
        this.update();
    }

    private boolean isEditable() {
        return this.textPane.isEditable();
    }

    private void setEditable(boolean editable) {
        this.textPane.setEditable(editable);
    }

    private Insets getMargin() {
        return this.textPane.getMargin();
    }

    private void setMargin(Insets margin) {
        this.textPane.setMargin(margin);
    }

    private Color getBackground() {
        return this.textPane.getBackground();
    }

    private void setBackground(Color color) {
        this.textPane.setBackground(color);
    }

    private TransferHandler getTrasnferHandler() {
        return this.textPane.getTransferHandler();
    }

    private void setTrasnferHandlerTransferHandler(TransferHandler handler) {
        this.textPane.setTransferHandler(handler);
    }
}

