/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.im.InputSubset;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.RegexConstrainedDocument;
import open.dolphin.helper.GridBagBuilder;
import open.dolphin.infomodel.DepartmentModel;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.LicenseModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.project.GlobalConstants;

public class AccountInfoPanel
extends JPanel {
    private static final long serialVersionUID = -7695417342865642933L;
    public static final String VALID_INFO_PROP = "validInfoProp";
    private static final String MEMBER_TYPE = "ASP_TESTER";
    private JTextField facilityName;
    private JTextField zipField1;
    private JTextField zipField2;
    private JTextField addressField;
    private JTextField areaField;
    private JTextField cityField;
    private JTextField numberField;
    private JTextField urlField;
    private JTextField adminId;
    private JPasswordField adminPassword1;
    private JPasswordField adminPassword2;
    private JTextField adminSir;
    private JTextField adminGiven;
    private JComboBox licenseCombo;
    private JComboBox deptCombo;
    private LicenseModel[] licenses;
    private DepartmentModel[] depts;
    private JTextField emailField;
    private int[] userIdLength;
    private int[] passwordLength;
    private UserModel adminModel;
    private boolean validInfo;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);

    public AccountInfoPanel() {
        this.initComponents();
        this.initialize();
        this.connect();
        this.setModel(this.adminModel);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public UserModel getModel() {
        this.adminModel = new UserModel();
        return this.getAdminUser(this.adminModel);
    }

    public void setModel(UserModel adminModel) {
        this.adminModel = adminModel;
    }

    public boolean isValidInfo() {
        return this.validInfo;
    }

    public void setValidInfo(boolean b) {
        boolean old = this.validInfo;
        this.validInfo = b;
        this.boundSupport.firePropertyChange(VALID_INFO_PROP, old, this.validInfo);
    }

    public void addValidInfoPropertyListener(PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(VALID_INFO_PROP, l);
    }

    public void removeValidInfoPropertyListener(PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(VALID_INFO_PROP, l);
    }

    private UserModel getAdminUser(UserModel admin) {
        FacilityModel facility = new FacilityModel();
        admin.setFacility(facility);
        facility.setFacilityName(this.facilityName.getText().trim());
        StringBuilder buf = new StringBuilder();
        buf.append(this.zipField1.getText().trim());
        buf.append("-");
        buf.append(this.zipField2.getText().trim());
        facility.setZipCode(buf.toString());
        facility.setAddress(this.addressField.getText().trim());
        buf = new StringBuilder();
        buf.append(this.areaField.getText().trim());
        buf.append("-");
        buf.append(this.cityField.getText().trim());
        buf.append("-");
        buf.append(this.numberField.getText().trim());
        facility.setTelephone(buf.toString());
        facility.setUrl(this.urlField.getText().trim());
        Date date = new Date();
        facility.setRegisteredDate(date);
        facility.setMemberType(MEMBER_TYPE);
        admin.setUserId(this.adminId.getText().trim());
        admin.setPassword(new String(this.adminPassword1.getPassword()));
        admin.setSirName(this.adminSir.getText().trim());
        admin.setGivenName(this.adminGiven.getText().trim());
        admin.setCommonName(admin.getSirName() + " " + admin.getGivenName());
        int index = this.licenseCombo.getSelectedIndex();
        admin.setLicenseModel(this.licenses[index]);
        index = this.deptCombo.getSelectedIndex();
        admin.setDepartmentModel(this.depts[index]);
        admin.setEmail(this.emailField.getText().trim());
        admin.setMemberType(MEMBER_TYPE);
        admin.setRegisteredDate(date);
        return admin;
    }

    private void initialize() {
        FocusAdapter imeOn = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                JTextField tf = (JTextField)event.getSource();
                tf.getInputContext().setCharacterSubsets(new Character.Subset[]{InputSubset.KANJI});
            }
        };
        FocusAdapter imeOff = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                JTextField tf = (JTextField)event.getSource();
                tf.getInputContext().setCharacterSubsets(null);
            }
        };
        this.facilityName = new JTextField();
        this.facilityName.setColumns(30);
        this.facilityName.addFocusListener(imeOn);
        this.facilityName.setMargin(new Insets(1, 2, 1, 2));
        this.zipField1 = new JTextField();
        this.zipField1.setColumns(3);
        this.zipField1.addFocusListener(imeOff);
        this.zipField1.setMargin(new Insets(1, 2, 1, 2));
        this.zipField2 = new JTextField();
        this.zipField2.setColumns(3);
        this.zipField2.addFocusListener(imeOff);
        this.zipField2.setMargin(new Insets(1, 2, 1, 2));
        this.addressField = new JTextField();
        this.addressField.setColumns(30);
        this.addressField.addFocusListener(imeOn);
        this.addressField.setMargin(new Insets(1, 2, 1, 2));
        this.areaField = new JTextField();
        this.areaField.setColumns(3);
        this.areaField.addFocusListener(imeOff);
        this.areaField.setMargin(new Insets(1, 2, 1, 2));
        this.cityField = new JTextField();
        this.cityField.setColumns(3);
        this.cityField.addFocusListener(imeOff);
        this.cityField.setMargin(new Insets(1, 2, 1, 2));
        this.numberField = new JTextField();
        this.numberField.setColumns(3);
        this.numberField.addFocusListener(imeOff);
        this.numberField.setMargin(new Insets(1, 2, 1, 2));
        this.urlField = new JTextField();
        this.urlField.setColumns(30);
        this.urlField.addFocusListener(imeOff);
        this.urlField.setMargin(new Insets(1, 2, 1, 2));
        this.adminId = new JTextField();
        this.adminId.setColumns(10);
        this.adminId.addFocusListener(imeOff);
        this.adminId.setMargin(new Insets(1, 2, 1, 2));
        this.adminPassword1 = new JPasswordField();
        this.adminPassword1.setColumns(10);
        this.adminPassword1.addFocusListener(imeOff);
        this.adminPassword1.setMargin(new Insets(1, 2, 1, 2));
        this.adminPassword2 = new JPasswordField();
        this.adminPassword2.setColumns(10);
        this.adminPassword2.addFocusListener(imeOff);
        this.adminPassword2.setMargin(new Insets(1, 2, 1, 2));
        this.adminSir = new JTextField();
        this.adminSir.setColumns(10);
        this.adminSir.addFocusListener(imeOn);
        this.adminSir.setMargin(new Insets(1, 2, 1, 2));
        this.adminGiven = new JTextField();
        this.adminGiven.setColumns(10);
        this.adminGiven.addFocusListener(imeOn);
        this.adminGiven.setMargin(new Insets(1, 2, 1, 2));
        this.emailField = new JTextField();
        this.emailField.setColumns(15);
        this.emailField.addFocusListener(imeOff);
        this.emailField.setMargin(new Insets(1, 2, 1, 2));
        String digitPattern = "[0-9]*";
        RegexConstrainedDocument zip1Doc = new RegexConstrainedDocument(digitPattern);
        this.zipField1.setDocument(zip1Doc);
        RegexConstrainedDocument zip2Doc = new RegexConstrainedDocument(digitPattern);
        this.zipField2.setDocument(zip2Doc);
        RegexConstrainedDocument areaDoc = new RegexConstrainedDocument(digitPattern);
        this.areaField.setDocument(areaDoc);
        RegexConstrainedDocument cityDoc = new RegexConstrainedDocument(digitPattern);
        this.cityField.setDocument(cityDoc);
        RegexConstrainedDocument numberDoc = new RegexConstrainedDocument(digitPattern);
        this.numberField.setDocument(numberDoc);
        String pattern = "[A-Za-z0-9_+\\-.#$&@]*";
        RegexConstrainedDocument userIdDoc = new RegexConstrainedDocument(pattern);
        this.adminId.setDocument(userIdDoc);
        this.adminId.setToolTipText(pattern);
        RegexConstrainedDocument passwordDoc1 = new RegexConstrainedDocument(pattern);
        this.adminPassword1.setDocument(passwordDoc1);
        this.adminPassword1.setToolTipText(pattern);
        RegexConstrainedDocument passwordDoc2 = new RegexConstrainedDocument(pattern);
        this.adminPassword2.setDocument(passwordDoc2);
        this.adminPassword1.setToolTipText(pattern);
        pattern = "[A-Za-z0-9_\\-.@]*";
        RegexConstrainedDocument emailDoc = new RegexConstrainedDocument(pattern);
        this.emailField.setDocument(emailDoc);
        this.emailField.setToolTipText("\u6298\u308a\u8fd4\u3057\u65bd\u8a2dID\u3092\u9001\u4fe1\u3057\u307e\u3059");
        this.licenses = GlobalConstants.getLicenseModel();
        this.licenseCombo = new JComboBox<LicenseModel>(this.licenses);
        this.depts = GlobalConstants.getDepartmentModel();
        this.deptCombo = new JComboBox<DepartmentModel>(this.depts);
        JPanel facilityPanel = new JPanel(new BorderLayout());
        GridBagBuilder gbl = new GridBagBuilder(facilityPanel, "\u65bd\u8a2d\u60c5\u5831 - URL\u4ee5\u5916\u306e\u5168\u3066\u306e\u9805\u76ee\u304c\u5fc5\u8981\u3067\u3059");
        JLabel label = null;
        StringBuilder sb = null;
        int x = 0;
        int y = 0;
        label = new JLabel("\u533b\u7642\u6a5f\u95a2\u540d:", 4);
        gbl.add(label, x, y, 13);
        gbl.add(this.facilityName, x + 1, y, 17);
        x = 0;
        label = new JLabel("\u90f5\u4fbf\u756a\u53f7:", 4);
        gbl.add(label, x, ++y, 13);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0, 0, 0));
        p.add(this.zipField1);
        p.add(new JLabel(" - "));
        p.add(this.zipField2);
        gbl.add(p, x + 1, y, 17);
        x = 0;
        label = new JLabel("\u4f4f\u3000\u6240:", 4);
        gbl.add(label, x, ++y, 13);
        gbl.add((Component)this.addressField, x + 1, y, 2, 1, 17);
        x = 0;
        label = new JLabel("\u96fb\u8a71\u756a\u53f7:", 4);
        gbl.add(label, x, ++y, 13);
        JPanel telephonePanel = new JPanel();
        telephonePanel.setLayout(new FlowLayout(0, 0, 0));
        telephonePanel.add(this.areaField);
        telephonePanel.add(new JLabel(" - "));
        telephonePanel.add(this.cityField);
        telephonePanel.add(new JLabel(" - "));
        telephonePanel.add(this.numberField);
        gbl.add(telephonePanel, x + 1, y, 17);
        x = 0;
        label = new JLabel("URL:", 4);
        gbl.add(label, x, ++y, 13);
        gbl.add(this.urlField, x + 1, y, 17);
        this.add(facilityPanel);
        x = 0;
        y = 0;
        this.userIdLength = GlobalConstants.getIntArray("addUser.userId.length");
        sb = new StringBuilder();
        sb.append("\u7ba1\u7406\u8005\u30ed\u30b0\u30a4\u30f3ID(\u534a\u89d2\u82f1\u6570\u8a18)");
        sb.append(this.userIdLength[0]);
        sb.append("~");
        sb.append(this.userIdLength[1]);
        sb.append("\u6587\u5b57):");
        label = new JLabel(sb.toString(), 4);
        JPanel adminPanel = new JPanel(new BorderLayout());
        gbl = new GridBagBuilder(adminPanel, "\u3053\u306e\u533b\u7642\u6a5f\u95a2\u306eOpenDolphin\u7ba1\u7406\u8005\u60c5\u5831 - \u5168\u3066\u306e\u9805\u76ee\u304c\u5fc5\u8981\u3067\u3059");
        gbl.add(label, x, y, 13);
        gbl.add(this.adminId, x + 1, y, 17);
        x = 0;
        ++y;
        this.passwordLength = GlobalConstants.getIntArray("addUser.password.length");
        sb = new StringBuilder();
        sb.append("\u30d1\u30b9\u30ef\u30fc\u30c9(\u534a\u89d2\u82f1\u6570\u8a18)");
        sb.append(this.passwordLength[0]);
        sb.append("~");
        sb.append(this.passwordLength[1]);
        sb.append("\u6587\u5b57):");
        label = new JLabel(sb.toString(), 4);
        gbl.add(label, x, y, 13);
        gbl.add(this.adminPassword1, x + 1, y, 17);
        label = new JLabel("\u78ba\u8a8d:", 4);
        gbl.add(label, x + 2, y, 13);
        gbl.add(this.adminPassword2, x + 3, y, 17);
        x = 0;
        label = new JLabel("\u59d3\uff08\u6f22\u5b57\uff09:", 4);
        gbl.add(label, x, ++y, 13);
        gbl.add(this.adminSir, x + 1, y, 17);
        label = new JLabel("\u540d\uff08\u6f22\u5b57\uff09:", 4);
        gbl.add(label, x + 2, y, 13);
        gbl.add(this.adminGiven, x + 3, y, 17);
        x = 0;
        label = new JLabel("\u533b\u7642\u8cc7\u683c:", 4);
        gbl.add(label, x, ++y, 13);
        gbl.add(this.licenseCombo, x + 1, y, 17);
        label = new JLabel("\u8a3a\u7642\u79d1:", 4);
        gbl.add(label, x + 2, y, 13);
        gbl.add(this.deptCombo, x + 3, y, 17);
        x = 0;
        label = new JLabel("\u96fb\u5b50\u30e1\u30fc\u30eb:", 4);
        gbl.add(label, x, ++y, 13);
        gbl.add((Component)this.emailField, x + 1, y, 1, 1, 17);
        this.setLayout(new BoxLayout(this, 1));
        this.add(adminPanel);
    }

    private void connect() {
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AccountInfoPanel.this.checkValidInfo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AccountInfoPanel.this.checkValidInfo();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.facilityName.getDocument().addDocumentListener(dl);
        this.zipField1.getDocument().addDocumentListener(dl);
        this.zipField2.getDocument().addDocumentListener(dl);
        this.addressField.getDocument().addDocumentListener(dl);
        this.areaField.getDocument().addDocumentListener(dl);
        this.cityField.getDocument().addDocumentListener(dl);
        this.numberField.getDocument().addDocumentListener(dl);
        this.adminId.getDocument().addDocumentListener(dl);
        this.adminPassword1.getDocument().addDocumentListener(dl);
        this.adminSir.getDocument().addDocumentListener(dl);
        this.adminGiven.getDocument().addDocumentListener(dl);
        this.emailField.getDocument().addDocumentListener(dl);
    }

    private void checkValidInfo() {
        boolean infoOk = !this.facilityName.getText().trim().equals("") && !this.zipField1.getText().trim().equals("") && !this.zipField2.getText().trim().equals("") && !this.addressField.getText().trim().equals("") && !this.areaField.getText().trim().equals("") && !this.cityField.getText().trim().equals("") && !this.numberField.getText().trim().equals("") && this.validUserId() && this.validPassword() && !this.adminSir.getText().trim().equals("") && !this.adminGiven.getText().trim().equals("") && this.licenseCombo.getSelectedItem() != null && this.deptCombo.getSelectedItem() != null && !this.emailField.getText().trim().equals("");
        this.setValidInfo(infoOk);
    }

    private boolean validUserId() {
        String val = this.adminId.getText().trim();
        if (val.equals("")) {
            return false;
        }
        return val.length() >= this.userIdLength[0] && val.length() <= this.userIdLength[1];
    }

    private boolean validPassword() {
        String passwd1 = new String(this.adminPassword1.getPassword());
        String passwd2 = new String(this.adminPassword2.getPassword());
        if (passwd1.equals("") || passwd2.equals("")) {
            return false;
        }
        if (passwd1.length() < this.passwordLength[0] || passwd1.length() > this.passwordLength[1]) {
            return false;
        }
        if (passwd2.length() < this.passwordLength[0] || passwd2.length() > this.passwordLength[1]) {
            return false;
        }
        return passwd1.equals(passwd2);
    }
}

