/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service.remote;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.NoResultException;
import open.dolphin.client.IChart;
import open.dolphin.dto.PatientVisitSpec;
import open.dolphin.infomodel.AppointmentModel;
import open.dolphin.infomodel.HealthInsuranceModel;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.log.LogWriter;
import open.dolphin.service.DolphinService;
import open.dolphin.service.IPvtService;
import org.hibernate.HibernateException;

public class RemotePvtService
extends DolphinService
implements IPvtService {
    @Override
    public int addPvt(PatientVisitModel pvt) {
        block8: {
            this.roleAllowed("user");
            PatientModel patient = pvt.getPatient();
            String facilityId = this.getCallersFacilityId();
            pvt.setFacilityId(facilityId);
            patient.setFacilityId(facilityId);
            try {
                this.startTransaction();
                try {
                    Object existModel = this.getSession().createQuery("from PatientModel where facilityid = :fid and patientid = :pid").setParameter("fid", (Object)facilityId).setParameter("pid", (Object)patient.getPatientId()).uniqueResult();
                    if (existModel == null) {
                        throw new NoResultException();
                    }
                    PatientModel existPatient = (PatientModel)existModel;
                    Set<HealthInsuranceModel> ins = patient.getHealthInsurances();
                    if (ins != null && ins.size() > 0) {
                        ArrayList<HealthInsuranceModel> olds = new ArrayList<HealthInsuranceModel>(existPatient.getHealthInsurances());
                        for (HealthInsuranceModel model : olds) {
                            this.getSession().delete((Object)model);
                        }
                        existPatient.setHealthInsurances(patient.getHealthInsurances());
                    }
                    existPatient.setFamilyName(patient.getFamilyName());
                    existPatient.setGivenName(patient.getGivenName());
                    existPatient.setFullName(patient.getFullName());
                    existPatient.setKanaFamilyName(patient.getKanaFamilyName());
                    existPatient.setKanaGivenName(patient.getKanaGivenName());
                    existPatient.setKanaName(patient.getKanaName());
                    existPatient.setRomanFamilyName(patient.getRomanFamilyName());
                    existPatient.setRomanGivenName(patient.getRomanGivenName());
                    existPatient.setRomanName(patient.getRomanName());
                    existPatient.setGender(patient.getGender());
                    existPatient.setGenderDesc(patient.getGenderDesc());
                    existPatient.setGenderCodeSys(patient.getGenderCodeSys());
                    existPatient.setBirthday(patient.getBirthday());
                    existPatient.setAddress(patient.getAddress());
                    existPatient.setTelephone(patient.getTelephone());
                    pvt.setPatient(existPatient);
                }
                catch (NoResultException e) {
                    this.getSession().persist((Object)patient);
                    KarteBean karte = new KarteBean();
                    karte.setPatient(patient);
                    karte.setCreated(new Date());
                    this.getSession().persist((Object)karte);
                }
                if (pvt.getPvtDate() != null) {
                    this.getSession().persist((Object)pvt);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block8;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return 1;
    }

    @Override
    public List<PatientVisitModel> getPvt(PatientVisitSpec spec) {
        List result;
        block4: {
            String date = spec.getDate();
            if (!date.endsWith("%")) {
                date = date + "%";
            }
            int index = date.indexOf(37);
            Date theDate = ModelUtils.getDateAsObject(date.substring(0, index));
            int firstResult = spec.getSkipCount();
            String fid = this.getCallersFacilityId();
            String appoDateFrom = spec.getAppodateFrom();
            String appoDateTo = spec.getAppodateTo();
            boolean searchAppo = appoDateFrom != null && appoDateTo != null;
            result = null;
            try {
                this.startTransaction();
                result = this.getSession().createQuery("from PatientVisitModel where facilityid = :fid and pvtdate >= :date order by pvtdate").setParameter("fid", (Object)fid).setParameter("date", (Object)date).setFirstResult(firstResult).list();
                for (PatientVisitModel pvt : result) {
                    PatientModel patient = pvt.getPatient();
                    List insurances = this.getSession().createQuery("from HealthInsuranceModel where patient_id = :pk").setParameter("pk", (Object)patient.getId()).list();
                    patient.setHealthInsurances(new LinkedHashSet<HealthInsuranceModel>(insurances));
                    if (!searchAppo) continue;
                    KarteBean karte = (KarteBean)this.getSession().createQuery("from KarteBean where patient_id = :pk").setParameter("pk", (Object)patient.getId()).uniqueResult();
                    long karteId = karte.getId();
                    List c = this.getSession().createQuery("from AppointmentModel where karte_id = :karteId and date = :date").setParameter("karteId", (Object)karteId).setParameter("date", (Object)theDate).list();
                    if (c == null || c.size() <= 0) continue;
                    AppointmentModel appo = (AppointmentModel)c.get(0);
                    pvt.setAppointment(appo.getName());
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block4;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public int removePvt(long id) {
        int ret;
        block2: {
            this.roleAllowed("user");
            ret = 0;
            try {
                this.startTransaction();
                PatientVisitModel exist = (PatientVisitModel)this.getSession().createQuery("from PatientVisitModel where id = :id").setParameter("id", (Object)id).uniqueResult();
                this.getSession().delete((Object)exist);
                ret = 1;
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public int updatePvtState(long pk, IChart.state state2) {
        block2: {
            this.roleAllowed("user");
            try {
                this.startTransaction();
                PatientVisitModel exist = (PatientVisitModel)this.getSession().createQuery("from PatientVisitModel where id = :id").setParameter("id", (Object)pk).uniqueResult();
                exist.setState(state2);
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block2;
                this.getSession().getTransaction().rollback();
                LogWriter.error(this.getClass(), "Rollback", (Throwable)e);
            }
        }
        return 1;
    }
}

