/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import open.dolphin.infomodel.LetterModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.TouTouReply;

public class PDFReplyMaker {
    private static final String DOC_TITLE = "\u7d39\u4ecb\u60a3\u8005\u7d4c\u904e\u5831\u544a\u66f8";
    private static final String HEISEI_MIN_W3 = "HeiseiMin-W3";
    private static final String UNIJIS_UCS2_HW_H = "UniJIS-UCS2-HW-H";
    private static final int TOP_MARGIN = 75;
    private static final int LEFT_MARGIN = 75;
    private static final int BOTTOM_MARGIN = 75;
    private static final int RIGHT_MARGIN = 75;
    private static final int TITLE_FONT_SIZE = 14;
    private static final int BODY_FONT_SIZE = 12;
    private String documentDir;
    private String fileName;
    private TouTouReply model;
    private int marginLeft = 75;
    private int marginRight = 75;
    private int marginTop = 75;
    private int marginBottom = 75;
    private BaseFont baseFont;
    private Font titleFont;
    private Font bodyFont;
    private int titleFontSize = 14;
    private int bodyFontSize = 12;

    public boolean create() {
        boolean result = true;
        try {
            Document document = new Document(PageSize.A4, (float)this.getMarginLeft(), (float)this.getMarginRight(), (float)this.getMarginTop(), (float)this.getMarginBottom());
            if (this.documentDir == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(System.getProperty("user.dir"));
                sb.append(File.separator);
                sb.append("pdf");
                this.setDocumentDir(sb.toString());
            }
            File dir = new File(this.getDocumentDir());
            dir.mkdir();
            String name = this.model.getPatientName();
            name = name.replaceAll(" ", "");
            name = name.replaceAll("\u3000", "");
            StringBuilder sb = new StringBuilder();
            sb.append("\u7d39\u4ecb\u60a3\u8005\u7d4c\u904e\u5831\u544a\u66f8-");
            sb.append(name);
            sb.append("\u69d8-");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sb.append(sdf.format(new Date()));
            sb.append(".pdf");
            this.setFileName(sb.toString());
            sb = new StringBuilder();
            if (this.getDocumentDir() != null) {
                sb.append(this.getDocumentDir());
                sb.append(File.separator);
            }
            sb.append(this.getFileName());
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(sb.toString()));
            document.open();
            this.baseFont = BaseFont.createFont((String)HEISEI_MIN_W3, (String)UNIJIS_UCS2_HW_H, (boolean)false);
            this.titleFont = new Font(this.baseFont, (float)this.getTitleFontSize());
            this.bodyFont = new Font(this.baseFont, (float)this.getBodyFontSize());
            Paragraph para = new Paragraph(DOC_TITLE, this.titleFont);
            para.setAlignment(1);
            document.add((Element)para);
            String dateStr = this.getDateString(this.model.getConfirmed());
            para = new Paragraph(dateStr, this.bodyFont);
            para.setAlignment(2);
            document.add((Element)para);
            document.add((Element)new Paragraph("\u3000"));
            Paragraph para2 = new Paragraph(this.model.getClientHospital(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            para2 = new Paragraph(this.model.getClientDept(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            sb = new StringBuilder();
            sb.append(this.model.getClientDoctor());
            sb.append(" \u5148\u751f");
            para2 = new Paragraph(sb.toString(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            para2 = new Paragraph(this.model.getConsultantHospital(), this.bodyFont);
            para2.setAlignment(2);
            document.add((Element)para2);
            document.add((Element)new Paragraph("\u3000"));
            sb = new StringBuilder();
            sb.append("\u3054\u7d39\u4ecb\u3044\u305f\u3060\u304d\u307e\u3057\u305f ");
            sb.append(this.model.getPatientName());
            sb.append(" \u6bbf(\u751f\u5e74\u6708\u65e5: ");
            sb.append(this.getDateString(this.model.getPatientBirthday()));
            sb.append(")\u3001");
            sb.append(this.getDateString(this.model.getVisited()));
            sb.append(" \u53d7\u8a3a\u3055\u308c\u3001");
            sb.append("\u62dd\u898b\u3057\u3001\u4e0b\u8a18\u306e\u3068\u304a\u308a\u8aac\u660e\u3044\u305f\u3057\u307e\u3057\u305f\u3002");
            para2 = new Paragraph(sb.toString(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            document.add((Element)new Paragraph("\u3000"));
            para2 = new Paragraph(this.model.getInformedContent(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            document.add((Element)new Paragraph("\u3000"));
            document.add((Element)new Paragraph("\u3000"));
            sb = new StringBuilder();
            sb.append("\u3054\u7d39\u4ecb\u3044\u305f\u3060\u304d\u3001\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3057\u305f\u3002");
            para2 = new Paragraph(sb.toString(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            sb = new StringBuilder();
            sb.append("\u53d6\u308a\u6025\u304e\u8fd4\u4fe1\u307e\u3067\u3002");
            para2 = new Paragraph(sb.toString(), this.bodyFont);
            para2.setAlignment(0);
            document.add((Element)para2);
            para2 = new Paragraph(this.model.getConsultantHospital(), this.bodyFont);
            para2.setAlignment(2);
            document.add((Element)para2);
            document.close();
        }
        catch (IOException ex) {
            result = false;
        }
        catch (DocumentException ex) {
            result = false;
        }
        return result;
    }

    private String getDateString(Date d) {
        return ModelUtils.getDateAsFormatString(d, "yyyy\u5e74M\u6708d\u65e5");
    }

    private String getDateString(String date) {
        Date d = ModelUtils.getDateAsObject(date);
        return ModelUtils.getDateAsFormatString(d, "yyyy\u5e74M\u6708d\u65e5");
    }

    private String getSexString(String sex) {
        return sex;
    }

    public LetterModel getModel() {
        return this.model;
    }

    public void setModel(TouTouReply model) {
        this.model = model;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginleft) {
        this.marginLeft = marginleft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getTitleFontSize() {
        return this.titleFontSize;
    }

    public void setTitleFontSize(int titleFontSize) {
        this.titleFontSize = titleFontSize;
    }

    public int getBodyFontSize() {
        return this.bodyFontSize;
    }

    public void setBodyFontSize(int bodyFontSize) {
        this.bodyFontSize = bodyFontSize;
    }

    public String getDocumentDir() {
        return this.documentDir;
    }

    public void setDocumentDir(String documentDir) {
        this.documentDir = documentDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

