/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.ClaimMessageEvent;
import open.dolphin.client.DirectionDialog;
import open.dolphin.client.EditorFrame;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.IKartePanel;
import open.dolphin.client.KartePane;
import open.dolphin.client.KartePaneDumper;
import open.dolphin.client.KartePaneTransferHandler;
import open.dolphin.client.KartePanelDouble;
import open.dolphin.client.KartePanelSingle;
import open.dolphin.client.KarteRenderer;
import open.dolphin.client.KarteStyledDocument;
import open.dolphin.client.MmlMessageEvent;
import open.dolphin.client.PrintablePanel;
import open.dolphin.client.SOATransferHandler;
import open.dolphin.client.SaveDialog;
import open.dolphin.client.SaveParams;
import open.dolphin.client.karte.template.TemplateManager;
import open.dolphin.client.karte.template.error.CantWriteTemplateException;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.exception.DolphinException;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.helper.KarteHeader;
import open.dolphin.infomodel.AccessRightModel;
import open.dolphin.infomodel.BeanUtils;
import open.dolphin.infomodel.BundleMed;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.ExtRefModel;
import open.dolphin.infomodel.ID;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.IStampInfo;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.infomodel.ProgressCourse;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.message.ClaimHelper;
import open.dolphin.message.MMLHelper;
import open.dolphin.message.MessageBuilder;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.sendclaim.SendClaimImpl;
import open.dolphin.sendmml.SendMmlImpl;
import open.dolphin.utils.StringTool;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class KarteEditor
extends JPanel
implements IInfoModel,
IChartDocument {
    public static final int SINGLE_MODE = 1;
    public static final int DOUBLE_MODE = 2;
    private static final String DEFAULT_TITLE = "\u7d4c\u904e\u8a18\u9332";
    private int mode = 2;
    private DocumentModel model;
    private JLabel timeStampLabel;
    private String timeStamp;
    private boolean insuranceVisible;
    private KartePane soaPane;
    private KartePane pPane;
    private IKartePanel panel2;
    private boolean editable;
    private boolean modify;
    private SendClaimImpl claimListener;
    private SendMmlImpl mmlListener;
    private boolean sendMml;
    private StateMgr stateMgr;
    private boolean isHospital;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "showNewest", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title = GlobalVariables.getDefaultKarteTitle();
    private boolean isOpenFrame;
    private JScrollPane jScrollPane1;
    private JPanel kartePanel;

    public KarteEditor(IChart parent) {
        this.parent = parent;
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(GlobalSettings.karteScrollUnitIncrement());
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.KarteEditor;
    }

    private void setProgressModules(KartePaneDumper dumper, IStampInfo progressInfo) {
        ProgressCourse progressCourse = new ProgressCourse();
        progressCourse.setFreeText(dumper.getSpec());
        ModuleModel progressModule = new ModuleModel();
        progressModule.setModuleInfo(progressInfo);
        progressModule.setModel(progressCourse);
        this.model.addModule(progressModule);
    }

    private boolean setModules(KartePaneDumper dumper) {
        ModuleModel[] modules = dumper.getModules();
        if (modules != null && modules.length > 0) {
            this.model.addModule(modules);
            return true;
        }
        return false;
    }

    private boolean setSchemas(KartePaneDumper dumper) {
        SchemaModel[] schemas = dumper.getSchemas();
        if (schemas != null && schemas.length > 0) {
            for (SchemaModel schema : schemas) {
                ImageIcon icon = schema.getIcon();
                schema.setJpegBytes(this.convertIconToJPEGBytes(icon));
                schema.setIcon(null);
                this.model.addSchema(schema);
            }
            return true;
        }
        return false;
    }

    private byte[] convertIconToJPEGBytes(ImageIcon icon) {
        int maxImageWidth = 522;
        int maxImageHeight = 522;
        Dimension maxSImageSize = new Dimension(maxImageWidth, maxImageHeight);
        icon = this.adjustImageSize(icon, maxSImageSize);
        return this.getJPEGByte(icon.getImage());
    }

    private KartePaneDumper exportEditPane(KartePane pane) {
        KartePaneDumper dumper = new KartePaneDumper();
        KarteStyledDocument doc = (KarteStyledDocument)pane.getTextPane().getDocument();
        dumper.dump(doc);
        return dumper;
    }

    private void exportPPane(IStampInfo progressInfo) {
        KartePaneDumper dumper = this.exportEditPane(this.pPane);
        this.setModules(dumper);
        this.setProgressModules(dumper, progressInfo);
    }

    private void exportSOAPane(IStampInfo progressInfo) {
        KartePaneDumper dumper = this.exportEditPane(this.soaPane);
        this.setModules(dumper);
        this.setSchemas(dumper);
        this.setProgressModules(dumper, progressInfo);
    }

    private void buildTimeStampLabel() {
        this.initTimeStamp();
        StringBuilder sb = new StringBuilder();
        if (this.isHospital) {
            sb.append("\u5165\u9662    ");
        }
        sb.append(this.timeStamp);
        String selecteIns = this.getHealthInsurance();
        if (selecteIns != null) {
            sb.append(" (");
            sb.append(selecteIns);
            sb.append(")");
        }
        this.timeStampLabel.setText(sb.toString());
        this.timeStampLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    KarteEditor.this.setInsuranceVisible(!KarteEditor.this.isInsuranceVisible());
                }
                e.consume();
            }
        });
        this.setInsuranceVisible(true);
    }

    private String getHealthInsurance() {
        PVTHealthInsuranceModel[] insurances = null;
        if (this.getParentContext() instanceof ChartWindow) {
            insurances = ((ChartWindow)this.getParentContext()).getHealthInsurances();
        } else if (this.getParentContext() instanceof EditorFrame) {
            EditorFrame frame = (EditorFrame)this.getParentContext();
            ChartWindow chart = (ChartWindow)frame.getChart();
            insurances = chart.getHealthInsurances();
        }
        String insGUID = this.getModel().getDocInfo().getHealthInsuranceGUID();
        if (insGUID == null) {
            return null;
        }
        for (PVTHealthInsuranceModel insurance : insurances) {
            if (!insurance.getGUID().equals(insGUID)) continue;
            return insurance.toString();
        }
        return null;
    }

    private String getKarteTitle() {
        String text = this.model.getDocInfo().getTitle();
        if (StringTool.isEmptyString(text) && StringTool.isEmptyString(text = GlobalVariables.getPreferences().getBoolean("useTop15AsTitle", true) ? this.soaPane.getTitle() : GlobalVariables.getDefaultKarteTitle())) {
            text = DEFAULT_TITLE;
        }
        return text;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.kartePanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setName("jScrollPane1");
        this.kartePanel.setName("kartePanel");
        this.kartePanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.kartePanel);
        this.add((Component)this.jScrollPane1, "Center");
    }

    public void setOpenFrame(boolean isOpenFrame) {
        this.isOpenFrame = isOpenFrame;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    private DocumentModel getModel() {
        return this.model;
    }

    public void setModel(DocumentModel model) {
        this.model = model;
    }

    public void setIsHospital(boolean isHospital) {
        this.isHospital = isHospital;
    }

    private int getActualHeight() {
        try {
            JTextPane pane = this.soaPane.getTextPane();
            int pos = pane.getDocument().getLength();
            Rectangle r = pane.modelToView(pos);
            int hsoa = r.y;
            if (this.pPane == null) {
                return hsoa;
            }
            pane = this.pPane.getTextPane();
            pos = pane.getDocument().getLength();
            r = pane.modelToView(pos);
            int hp = r.y;
            return Math.max(hsoa, hp);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void printPanel2(PageFormat format) {
        String name = this.getParentContext().getPatient().getFullName();
        ((PrintablePanel)((Object)this.panel2)).printPanel(format, 1, false, name, this.getActualHeight() + 30);
    }

    private void printPanel2(PageFormat format, int copies, boolean useDialog) {
        String name = this.getParentContext().getPatient().getFullName();
        ((PrintablePanel)((Object)this.panel2)).printPanel(format, copies, useDialog, name, this.getActualHeight() + 30);
    }

    private void initTimeStamp() {
        Date now = new Date();
        if (this.model.getConfirmDate() != null) {
            try {
                now = this.model.getConfirmed();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.modify) {
            KarteHeader header = new KarteHeader(this.model, "\u66f4\u65b0");
            this.timeStamp = header.toString();
        } else {
            KarteHeader header = new KarteHeader(this.model, "\u65b0\u898f");
            this.timeStamp = header.toString();
        }
    }

    private AccessRightModel setCreatorAccessRight() {
        AccessRightModel ar = new AccessRightModel();
        ar.setPermission("all");
        ar.setLicenseeCode("creator");
        ar.setLicenseeName("\u8a18\u8f09\u8005\u65bd\u8a2d");
        ar.setLicenseeCodeType("facilityCode");
        return ar;
    }

    private AccessRightModel setExperienceAccessRight() {
        AccessRightModel ar = new AccessRightModel();
        ar.setPermission("read");
        ar.setLicenseeCode("experience");
        ar.setLicenseeName("\u8a3a\u7642\u6b74\u306e\u3042\u308b\u65bd\u8a2d");
        ar.setLicenseeCodeType("facilityCode");
        return ar;
    }

    private AccessRightModel setPatientAccessRight() {
        AccessRightModel ar = new AccessRightModel();
        ar.setPermission("read");
        ar.setLicenseeCode("patient");
        ar.setLicenseeName("\u88ab\u8a18\u8f09\u8005(\u60a3\u8005)");
        ar.setLicenseeCodeType("personCode");
        return ar;
    }

    private void toHankakuNumFor(ModuleModel bean) {
        ClaimBundle bundle = null;
        if (bean.getModel() instanceof BundleMed) {
            bundle = (BundleMed)bean.getModel();
        } else if (bean.getModel() instanceof ClaimBundle) {
            bundle = (ClaimBundle)bean.getModel();
        }
        if (bundle != null) {
            String bNum;
            ClaimItem[] items = bundle.getClaimItem();
            if (items != null && items.length > 0) {
                for (ClaimItem item : items) {
                    String num = item.getNumber();
                    if (num == null) continue;
                    item.setNumber(num);
                }
            }
            if ((bNum = bundle.getBundleNumber()) != null) {
                bundle.setBundleNumber(bNum);
            }
        }
    }

    private boolean print() {
        PageFormat pageFormat = this.getParentContext().getContext().getPageFormat();
        this.printPanel2(pageFormat);
        return true;
    }

    private boolean direction() {
        DirectionDialog direction = new DirectionDialog(null, true, this.getActualModel());
        direction.setVisible(true);
        return true;
    }

    protected KartePane getSOAPane() {
        return this.soaPane;
    }

    protected KartePane getPPane() {
        return this.pPane;
    }

    public void setEditable(boolean newState) {
        this.editable = newState;
    }

    public void addMMLListner(SendMmlImpl listener) throws TooManyListenersException {
        if (this.mmlListener != null) {
            throw new TooManyListenersException();
        }
        this.mmlListener = listener;
    }

    public void addCLAIMListner(SendClaimImpl listener) throws TooManyListenersException {
        if (this.claimListener != null) {
            throw new TooManyListenersException();
        }
        this.claimListener = listener;
    }

    public void removeCLAIMListener(SendClaimImpl listener) {
        if (this.claimListener != null && this.claimListener == listener) {
            this.claimListener = null;
        }
    }

    protected void setModify(boolean newState) {
        this.modify = newState;
    }

    @Override
    public void enter() {
        this.getParentContext().getStatusPanel().setMessage("");
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.enabledAction("newDocument", true);
        this.enabledAction("addUser", GlobalVariables.isAdmin());
        this.stateMgr.controlMenu();
    }

    @Override
    public void setDirty(boolean dirty) {
        if (this.getMode() == 1) {
            this.stateMgr.setDirty(this.soaPane.isDirty());
        } else {
            this.stateMgr.setDirty(this.soaPane.isDirty() || this.pPane.isDirty());
        }
    }

    @Override
    public boolean itLayoutSaved() {
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.stateMgr.isDirty();
    }

    public void initialize() {
        this.stateMgr = new StateMgr();
        switch (this.getMode()) {
            case 1: {
                this.initializeSingleMode();
                break;
            }
            case 2: {
                this.initializeDoubleMode();
                break;
            }
        }
    }

    private KartePane createKartePane(JTextPane textPane, String role) {
        KartePane pane = new KartePane(this);
        pane.setTextPane(textPane);
        pane.setRole(role);
        return pane;
    }

    private void createSOAPane(JTextPane textPane) {
        if (textPane != null) {
            this.soaPane = this.createKartePane(textPane, "soa");
            this.soaPane.getTextPane().setTransferHandler(new SOATransferHandler(this.soaPane));
            if (this.model != null) {
                String docId = this.model.getDocInfo().getDocId();
                this.soaPane.setDocId(docId);
            }
        }
    }

    private void createPPane(JTextPane textPane) {
        if (textPane != null) {
            this.pPane = this.createKartePane(textPane, "p");
            this.pPane.getTextPane().setTransferHandler(new KartePaneTransferHandler(this.parent, this.pPane));
        }
    }

    private void initializePanel(IKartePanel panel) {
        this.timeStampLabel = panel.getTimeStampLabel();
        this.createSOAPane(panel.getSoaTextPane());
        this.createPPane(panel.getPTextPane());
        this.kartePanel.add((Component)((PrintablePanel)((Object)panel)), "Center");
        this.displayModel();
    }

    private void initializeSingleMode() {
        this.panel2 = new KartePanelSingle(this.isHospital);
        this.initializePanel(this.panel2);
    }

    private void initializeDoubleMode() {
        this.panel2 = new KartePanelDouble(this.isHospital);
        this.initializePanel(this.panel2);
    }

    @Override
    public void start() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        switch (this.getMode()) {
            case 1: {
                this.startSingleMode(mediator);
                break;
            }
            case 2: {
                this.startDoubleMode(mediator);
                break;
            }
        }
    }

    @Override
    public void stop() {
    }

    private void setAccessRight(DocInfoModel docInfo, SaveParams params) {
        docInfo.addAccessRight(this.setCreatorAccessRight());
        if (params != null && params.isAllowPatientRef()) {
            docInfo.addAccessRight(this.setPatientAccessRight());
        }
        if (params != null && params.isAllowClinicRef()) {
            docInfo.addAccessRight(this.setExperienceAccessRight());
        }
    }

    private int setModuleInfos(KarteBean karte, DocInfoModel docInfo) {
        Set<ModuleModel> moduleBeans = this.model.getModules();
        int number = 0;
        int totalSize = 0;
        for (ModuleModel bean : moduleBeans) {
            bean.setId(0L);
            bean.setKarte(karte);
            bean.setCreator(GlobalVariables.getUserModel());
            bean.setDocument(this.model);
            bean.setConfirmed(docInfo.getConfirmDate());
            bean.setFirstConfirmed(docInfo.getFirstConfirmDate());
            bean.setRecorded(docInfo.getConfirmDate());
            bean.setStatus("F");
            this.toHankakuNumFor(bean);
            bean.setBeanBytes(BeanUtils.getXMLBytes(bean.getModel()));
            IStampInfo mInfo = bean.getModuleInfo();
            mInfo.setStampNumber(number++);
            int size = bean.getBeanBytes().length / 1024;
            totalSize += size;
        }
        return totalSize;
    }

    private int setSchemaInfos(KarteBean karte, DocInfoModel docInfo) {
        int number = 0;
        int totalSize = 0;
        Set<SchemaModel> imagesimages = this.model.getSchemas();
        if (imagesimages != null && imagesimages.size() > 0) {
            for (SchemaModel bean : imagesimages) {
                bean.setId(0L);
                bean.setKarte(karte);
                bean.setCreator(GlobalVariables.getUserModel());
                bean.setDocument(this.model);
                bean.setConfirmed(docInfo.getConfirmDate());
                bean.setFirstConfirmed(docInfo.getFirstConfirmDate());
                bean.setRecorded(docInfo.getConfirmDate());
                bean.setStatus("F");
                bean.setImageNumber(number);
                ExtRefModel ref = bean.getExtRef();
                StringBuilder sb = new StringBuilder();
                sb.append(this.model.getDocInfo().getDocId());
                sb.append("-");
                sb.append(number);
                sb.append(".jpg");
                ref.setHref(sb.toString());
                int size = bean.getJpegBytes().length / 1024;
                totalSize += size;
                ++number;
            }
        }
        return totalSize;
    }

    private void setupEJBModels(DocInfoModel docInfo) {
        KarteBean karte = this.getParentContext().getKarte();
        this.model.setKarte(karte);
        this.model.setCreator(GlobalVariables.getUserModel());
        this.model.setRecorded(docInfo.getConfirmDate());
        this.setModuleInfos(karte, docInfo);
        this.setSchemaInfos(karte, docInfo);
    }

    private void startSingleMode(ChartMediator mediator) {
        this.soaPane.init(this.editable, mediator);
        this.enter();
    }

    private void startDoubleMode(ChartMediator mediator) {
        this.soaPane.init(this.editable, mediator);
        this.pPane.init(this.editable, mediator);
        this.enter();
    }

    private void displayModel() {
        this.buildTimeStampLabel();
        if (this.model.getModules() != null) {
            KarteRenderer renderer = new KarteRenderer(this.soaPane, this.pPane);
            renderer.render(this.model);
        }
    }

    private void setInsuranceVisible(boolean newState) {
        if (this.insuranceVisible != newState) {
            this.insuranceVisible = newState;
            StringBuilder sb = new StringBuilder();
            sb.append(this.timeStamp);
            if (newState) {
                sb.append(" (");
                sb.append(this.getModel().getDocInfo().getHealthInsuranceDesc());
                sb.append(")");
            }
            this.timeStampLabel.setText(sb.toString());
            this.timeStampLabel.revalidate();
        }
    }

    private boolean isInsuranceVisible() {
        return this.insuranceVisible;
    }

    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case save: {
                return this.save();
            }
            case direction: {
                return this.direction();
            }
            case print: {
                return this.print();
            }
        }
        return false;
    }

    private void setSaveMode(SaveParams params) {
        switch (GlobalVariables.getSaveKarteMode()) {
            case 0: {
                if (GlobalVariables.getSendClaim()) {
                    params.setStatus("F");
                    break;
                }
                params.setStatus("M");
                break;
            }
            case 1: {
                params.setStatus("T");
                break;
            }
        }
    }

    private SaveParams createDefaultSaveParams() {
        SaveParams params = new SaveParams(GlobalVariables.getJoinAreaNetwork());
        params.setTitle(this.getKarteTitle());
        params.setDepartment(this.model.getDocInfo().getDepartmentDesc());
        params.setPrintCount(GlobalVariables.getPrintKarteCount());
        params.setDisableSendClaim(this.getMode() == 1);
        params.setSendClaim(GlobalVariables.getSendClaim());
        params.setAllowPatientRef(false);
        params.setAllowClinicRef(false);
        this.setSaveMode(params);
        return params;
    }

    private SaveParams getSaveParams() {
        Window parentWindow;
        SaveDialog dialog;
        SaveParams params = this.createDefaultSaveParams();
        ID masterID = GlobalVariables.getMasterId(this.getParentContext().getPatient().getPatientId());
        boolean bl = this.sendMml = GlobalVariables.getSendMML() && masterID != null && this.mmlListener != null;
        if (GlobalVariables.getConfirmAtSave() && (params = (dialog = new SaveDialog(parentWindow = SwingUtilities.getWindowAncestor(this), params)).open()) != null) {
            GlobalVariables.setPrintKarteCount(params.getPrintCount());
        }
        return params;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    public boolean save() {
        if (this.stateMgr.isDirty()) {
            try {
                SaveParams params = this.getSaveParams();
                if (params != null) {
                    switch (this.getMode()) {
                        case 1: {
                            this.saveSingleMode(params);
                            break;
                        }
                        case 2: {
                            this.saveDoubleMode(params);
                            break;
                        }
                    }
                }
            }
            catch (DolphinException dolphinException) {
                // empty catch block
            }
        }
        return true;
    }

    public DocumentModel getActualModel() {
        DocumentModel result = null;
        try {
            switch (this.getMode()) {
                case 1: {
                    result = this.getActualModelAtSingleMode(null);
                }
                case 2: {
                    result = this.getActualModelAtDoubleMode(null);
                }
            }
        }
        catch (DolphinException dolphinException) {
            // empty catch block
        }
        return result;
    }

    private void closeEditor() {
        if (this.isOpenFrame) {
            JFrame frame = (JFrame)this.getRootPane().getParent();
            frame.setVisible(false);
            frame.dispose();
        } else {
            this.getParentContext().closeChartDocument(this.title, this);
        }
        if (this.canNewEditor()) {
            this.enabledAction("newDocument", true);
            this.enabledAction("direction", false);
        }
        this.getParentContext().getChartMediator().unsetAccepter(this);
    }

    private boolean canNewEditor() {
        IChart chart = this.getParentContext();
        if (chart instanceof EditorFrame) {
            return !((ChartWindow)((EditorFrame)this.getParentContext()).getChart()).existEditorPane() || this.getMode() == 2;
        }
        return !((ChartWindow)this.getParentContext()).existEditorPane() || this.getMode() == 2;
    }

    private DocumentModel getActualModelAtSingleMode(SaveParams params) throws DolphinException {
        DocInfoModel docInfo = this.model.getDocInfo();
        docInfo.setConfirmDate(new Date());
        if (docInfo.getParentId() == null) {
            docInfo.setFirstConfirmDate(new Date());
        }
        if (params != null) {
            docInfo.setTitle(params.getTitle());
        }
        this.setAccessRight(docInfo, params);
        IStampInfo[] progressInfo = this.model.getModuleInfo("progressCourse");
        if (progressInfo == null) {
            progressInfo = new ModuleInfoBean[1];
            ModuleInfoBean mi = new ModuleInfoBean();
            mi.initialize(null, "progressCourse", null, "progressCourse", "soaSpec");
            progressInfo[0] = mi;
        }
        this.model.clearModules();
        this.model.clearSchema();
        this.exportSOAPane(progressInfo[0]);
        docInfo.setHasImage(this.model.getSchemas() != null);
        this.setupEJBModels(docInfo);
        return this.model;
    }

    private void saveSingleMode(final SaveParams params) throws DolphinException {
        final DocumentModel saveModel = this.getActualModelAtSingleMode(params);
        final DocInfoModel docInfo = saveModel.getDocInfo();
        final IChart chart = this.parent;
        boolean admitFlag = this.isHospital;
        if (params.getStatus().equals("A")) {
            this.saveAsTemplateSingle(saveModel);
            return;
        }
        DBTask<String> task = new DBTask<String>(chart){
            final RemoteDocumentDelegater ddl;
            {
                super(x0);
                this.ddl = new RemoteDocumentDelegater();
            }

            protected String doInBackground() throws Exception {
                this.ddl.putDocument(saveModel);
                if (!this.ddl.isError()) {
                    return null;
                }
                return this.ddl.getErrorMessage();
            }

            protected void succeeded(String errMsg) {
                if (!this.ddl.isError()) {
                    int copies = params.getPrintCount();
                    if (copies > 0) {
                        KarteEditor.this.printPanel2(chart.getContext().getPageFormat(), copies, false);
                    }
                    KarteEditor.this.soaPane.setEditableProp(false);
                    KarteEditor.this.stateMgr.beSaved();
                    if (docInfo.getStatus().equals("T")) {
                        chart.setChartState(IChart.state.OPEN_NONE);
                    } else if (docInfo.getStatus().equals("F")) {
                        chart.setChartState(IChart.state.OPEN_SAVE);
                    }
                    chart.getDocumentHistory().getDocumentHistory();
                    KarteEditor.this.closeEditor();
                } else {
                    JOptionPane.showMessageDialog(chart.getFrame(), errMsg, GlobalConstants.getFrameTitle("\u30ab\u30eb\u30c6\u4fdd\u5b58"), 2);
                }
            }
        };
        task.execute();
    }

    private DocumentModel getActualModelAtDoubleMode(SaveParams params) throws DolphinException {
        DocInfoModel docInfo = this.model.getDocInfo();
        docInfo.setConfirmDate(new Date());
        if (docInfo.getParentId() == null) {
            docInfo.setFirstConfirmDate(docInfo.getConfirmDate());
        }
        if (params != null) {
            docInfo.setTitle(params.getTitle());
        }
        this.setAccessRight(docInfo, params);
        IStampInfo soaProgressInfo = null;
        IStampInfo pProgressInfo = null;
        IStampInfo[] progressInfos = this.model.getModuleInfo("progressCourse");
        if (progressInfos == null) {
            soaProgressInfo = new ModuleInfoBean();
            soaProgressInfo.initialize(null, "progressCourse", null, "progressCourse", "soaSpec");
            pProgressInfo = new ModuleInfoBean();
            pProgressInfo.initialize(null, "progressCourse", null, "progressCourse", "pSpec");
        } else if (progressInfos[0].getStampRole().equals("soaSpec")) {
            soaProgressInfo = progressInfos[0];
            pProgressInfo = progressInfos[1];
        } else if (progressInfos[1].getStampRole().equals("soaSpec")) {
            pProgressInfo = progressInfos[0];
            soaProgressInfo = progressInfos[1];
        }
        this.model.clearModules();
        this.model.clearSchema();
        this.exportSOAPane(soaProgressInfo);
        this.exportPPane(pProgressInfo);
        docInfo.setHasImage(this.model.getSchemas() != null);
        docInfo.setHasRp(this.model.getModule("medOrder") != null);
        docInfo.setHasTreatment(this.model.getModule("treatmentOrder") != null);
        docInfo.setHasLaboTest(this.model.getModule("testOrder") != null);
        this.setupEJBModels(docInfo);
        return this.model;
    }

    private void saveDoubleMode(final SaveParams params) throws DolphinException {
        final DocumentModel saveModel = this.getActualModelAtDoubleMode(params);
        if (params.getStatus().equals("A")) {
            this.saveAsTemplateDouble(saveModel, params);
            return;
        }
        final DocInfoModel docInfo = saveModel.getDocInfo();
        docInfo.setStatus(params.getStatus());
        final IChart chart = this.parent;
        final boolean admitFlag = this.isHospital;
        DBTask<String> task = new DBTask<String>(chart){
            final RemoteDocumentDelegater ddl;
            Cursor currentCursor;
            {
                super(x0);
                this.ddl = new RemoteDocumentDelegater();
            }

            protected String doInBackground() throws Exception {
                this.currentCursor = KarteEditor.this.getCursor();
                KarteEditor.this.setCursor(new Cursor(3));
                this.ddl.putDocument(saveModel);
                if (!this.ddl.isError()) {
                    if (params.isSendClaim()) {
                        KarteEditor.this.sendClaim(saveModel, admitFlag);
                    }
                    if (KarteEditor.this.sendMml) {
                        KarteEditor.this.sendMml(saveModel);
                    }
                    return null;
                }
                return this.ddl.getErrorMessage();
            }

            protected void succeeded(String errMsg) {
                if (!this.ddl.isError()) {
                    int copies = params.getPrintCount();
                    if (copies > 0) {
                        KarteEditor.this.printPanel2(chart.getContext().getPageFormat(), copies, false);
                    }
                    KarteEditor.this.soaPane.setEditableProp(false);
                    KarteEditor.this.pPane.setEditableProp(false);
                    KarteEditor.this.stateMgr.beSaved();
                    if (docInfo.getStatus().equals("T")) {
                        chart.setChartState(IChart.state.OPEN_NONE);
                    } else if (docInfo.getStatus().equals("F")) {
                        chart.setChartState(IChart.state.OPEN_SAVE);
                    }
                    chart.getDocumentHistory().getDocumentHistory();
                    KarteEditor.this.closeEditor();
                } else {
                    JOptionPane.showMessageDialog(chart.getFrame(), errMsg, GlobalConstants.getFrameTitle("\u30ab\u30eb\u30c6\u4fdd\u5b58"), 2);
                }
                KarteEditor.this.setCursor(this.currentCursor);
            }
        };
        task.execute();
    }

    private void saveAsTemplateSingle(DocumentModel saveModel) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void saveAsTemplateDouble(DocumentModel saveModel, SaveParams params) {
        File localStorage = GlobalConstants.getApplicationContext().getLocalStorage().getDirectory();
        File directory = new File(localStorage, "templates");
        TemplateManager manager = new TemplateManager(directory);
        try {
            manager.createTemplate(saveModel);
        }
        catch (CantWriteTemplateException ex) {
            JOptionPane.showMessageDialog(this.getParentContext().getFrame(), "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f", GlobalConstants.getFrameTitle("\u30ab\u30eb\u30c6\u4fdd\u5b58"), 2);
            return;
        }
        int copies = params.getPrintCount();
        if (copies > 0) {
            this.printPanel2(this.getParentContext().getContext().getPageFormat(), copies, false);
        }
        this.soaPane.setEditableProp(false);
        this.pPane.setEditableProp(false);
        this.stateMgr.beSaved();
        this.getParentContext().setChartState(IChart.state.OPEN_NONE);
        this.closeEditor();
    }

    private byte[] getJPEGByte(Image image) {
        byte[] ret;
        block4: {
            ret = null;
            FilterOutputStream writer = null;
            try {
                Dimension d = new Dimension(image.getWidth(this), image.getHeight(this));
                BufferedImage bf = new BufferedImage(d.width, d.height, 1);
                Graphics g = bf.getGraphics();
                g.setColor(Color.white);
                g.drawImage(image, 0, 0, d.width, d.height, this);
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                writer = new BufferedOutputStream(bo);
                ImageIO.write((RenderedImage)bf, "jpg", writer);
                ((BufferedOutputStream)writer).flush();
                writer.close();
                ret = bo.toByteArray();
            }
            catch (IOException e) {
                if (writer == null) break block4;
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    private ImageIcon adjustImageSize(ImageIcon icon, Dimension dim) {
        if (icon.getIconHeight() > dim.height || icon.getIconWidth() > dim.width) {
            int w;
            int h;
            float wRatio;
            Image img = icon.getImage();
            float hRatio = (float)icon.getIconHeight() / (float)dim.height;
            if (hRatio > (wRatio = (float)icon.getIconWidth() / (float)dim.width)) {
                h = dim.height;
                w = (int)((float)icon.getIconWidth() / hRatio);
            } else {
                w = dim.width;
                h = (int)((float)icon.getIconHeight() / wRatio);
            }
            img = img.getScaledInstance(w, h, 4);
            return new ImageIcon(img);
        }
        return icon;
    }

    private void sendClaim(DocumentModel sendModel, boolean admitFlag) {
        ClaimHelper helper = new ClaimHelper(sendModel, admitFlag);
        Set<ModuleModel> modules = sendModel.getModules();
        for (ModuleModel module : modules) {
            IInfoModel infoModel = module.getModel();
            if (!(infoModel instanceof ClaimBundle)) continue;
            helper.addClaimBundle((ClaimBundle)infoModel);
        }
        MessageBuilder mb = new MessageBuilder();
        String claimMessage = mb.build((Object)helper);
        ClaimMessageEvent claim = new ClaimMessageEvent(this, sendModel.getKarte().getPatient(), claimMessage);
        claim.setTitle(sendModel.getDocInfo().getTitle());
        claim.setConfirmDate(helper.getConfirmDate());
        if (this.claimListener != null) {
            this.claimListener.claimMessageEvent(claim);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendMml(DocumentModel sendModel) {
        IChart chart = this.getParentContext();
        MMLHelper mb = new MMLHelper(sendModel, chart.getPatient().getPatientId());
        try {
            VelocityContext context = GlobalConstants.getVelocityContext();
            context.put("mmlHelper", (Object)mb);
            String templateFile = "mml2.3Helper.vm";
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            InputStream instream = GlobalConstants.getTemplateAsStream(templateFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream, "SHIFT_JIS"));
            Velocity.evaluate((Context)context, (Writer)bw, (String)"mml", (Reader)reader);
            bw.flush();
            bw.close();
            reader.close();
            String mml = sw.toString();
            if (this.sendMml && this.mmlListener != null) {
                MmlMessageEvent mevt = new MmlMessageEvent(this);
                mevt.setGroupId(mb.getDocId());
                mevt.setMmlInstance(mml);
                if (mb.getSchema() != null) {
                    mevt.setSchema(mb.getSchema());
                }
                this.mmlListener.mmlMessageEvent(mevt);
            }
            if (!GlobalVariables.getJoinAreaNetwork()) return;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    private boolean isReadOnly() {
        return this.getParentContext().isReadOnly();
    }

    private void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    private void enabledAction(String name, boolean enabled) {
        this.getParentContext().getChartMediator().enabledAction(name, enabled);
    }

    protected void warning(String title, String message) {
        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }

    public void setParent(IChart parent) {
        this.parent = parent;
    }

    protected final class StateMgr {
        private EditorState noDirtyState;
        private EditorState dirtyState;
        private EditorState savedState;
        private EditorState currentState;

        public StateMgr() {
            this.noDirtyState = new NoDirtyState();
            this.dirtyState = new DirtyState();
            this.savedState = new SavedState();
            this.currentState = this.noDirtyState;
        }

        private boolean isDirty() {
            return this.currentState.isDirty();
        }

        private void setDirty(boolean dirty) {
            this.currentState = dirty ? this.dirtyState : this.noDirtyState;
            this.currentState.controlMenu();
        }

        private void beSaved() {
            this.currentState = this.savedState;
            this.currentState.controlMenu();
        }

        private void controlMenu() {
            this.currentState.controlMenu();
        }
    }

    protected final class SavedState
    implements EditorState {
        @Override
        public void controlMenu() {
            KarteEditor.this.enabledAction("save", false);
            KarteEditor.this.enabledAction("print", true);
            KarteEditor.this.enabledAction("direction", true);
            KarteEditor.this.enabledAction("cut", false);
            KarteEditor.this.enabledAction("copy", false);
            KarteEditor.this.enabledAction("paste", false);
            KarteEditor.this.enabledAction("undo", false);
            KarteEditor.this.enabledAction("redo", false);
            KarteEditor.this.enabledAction("insertText", false);
            KarteEditor.this.enabledAction("insertSchema", false);
            KarteEditor.this.enabledAction("insertStamp", false);
            KarteEditor.this.enabledAction("selectInsurance", false);
            KarteEditor.this.enabledAction("addUser", GlobalVariables.isAdmin());
        }

        @Override
        public boolean isDirty() {
            return false;
        }
    }

    protected final class DirtyState
    implements EditorState {
        @Override
        public void controlMenu() {
            KarteEditor.this.enabledAction("save", true);
            KarteEditor.this.enabledAction("print", true);
            KarteEditor.this.enabledAction("direction", true);
            KarteEditor.this.enabledAction("selectInsurance", !KarteEditor.this.modify);
            KarteEditor.this.enabledAction("addUser", GlobalVariables.isAdmin());
        }

        @Override
        public boolean isDirty() {
            return true;
        }
    }

    protected final class NoDirtyState
    implements EditorState {
        @Override
        public void controlMenu() {
            KarteEditor.this.enabledAction("save", false);
            KarteEditor.this.enabledAction("print", false);
            KarteEditor.this.enabledAction("direction", false);
            KarteEditor.this.enabledAction("cut", false);
            KarteEditor.this.enabledAction("copy", false);
            KarteEditor.this.enabledAction("paste", false);
            KarteEditor.this.enabledAction("undo", false);
            KarteEditor.this.enabledAction("redo", false);
            KarteEditor.this.enabledAction("insertText", false);
            KarteEditor.this.enabledAction("insertSchema", false);
            KarteEditor.this.enabledAction("insertStamp", false);
            KarteEditor.this.enabledAction("selectInsurance", !KarteEditor.this.modify);
            KarteEditor.this.enabledAction("addUser", GlobalVariables.isAdmin());
        }

        @Override
        public boolean isDirty() {
            return false;
        }
    }

    protected static interface EditorState {
        public void controlMenu();

        public boolean isDirty();
    }
}

