/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.List;
import javax.swing.TransferHandler;
import open.dolphin.client.ASpStampTreeBuilder;
import open.dolphin.client.AbstractStampBox;
import open.dolphin.client.AbstractStampTreeBuilder;
import open.dolphin.client.AspStampTreeTransferHandler;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeDirector;
import open.dolphin.client.editor.stamp.StampTreePanel;
import open.dolphin.infomodel.IStampTreeModel;
import open.dolphin.log.LogWriter;

public class AspStampBox
extends AbstractStampBox {
    public AspStampBox(StampBoxFrame plugin, IStampTreeModel model) {
        super(plugin, model);
    }

    @Override
    public void buildStampBox(String stampXml) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(stampXml));
            ASpStampTreeBuilder builder = new ASpStampTreeBuilder();
            StampTreeDirector director = new StampTreeDirector((AbstractStampTreeBuilder)builder);
            List aspTrees = director.build(reader);
            reader.close();
            AspStampTreeTransferHandler transferHandler = new AspStampTreeTransferHandler();
            for (StampTree stampTree : aspTrees) {
                stampTree.setTransferHandler((TransferHandler)transferHandler);
                stampTree.setAsp(true);
                stampTree.setStampBox(this.getContext());
                StampTreePanel treePanel = new StampTreePanel(stampTree);
                String treeName = stampTree.getTreeName();
                if ((stampTree.getEntity() + "").equals("bacteriaOrder")) continue;
                this.addTab(treeName, (Component)treePanel);
            }
        }
        catch (Exception e) {
            LogWriter.error(((Object)((Object)this)).getClass(), e);
        }
    }

    @Override
    protected void buildStampBox() {
        this.buildStampBox(this.getStampTreeModel().getTreeXml());
    }
}

