/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.DateTimeContent;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

class DateTimeContentImpl
extends NamedContentImpl
implements DateTimeContent {
    private long time;

    DateTimeContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, long time) {
        super(owner, obsDateTime, template, DateTimeContentImpl.checkNotNull(name));
        this.time = time;
    }

    DateTimeContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, Date dateTime) {
        this(owner, obsDateTime, template, name, dateTime.getTime());
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        return new DateTimeContentImpl(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.time);
    }

    public final void setName(Code newName) {
        this.name = DateTimeContentImpl.checkNotNull(newName);
    }

    public String toString() {
        return this.prompt().append('(').append(this.getDateTime()).append(')').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.DATETIME;
    }

    public final Date getDateTime() {
        return new Date(this.time);
    }

    public final void setDateTime(Date dateTime) {
        this.time = dateTime.getTime();
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        ds.putDT(4235552, this.getDateTime());
    }
}

