/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.server;

import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.server.DcmHandler;

class DcmHandlerImpl
implements DcmHandler {
    private static final AssociationFactory fact = AssociationFactory.getInstance();
    private final LinkedList listeners = new LinkedList();
    private AcceptorPolicy policy;
    private DcmServiceRegistry services;
    private int rqTimeout = 5000;
    private int dimseTimeout = 0;
    private int soCloseDelay = 500;
    private boolean packPDVs = false;

    public DcmHandlerImpl(AcceptorPolicy policy, DcmServiceRegistry services) {
        this.setAcceptorPolicy(policy);
        this.setDcmServiceRegistry(services);
    }

    public final void setAcceptorPolicy(AcceptorPolicy policy) {
        if (policy == null) {
            throw new NullPointerException();
        }
        this.policy = policy;
    }

    public final AcceptorPolicy getAcceptorPolicy() {
        return this.policy;
    }

    public final void setDcmServiceRegistry(DcmServiceRegistry services) {
        if (services == null) {
            throw new NullPointerException();
        }
        this.services = services;
    }

    public final DcmServiceRegistry getDcmServiceRegistry() {
        return this.services;
    }

    public void setRqTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout: " + timeout);
        }
        this.rqTimeout = timeout;
    }

    public int getRqTimeout() {
        return this.rqTimeout;
    }

    public int getDimseTimeout() {
        return this.dimseTimeout;
    }

    public void setDimseTimeout(int dimseTimeout) {
        if (dimseTimeout < 0) {
            throw new IllegalArgumentException("timeout: " + dimseTimeout);
        }
        this.dimseTimeout = dimseTimeout;
    }

    public int getSoCloseDelay() {
        return this.soCloseDelay;
    }

    public void setSoCloseDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("delay: " + delay);
        }
        this.soCloseDelay = delay;
    }

    public boolean isPackPDVs() {
        return this.packPDVs;
    }

    public void setPackPDVs(boolean packPDVs) {
        this.packPDVs = packPDVs;
    }

    public void handle(Socket s) throws IOException {
        Association assoc = fact.newAcceptor(s);
        assoc.setRqTimeout(this.rqTimeout);
        assoc.setDimseTimeout(this.dimseTimeout);
        assoc.setSoCloseDelay(this.soCloseDelay);
        assoc.setPackPDVs(this.packPDVs);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            assoc.addAssociationListener((AssociationListener)it.next());
        }
        if (assoc.accept(this.policy) instanceof AAssociateAC) {
            fact.newActiveAssociation(assoc, this.services).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAssociationListener(AssociationListener l) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssociationListener(AssociationListener l) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(l);
        }
    }

    public boolean isSockedClosedByHandler() {
        return true;
    }
}

