/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.VOIColorModel;
import java.awt.color.ColorSpace;

public final class VOIDefaultColorModel
extends VOIColorModel {
    private final float cs_min;
    private final float cs_max;
    private final double slope;
    private final double intercept;
    final int sample_min;
    final int sample_max;

    public VOIDefaultColorModel(int n, int n2, ColorSpace colorSpace) {
        super(n, n2, n2, colorSpace);
        this.cs_min = colorSpace.getMinValue(0);
        this.cs_max = colorSpace.getMaxValue(0);
        switch (n) {
            case 0: 
            case 1: {
                this.sample_min = 0;
                this.sample_max = (1 << n2) - 1;
                break;
            }
            default: {
                this.sample_max = (1 << n2 - 1) - 1;
                this.sample_min = ~this.sample_max;
            }
        }
        this.slope = (double)(this.cs_max - this.cs_min) / (double)(this.sample_max - this.sample_min);
        this.intercept = (double)this.cs_min - (double)this.sample_min * this.slope;
    }

    int getComp(int n) {
        switch (this.transferType) {
            case 2: {
                return n + (this.unnorm_max + 1) / 2;
            }
            case 3: {
                return (int)((long)n + (this.unnorm_max_long + 1L) / 2L);
            }
        }
        return n;
    }

    int get255(int n) {
        switch (this.transferType) {
            case 2: {
                return n + (this.unnorm_max + 1) / 2 >> this.pixel_bits - 8;
            }
            case 3: {
                return (int)((long)n + (this.unnorm_max_long + 1L) / 2L >> this.pixel_bits - 8);
            }
            case 1: {
                return n >> this.pixel_bits - 8;
            }
        }
        return n;
    }

    float getNorm(int n) {
        float f = (float)((double)n * this.slope + this.intercept);
        return f < this.cs_min ? this.cs_min : (f > this.cs_max ? this.cs_max : f);
    }

    int getDataElement(float f) {
        double d = ((double)f - this.intercept) / this.slope;
        int n = (int)(d > 0.0 ? d + 0.5 : d - 0.5);
        return n > this.sample_max ? this.sample_max : (n < this.sample_min ? this.sample_min : n);
    }
}

