/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DicomColorSpace;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;

abstract class VOIColorModel
extends ColorModel {
    private final int outbits;
    final int unnorm_max;
    final long unnorm_max_long;
    private final boolean isMono1;

    VOIColorModel(int n, int n2, int n3, ColorSpace colorSpace) {
        super(n2, new int[]{n3}, colorSpace, false, false, 1, n);
        this.outbits = n3;
        this.unnorm_max_long = (1 << n3) - 1;
        this.unnorm_max = (int)this.unnorm_max_long;
        this.isMono1 = colorSpace instanceof DicomColorSpace.Monochrome1;
    }

    public final int getAlpha(int n) {
        return 255;
    }

    public final int getAlpha(Object object) {
        return 255;
    }

    public final int getBlue(int n) {
        return this.isMono1 ? 255 - this.get255(n) : this.get255(n);
    }

    public final int getGreen(int n) {
        return this.isMono1 ? 255 - this.get255(n) : this.get255(n);
    }

    public final int getRed(int n) {
        return this.isMono1 ? 255 - this.get255(n) : this.get255(n);
    }

    public final int getBlue(Object object) {
        int n;
        switch (this.transferType) {
            case 0: {
                n = this.get255(((byte[])object)[0] & 0xFF);
                break;
            }
            case 2: {
                n = this.get255(((short[])object)[0]);
                break;
            }
            case 1: {
                n = this.get255(((short[])object)[0] & 0xFFFF);
                break;
            }
            case 3: {
                n = this.get255(((int[])object)[0]);
                break;
            }
            default: {
                n = this.get255(((float[])object)[0]);
            }
        }
        return this.isMono1 ? 255 - n : n;
    }

    public final int getGreen(Object object) {
        int n;
        switch (this.transferType) {
            case 0: {
                n = this.get255(((byte[])object)[0] & 0xFF);
                break;
            }
            case 2: {
                n = this.get255(((short[])object)[0]);
                break;
            }
            case 1: {
                n = this.get255(((short[])object)[0] & 0xFFFF);
                break;
            }
            case 3: {
                n = this.get255(((int[])object)[0]);
                break;
            }
            default: {
                n = this.get255(((float[])object)[0]);
            }
        }
        return this.isMono1 ? 255 - n : n;
    }

    public final int getRed(Object object) {
        int n;
        switch (this.transferType) {
            case 0: {
                n = this.get255(((byte[])object)[0] & 0xFF);
                break;
            }
            case 2: {
                n = this.get255(((short[])object)[0]);
                break;
            }
            case 1: {
                n = this.get255(((short[])object)[0] & 0xFFFF);
                break;
            }
            case 3: {
                n = this.get255(((int[])object)[0]);
                break;
            }
            default: {
                n = this.get255(((float[])object)[0]);
            }
        }
        return this.isMono1 ? 255 - n : n;
    }

    int getComp(int n) {
        throw new IllegalArgumentException();
    }

    int getComp(float f) {
        throw new IllegalArgumentException();
    }

    int get255(int n) {
        throw new IllegalArgumentException();
    }

    int get255(float f) {
        throw new IllegalArgumentException();
    }

    float getNorm(int n) {
        throw new IllegalArgumentException();
    }

    float getNorm(float f) {
        throw new IllegalArgumentException();
    }

    int getDataElement(float f) {
        throw new IllegalArgumentException();
    }

    float getDataElementFloat(float f) {
        throw new IllegalArgumentException();
    }

    public final int[] getComponents(int n, int[] nArray, int n2) {
        if (nArray == null) {
            nArray = new int[n2 + 1];
        }
        nArray[n2] = this.getComp(n);
        return nArray;
    }

    public final int[] getComponents(Object object, int[] nArray, int n) {
        if (nArray == null) {
            nArray = new int[n + 1];
        }
        switch (this.transferType) {
            case 0: {
                nArray[n] = this.getComp(((byte[])object)[0] & 0xFF);
                break;
            }
            case 2: {
                nArray[n] = this.getComp(((short[])object)[0]);
                break;
            }
            case 1: {
                nArray[n] = this.getComp(((short[])object)[0] & 0xFFFF);
                break;
            }
            case 3: {
                nArray[n] = this.getComp(((int[])object)[0]);
                break;
            }
            case 4: {
                nArray[n] = this.getComp(((float[])object)[0]);
            }
        }
        return nArray;
    }

    public final float[] getNormalizedComponents(int[] nArray, int n, float[] fArray, int n2) {
        if (fArray == null) {
            fArray = new float[n2 + 1];
        }
        fArray[n2] = this.getNorm(nArray[n]);
        return fArray;
    }

    public final float[] getNormalizedComponents(Object object, float[] fArray, int n) {
        if (fArray == null) {
            fArray = new float[n + 1];
        }
        switch (this.transferType) {
            case 0: {
                fArray[n] = this.getNorm(((byte[])object)[0] & 0xFF);
                break;
            }
            case 2: {
                fArray[n] = this.getNorm(((short[])object)[0]);
                break;
            }
            case 1: {
                fArray[n] = this.getNorm(((short[])object)[0] & 0xFFFF);
                break;
            }
            case 3: {
                fArray[n] = this.getNorm(((int[])object)[0]);
                break;
            }
            case 4: {
                fArray[n] = this.getNorm(((float[])object)[0]);
            }
        }
        return fArray;
    }

    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof ComponentSampleModel && sampleModel.getNumBands() == 1 && sampleModel.getDataType() == this.transferType;
    }

    public int[] getUnnormalizedComponents(float[] fArray, int n, int[] nArray, int n2) {
        long l;
        if (nArray == null) {
            nArray = new int[n2 + 1];
        }
        nArray[0] = (l = (long)((double)fArray[n] * ((double)this.unnorm_max_long + 0.5))) > this.unnorm_max_long ? this.unnorm_max : (int)l;
        return nArray;
    }

    public int getDataElement(float[] fArray, int n) {
        return this.getDataElement(fArray[n]);
    }

    public int getDataElement(int[] nArray, int n) {
        return this.getDataElement((float)nArray[n] / (float)this.unnorm_max_long);
    }

    public Object getDataElements(float[] fArray, int n, Object object) {
        switch (this.transferType) {
            case 0: {
                if (object == null) {
                    object = new byte[1];
                }
                ((byte[])object)[0] = (byte)this.getDataElement(fArray[n]);
                break;
            }
            case 1: 
            case 2: {
                if (object == null) {
                    object = new short[1];
                }
                ((short[])object)[0] = (short)this.getDataElement(fArray[n]);
                break;
            }
            case 3: {
                if (object == null) {
                    object = new int[1];
                }
                ((int[])object)[0] = this.getDataElement(fArray[n]);
                break;
            }
            case 4: {
                if (object == null) {
                    object = new float[1];
                }
                ((float[])object)[0] = this.getDataElementFloat(fArray[n]);
            }
        }
        return object;
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        switch (this.transferType) {
            case 0: {
                if (object == null) {
                    object = new byte[1];
                }
                ((byte[])object)[0] = (byte)this.getDataElement((float)nArray[n] / (float)this.unnorm_max_long);
                break;
            }
            case 1: 
            case 2: {
                if (object == null) {
                    object = new short[1];
                }
                ((short[])object)[0] = (short)this.getDataElement((float)nArray[n] / (float)this.unnorm_max_long);
                break;
            }
            case 3: {
                if (object == null) {
                    object = new int[1];
                }
                ((int[])object)[0] = this.getDataElement((float)nArray[n] / (float)this.unnorm_max_long);
                break;
            }
            case 4: {
                if (object == null) {
                    object = new float[1];
                }
                ((float[])object)[0] = this.getDataElementFloat((float)nArray[n] / (float)this.unnorm_max_long);
            }
        }
        return object;
    }

    public Object getDataElements(int n, Object object) {
        float f = (float)((n & 0xFF) + (n >> 8 & 0xFF) + (n >> 16 & 0xFF)) / 765.0f;
        switch (this.transferType) {
            case 0: {
                if (object == null) {
                    object = new byte[1];
                }
                ((byte[])object)[0] = (byte)this.getDataElement(f);
                break;
            }
            case 1: 
            case 2: {
                if (object == null) {
                    object = new short[1];
                }
                ((short[])object)[0] = (short)this.getDataElement(f);
                break;
            }
            case 3: {
                if (object == null) {
                    object = new int[1];
                }
                ((int[])object)[0] = this.getDataElement(f);
                break;
            }
            case 4: {
                if (object == null) {
                    object = new float[1];
                }
                ((float[])object)[0] = this.getDataElementFloat(f);
            }
        }
        return object;
    }
}

