/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.Util;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;

final class ShortToUShortRenderedImage
implements RenderedImage {
    private final RenderedImage source;

    ShortToUShortRenderedImage(RenderedImage renderedImage) {
        this.source = renderedImage;
    }

    public Vector getSources() {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.add(this.source);
        return vector;
    }

    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    public String[] getPropertyNames() {
        return this.source.getPropertyNames();
    }

    static ColorModel getCompatibleColorModel(ColorModel colorModel) {
        return new ComponentColorModel(colorModel.getColorSpace(), false, false, 1, 1);
    }

    public ColorModel getColorModel() {
        return ShortToUShortRenderedImage.getCompatibleColorModel(this.source.getColorModel());
    }

    public SampleModel getSampleModel() {
        return Util.convertSampleModel(this.source.getSampleModel(), 1);
    }

    public int getWidth() {
        return this.source.getWidth();
    }

    public int getHeight() {
        return this.source.getHeight();
    }

    public int getMinX() {
        return this.source.getMinX();
    }

    public int getMinY() {
        return this.source.getMinY();
    }

    public int getNumXTiles() {
        return this.source.getNumXTiles();
    }

    public int getNumYTiles() {
        return this.source.getNumYTiles();
    }

    public int getMinTileX() {
        return this.source.getMinTileX();
    }

    public int getMinTileY() {
        return this.source.getMinTileY();
    }

    public int getTileWidth() {
        return this.source.getTileWidth();
    }

    public int getTileHeight() {
        return this.source.getTileHeight();
    }

    public int getTileGridXOffset() {
        return this.source.getTileGridXOffset();
    }

    public int getTileGridYOffset() {
        return this.source.getTileGridYOffset();
    }

    public Raster getTile(int n, int n2) {
        return Util.convertRaster(this.source.getTile(n, n2), 1);
    }

    public Raster getData() {
        return Util.convertRaster(this.source.getData(), 1);
    }

    public Raster getData(Rectangle rectangle) {
        return Util.convertRaster(this.source.getData(rectangle), 1);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        WritableRaster writableRaster2 = writableRaster == null ? null : (WritableRaster)Util.convertRaster(writableRaster, 2);
        writableRaster2 = this.source.copyData(writableRaster2);
        return (WritableRaster)Util.convertRaster(writableRaster2, 1);
    }
}

