/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.AbstractSyntax;
import fr.apteryx.imageio.dicom.Association;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomReader;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.Identifier;
import fr.apteryx.imageio.dicom.PeerAE;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.Tag;
import fr.apteryx.imageio.dicom.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

abstract class QuerySCU {
    final Association association;
    final DicomWarningListener wl;
    final PeerAE peer;
    final Object current_lock = new Object();
    int current_mid;
    String current_uid;

    QuerySCU(PeerAE peerAE, DicomReader dicomReader, AbstractSyntax[] abstractSyntaxArray) {
        this.peer = peerAE;
        this.wl = dicomReader == null ? null : dicomReader.wl;
        this.association = new Association(peerAE, abstractSyntaxArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator find(Identifier identifier) throws IOException {
        String string = Identifier.FIND_UID[identifier.model];
        DataSet dataSet = new DataSet();
        int n = this.association.newMessageID();
        dataSet.add(2, string);
        dataSet.add(256, 32);
        dataSet.add(272, n);
        dataSet.add(1792, 0);
        dataSet.add(2048, 258);
        dataSet.add(0, dataSet.getLength());
        identifier.ds.checkSpecificCharacterSet();
        this.association.sendMessage(string, dataSet, identifier.ds, true, null);
        ArrayList<Identifier> arrayList = this.current_lock;
        synchronized (arrayList) {
            this.current_mid = n;
            this.current_uid = string;
        }
        try {
            arrayList = new ArrayList<Identifier>();
            while (true) {
                ReceivedMessage receivedMessage;
                if ((receivedMessage = this.association.receiveMessage()) == null) {
                    this.association.release();
                    throw new DicomException("ServiceError", "Association closed by remote SCP");
                }
                DataSet dataSet2 = receivedMessage.command;
                int n2 = dataSet2.findInt(2304);
                if (n2 == 0) {
                    Iterator iterator = arrayList.iterator();
                    return iterator;
                }
                if (n2 == 65280) {
                    arrayList.add(new Identifier(identifier.model, receivedMessage.readDataSet(RawValues.NONE, false, null)));
                    continue;
                }
                if (n2 == 65281) {
                    if (this.wl != null) {
                        this.wl.warning("ServiceWarning", "One or more optional keys were not supported for existence and/or matching");
                    }
                    arrayList.add(new Identifier(identifier.model, receivedMessage.readDataSet(RawValues.NONE, false, null)));
                    continue;
                }
                if (n2 == 65024) {
                    throw new DicomException("ServiceError", "Canceled");
                }
                if (n2 == 42752) {
                    String string2 = dataSet2.findString(2306);
                    if (string2 == null) {
                        string2 = "No additional comment";
                    }
                    throw new DicomException("ServiceRefused", "Out of resources (" + string2 + ')');
                }
                if (n2 == 43264) {
                    String string3 = dataSet2.findString(2306);
                    if (string3 == null) {
                        string3 = "No additional comment";
                    }
                    throw new DicomException("ServiceError", "Identifier does not match SOP Class (" + string3 + ", offending elements: " + Tag.tagListToString(dataSet2.find(2305)) + ')');
                }
                if (n2 >> 12 == 12) {
                    String string4 = dataSet2.findString(2306);
                    if (string4 == null) {
                        string4 = "No additional comment";
                    }
                    throw new DicomException("ServiceError", "Unable to process (" + string4 + ", offending elements: " + Tag.tagListToString(dataSet2.find(2305)) + ')');
                }
                Util.genericStatus(dataSet2, this.wl);
            }
        }
        finally {
            Object object = this.current_lock;
            synchronized (object) {
                this.current_mid = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws IOException {
        String string;
        int n;
        DataSet dataSet = new DataSet();
        Object object = this.current_lock;
        synchronized (object) {
            n = this.current_mid;
            string = this.current_uid;
        }
        if (n != 0) {
            dataSet.add(256, 4095);
            dataSet.add(288, n);
            dataSet.add(2048, 257);
            dataSet.add(0, dataSet.getLength());
            this.association.sendMessage(string, dataSet);
        }
    }
}

