/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.AbstractSyntax;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomReader;
import fr.apteryx.imageio.dicom.Identifier;
import fr.apteryx.imageio.dicom.Modality;
import fr.apteryx.imageio.dicom.PeerAE;
import fr.apteryx.imageio.dicom.QuerySCU;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.ReceivedObject;
import fr.apteryx.imageio.dicom.Tag;
import fr.apteryx.imageio.dicom.TransferSyntax;
import fr.apteryx.imageio.dicom.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class QueryRetrieveSCU
extends QuerySCU {
    private RawValues rv = RawValues.NONE;

    public QueryRetrieveSCU(PeerAE peerAE) {
        this(peerAE, null);
    }

    public void setRawValues(RawValues rawValues) {
        this.rv = rawValues;
    }

    public void setRawMode(boolean bl) {
        this.rv = bl ? RawValues.ALL : RawValues.NONE;
    }

    public QueryRetrieveSCU(PeerAE peerAE, DicomReader dicomReader) {
        super(peerAE, dicomReader, QueryRetrieveSCU.getAS());
    }

    private static AbstractSyntax[] getAS() {
        AbstractSyntax[] abstractSyntaxArray = new AbstractSyntax[9 + Modality.sop2mod.size()];
        int n = 0;
        for (int i = 0; i <= 2; ++i) {
            abstractSyntaxArray[n] = new AbstractSyntax(n * 2 + 1, Identifier.FIND_UID[i], TransferSyntax.ALWAYS_SUPPORTED_OUTPUT_UIDLIST);
            abstractSyntaxArray[n + 1] = new AbstractSyntax(n * 2 + 3, Identifier.GET_UID[i], TransferSyntax.ALWAYS_SUPPORTED_OUTPUT_UIDLIST);
            abstractSyntaxArray[n + 2] = new AbstractSyntax(n * 2 + 5, Identifier.MOVE_UID[i], TransferSyntax.ALWAYS_SUPPORTED_OUTPUT_UIDLIST);
            n += 3;
        }
        Iterator iterator = Modality.sop2mod.keySet().iterator();
        while (iterator.hasNext()) {
            abstractSyntaxArray[n++] = new AbstractSyntax(n * 2 + 1, (String)iterator.next(), TransferSyntax.getSupportedInputAsUidList(), 2);
        }
        return abstractSyntaxArray;
    }

    public Iterator find(Identifier identifier) throws IOException {
        return super.find(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator get(Identifier identifier) throws IOException {
        Object object;
        String string = Identifier.GET_UID[identifier.model];
        DataSet dataSet = new DataSet();
        int n = this.association.newMessageID();
        dataSet.add(2, string);
        dataSet.add(256, 16);
        dataSet.add(272, n);
        dataSet.add(1792, 0);
        dataSet.add(2048, 258);
        dataSet.add(0, dataSet.getLength());
        identifier.ds.checkSpecificCharacterSet();
        this.association.sendMessage(string, dataSet, identifier.ds, false, null);
        ArrayList<ReceivedObject> arrayList = this.current_lock;
        synchronized (arrayList) {
            this.current_mid = n;
            this.current_uid = string;
        }
        try {
            Object object2;
            arrayList = new ArrayList<ReceivedObject>();
            block16: while (true) {
                if ((object2 = this.association.receiveMessage()) == null) {
                    this.close();
                    throw new DicomException("ServiceError", "Association closed by remote SCP");
                }
                object = ((ReceivedMessage)object2).command;
                int n2 = ((DataSet)object).findInt(256);
                switch (n2) {
                    case 32784: {
                        if (((DataSet)object).findInt(288) != n) {
                            throw new DicomException("ProtocoleViolation", "Get response to a message id not sent");
                        }
                        int n3 = ((DataSet)object).findInt(2304);
                        if (n3 == 0) break block16;
                        if (n3 == 65280) continue block16;
                        if (n3 == 65024) {
                            throw new DicomException("ServiceError", "Canceled");
                        }
                        String string2 = ((DataSet)object).findString(2306);
                        if (string2 == null) {
                            string2 = "No additional comment";
                        }
                        if (n3 == 42753) {
                            throw new DicomException("ServiceRefused", "Out of Resources - Unable to calculate number of matches (" + string2 + ")");
                        }
                        if (n3 == 42754) {
                            throw new DicomException("ServiceError", "Out of Resources - Unable to perform suboperations");
                        }
                        if (n3 == 43264) {
                            throw new DicomException("ServiceError", "Identifier does not match SOP Class (" + string2 + ", offending elements: " + Tag.tagListToString(((DataSet)object).find(2305)) + ")");
                        }
                        if ((n3 & 0xF000) == 49152) {
                            throw new DicomException("ServiceError", "Unable to process (" + string2 + ", offending elements: " + Tag.tagListToString(((DataSet)object).find(2305)) + ")");
                        }
                        if (n3 == 45056) {
                            if (this.wl == null) break block16;
                            this.wl.warning("ServiceWarning", null);
                            break block16;
                        }
                        Util.genericStatus((DataSet)object, this.wl);
                        continue block16;
                    }
                    case 1: {
                        String string2 = ((DataSet)object).findString(2);
                        String string3 = ((DataSet)object).findString(4096);
                        ReceivedObject receivedObject = new ReceivedObject((ReceivedMessage)object2, string2, string3, this.rv, this.association.callingAE, this.association.calledAE, this.association.addr, this.association.port);
                        arrayList.add(receivedObject);
                        DataSet dataSet2 = new DataSet();
                        dataSet2.add(2, string2);
                        dataSet2.add(256, 32769);
                        dataSet2.add(288, ((DataSet)object).findInt(272));
                        dataSet2.add(2048, 257);
                        dataSet2.add(2304, receivedObject.warnings.hasSome() ? 45062 : 0);
                        dataSet2.add(4096, string3);
                        dataSet2.add(0, dataSet2.getLength());
                        this.association.sendMessage(string2, dataSet2);
                        continue block16;
                    }
                    default: {
                        throw new DicomException("ProtocoleViolation", "Unexpected command received: " + n2);
                    }
                }
                break;
            }
            object2 = arrayList.iterator();
            return object2;
        }
        finally {
            object = this.current_lock;
            synchronized (object) {
                this.current_mid = 0;
            }
        }
    }

    public void move(Identifier identifier) throws IOException {
        this.move(identifier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void move(Identifier identifier, String string) throws IOException {
        if (string == null) {
            string = this.peer.callingAE;
        }
        String string2 = Identifier.MOVE_UID[identifier.model];
        DataSet dataSet = new DataSet();
        int n = this.association.newMessageID();
        dataSet.add(2, string2);
        dataSet.add(256, 33);
        dataSet.add(272, n);
        dataSet.add(1792, 0);
        dataSet.add(2048, 258);
        dataSet.add(1536, string);
        dataSet.add(0, dataSet.getLength());
        identifier.ds.checkSpecificCharacterSet();
        this.association.sendMessage(string2, dataSet, identifier.ds, false, null);
        Object object = this.current_lock;
        synchronized (object) {
            this.current_mid = n;
            this.current_uid = string2;
        }
        try {
            object = new ArrayList();
            block15: while (true) {
                ReceivedMessage receivedMessage;
                if ((receivedMessage = this.association.receiveMessage()) == null) {
                    this.close();
                    throw new DicomException("ServiceError", "Association closed by SCP");
                }
                DataSet dataSet2 = receivedMessage.command;
                int n2 = dataSet2.findInt(256);
                switch (n2) {
                    case 32801: {
                        if (dataSet2.findInt(288) != n) {
                            throw new DicomException("ProtocoleViolation", "Move response to a message id not sent");
                        }
                        int n3 = dataSet2.findInt(2304);
                        if (n3 == 0) {
                            return;
                        }
                        if (n3 == 65280) continue block15;
                        if (n3 == 65024) {
                            throw new DicomException("ServiceError", "Canceled");
                        }
                        String string3 = dataSet2.findString(2306);
                        if (string3 == null) {
                            string3 = "No additional comment";
                        }
                        if (n3 == 42753) {
                            throw new DicomException("ServiceRefused", "Out of Resources - Unable to calculate number of matches (" + string3 + ")");
                        }
                        if (n3 == 42754) {
                            throw new DicomException("ServiceError", "Out of Resources - Unable to perform suboperations");
                        }
                        if (n3 == 43009) {
                            throw new DicomException("ServiceError", "Move Destination unknown (" + string3 + ")");
                        }
                        if (n3 == 43264) {
                            throw new DicomException("ServiceError", "Identifier does not match SOP Class (" + string3 + ", offending elements: " + Tag.tagListToString(dataSet2.find(2305)) + ")");
                        }
                        if ((n3 & 0xF000) == 49152) {
                            throw new DicomException("ServiceError", "Unable to process (" + string3 + ", offending elements: " + Tag.tagListToString(dataSet2.find(2305)) + ")");
                        }
                        if (n3 == 45056) {
                            if (this.wl == null) return;
                            this.wl.warning("ServiceWarning", null);
                            return;
                        }
                        Util.genericStatus(dataSet2, this.wl);
                        continue block15;
                    }
                    default: {
                        throw new DicomException("ProtocoleViolation", "Unexpected command received: " + n2);
                    }
                }
                break;
            }
        }
        finally {
            object = this.current_lock;
            synchronized (object) {
                this.current_mid = 0;
            }
        }
    }

    public boolean getSupportedBySCP(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Unknown Query/Retrieve model");
        }
        return this.association.supportsSyntax(Identifier.GET_UID[n]);
    }

    public boolean moveSupportedBySCP(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Unknown Query/Retrieve model");
        }
        return this.association.supportsSyntax(Identifier.MOVE_UID[n]);
    }

    public void close() throws IOException {
        this.association.release();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void debug(String string) {
        System.err.println(new Date() + " QueryRetrieveSCU: " + string);
    }
}

