/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.Association;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomObject;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.DicomWriter;
import fr.apteryx.imageio.dicom.Identifier;
import fr.apteryx.imageio.dicom.Modality;
import fr.apteryx.imageio.dicom.PeerAE;
import fr.apteryx.imageio.dicom.Plugin;
import fr.apteryx.imageio.dicom.QueryRetrieveSCPListener;
import fr.apteryx.imageio.dicom.QuerySCP;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.SecureTransport;
import fr.apteryx.imageio.dicom.StorageSCU;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import java.util.Vector;

public class QueryRetrieveSCP
extends QuerySCP {
    private Object storeRspLock = new Object();
    private static final int[] types = new int[]{32, 4095, 16, 33, 32769};
    private static final Set SUPPORTED_SYNTAXES_AS_SCU = Modality.sop2mod.keySet();

    public QueryRetrieveSCP(QueryRetrieveSCPListener queryRetrieveSCPListener) throws DicomException {
        this(queryRetrieveSCPListener, 104, null, null);
    }

    public QueryRetrieveSCP(QueryRetrieveSCPListener queryRetrieveSCPListener, SecureTransport secureTransport) throws DicomException {
        this(queryRetrieveSCPListener, 2762, null, secureTransport);
    }

    public QueryRetrieveSCP(QueryRetrieveSCPListener queryRetrieveSCPListener, int n) throws DicomException {
        this(queryRetrieveSCPListener, n, null, null);
    }

    public QueryRetrieveSCP(QueryRetrieveSCPListener queryRetrieveSCPListener, int n, SecureTransport secureTransport) throws DicomException {
        this(queryRetrieveSCPListener, n, null, secureTransport);
    }

    public QueryRetrieveSCP(QueryRetrieveSCPListener queryRetrieveSCPListener, int n, InetAddress inetAddress, SecureTransport secureTransport) throws DicomException {
        super(queryRetrieveSCPListener, n, inetAddress, secureTransport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean messageReceived(final Association association, ReceivedMessage receivedMessage) throws IOException {
        Object object = this.isFindOrCancel(association, receivedMessage);
        if (object instanceof QuerySCP.FindRq) {
            QuerySCP.FindRq findRq = (QuerySCP.FindRq)object;
            ((QueryRetrieveSCPListener)this.listener).queryReceived(new Operation(association, findRq.id, findRq.mid, null));
            return true;
        }
        if (object != null) {
            return true;
        }
        DataSet dataSet = receivedMessage.command;
        int n = dataSet.findInt(256);
        String string = dataSet.findString(2);
        int n2 = 0;
        switch (n) {
            case 16: {
                if (string != null) {
                    for (int i = 0; i < Identifier.GET_UID.length; ++i) {
                        if (!string.equals(Identifier.GET_UID[i])) continue;
                        n2 = i;
                        break;
                    }
                }
                final Identifier identifier = new Identifier(n2, receivedMessage.readDataSet(RawValues.NONE, false, null));
                final int n3 = dataSet.findInt(272);
                new Thread("QueryRetrieve GET SCP"){

                    public void run() {
                        ((QueryRetrieveSCPListener)QueryRetrieveSCP.this.listener).retrieveReceived(new Operation(association, identifier, n3, null));
                    }
                }.start();
                return true;
            }
            case 33: {
                if (string != null) {
                    for (int i = 0; i < Identifier.MOVE_UID.length; ++i) {
                        if (!string.equals(Identifier.MOVE_UID[i])) continue;
                        n2 = i;
                        break;
                    }
                }
                final Identifier identifier = new Identifier(n2, receivedMessage.readDataSet(RawValues.NONE, false, null));
                final int n4 = dataSet.findInt(272);
                final String string2 = dataSet.findString(1536);
                new Thread("QueryRetrieve MOVE SCP"){

                    public void run() {
                        ((QueryRetrieveSCPListener)QueryRetrieveSCP.this.listener).retrieveReceived(new Operation(association, identifier, n4, string2));
                    }
                }.start();
                return true;
            }
            case 32769: {
                int n5 = dataSet.findInt(288);
                Object object2 = this.storeRspLock;
                synchronized (object2) {
                    association.sent_messages.put(new Integer(n5), receivedMessage);
                    this.storeRspLock.notifyAll();
                }
                return true;
            }
        }
        return false;
    }

    int[] getServicedMessageTypes() {
        return types;
    }

    boolean supportsSyntaxAsSCP(String string) {
        return this.listener.supportsSyntax(string);
    }

    boolean supportsSyntaxAsSCU(String string) {
        return SUPPORTED_SYNTAXES_AS_SCU.contains(string);
    }

    public class Operation
    extends QuerySCP.Operation {
        private final String moveDest;
        private int nbCompleted;
        private int nbFailed;
        private int nbWarning;
        private boolean unknownAE;
        private Vector failedUID;

        private Operation(Association association, Identifier identifier, int n, String string) {
            super(QueryRetrieveSCP.this, association, identifier, n);
            this.unknownAE = false;
            this.failedUID = new Vector();
            this.moveDest = string;
        }

        public void sendRetrieveResponsePending(int n) throws IOException {
            this.sendRetrieveResponse(65280, null, n);
        }

        public void sendRetrieveResponseFinal() throws IOException {
            if (this.unknownAE) {
                DataSet dataSet = new DataSet();
                dataSet.add(524376, this.failedUID.toArray());
                this.sendRetrieveResponse(43009, dataSet, 0);
            } else if (this.nbFailed == 0 && this.nbWarning == 0) {
                this.sendRetrieveResponse(0, null, 0);
            } else {
                DataSet dataSet = new DataSet();
                dataSet.add(524376, this.failedUID.toArray());
                this.sendRetrieveResponse(45056, dataSet, 0);
            }
        }

        public void sendRetrieveResponse(int n, DataSet dataSet, int n2) throws IOException {
            DataSet dataSet2 = new DataSet();
            if (this.moveDest == null) {
                dataSet2.add(2, Identifier.GET_UID[this.model]);
                dataSet2.add(256, 32784);
            } else {
                dataSet2.add(2, Identifier.MOVE_UID[this.model]);
                dataSet2.add(256, 32801);
            }
            dataSet2.add(2304, n);
            dataSet2.add(2048, dataSet == null ? 257 : 258);
            dataSet2.add(288, this.messageId);
            if (n == 65280 || n == 65024 && n2 >= 0) {
                dataSet2.add(4128, n2);
            }
            dataSet2.add(4129, this.nbCompleted);
            dataSet2.add(4130, this.nbFailed);
            dataSet2.add(4131, this.nbWarning);
            dataSet2.add(0, dataSet2.getLength());
            if (dataSet != null) {
                dataSet.checkSpecificCharacterSet();
            }
            this.association.sendMessage(dataSet2.findString(2), dataSet2, dataSet, false, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendObject(DicomObject dicomObject, DicomWriter dicomWriter, DicomWarningListener dicomWarningListener) throws DicomException, IOException {
            try {
                WarningWrapper warningWrapper = new WarningWrapper(dicomWarningListener);
                if (this.moveDest == null) {
                    ReceivedMessage receivedMessage;
                    Integer n = new Integer(StorageSCU.sendRqInAssoc(dicomObject, dicomWriter, this.association, null, 0));
                    Object object = QueryRetrieveSCP.this.storeRspLock;
                    synchronized (object) {
                        try {
                            while ((receivedMessage = (ReceivedMessage)this.association.sent_messages.get(n)) == null) {
                                if (this.association.isClosed()) {
                                    throw new DicomException("ServiceError", "The association no longer exists");
                                }
                                QueryRetrieveSCP.this.storeRspLock.wait(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            throw new DicomException("EnvironmentError", "Interrupted");
                        }
                        this.association.sent_messages.remove(n);
                    }
                    StorageSCU.processRsp(receivedMessage, warningWrapper, n);
                } else {
                    PeerAE peerAE = QueryRetrieveSCP.this.server.getAERegistry().getPeerAE(this.moveDest);
                    if (peerAE == null) {
                        this.unknownAE = true;
                        throw new DicomException("ServiceError", "Unknown AE " + this.moveDest);
                    }
                    StorageSCU storageSCU = new StorageSCU(peerAE);
                    storageSCU.store(dicomObject, dicomWriter, warningWrapper, Plugin.getApplicationTitle(), this.messageId);
                }
                if (warningWrapper.warningOccured) {
                    ++this.nbWarning;
                } else {
                    ++this.nbCompleted;
                }
            }
            catch (DicomException dicomException) {
                ++this.nbFailed;
                this.failedUID.add(dicomObject.sopInstance);
            }
        }

        private class WarningWrapper
        implements DicomWarningListener {
            boolean warningOccured = false;
            final DicomWarningListener wl;

            WarningWrapper(DicomWarningListener dicomWarningListener) {
                this.wl = dicomWarningListener;
            }

            public void warning(String string, String string2) {
                this.warningOccured = true;
                this.wl.warning(string, string2);
            }

            public void warning(int n, String string, String string2) {
                this.warningOccured = true;
                this.wl.warning(n, string, string2);
            }
        }
    }
}

