/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.Tag;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

class FragmentConcatenerImageInputStream
extends ImageInputStreamImpl {
    private final ArrayList fragments = new ArrayList();
    private final ImageInputStream source;
    private int current_fragment;
    private long current_fragment_end = 0L;
    private final byte[] one_byte_buf = new byte[1];

    FragmentConcatenerImageInputStream(ImageInputStream imageInputStream) {
        this.source = imageInputStream;
    }

    private boolean addFragment() throws IOException {
        Fragment fragment = new Fragment();
        do {
            int n;
            if ((n = Tag.create(this.source.readUnsignedShort(), this.source.readUnsignedShort())) == -73507) {
                this.current_fragment = -1;
                return true;
            }
            if (n != -73728) {
                throw new DicomException("ProtocoleViolation", "Item expected");
            }
            fragment.length = (long)this.source.readInt() & 0xFFFFFFFFL;
        } while (fragment.length == 0L);
        fragment.source_offset = this.source.getStreamPosition();
        fragment.this_offset = this.streamPos;
        this.current_fragment = this.fragments.size();
        this.fragments.add(fragment);
        this.current_fragment_end = this.streamPos + fragment.length;
        return false;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.current_fragment == -1) {
            return -1;
        }
        if (this.streamPos == this.current_fragment_end) {
            if (this.current_fragment < this.fragments.size() - 1) {
                ++this.current_fragment;
                Fragment fragment = (Fragment)this.fragments.get(this.current_fragment);
                this.source.seek(fragment.source_offset);
                this.current_fragment_end = this.streamPos + fragment.length;
            } else if (this.addFragment()) {
                return -1;
            }
        }
        if (this.streamPos + (long)n2 > this.current_fragment_end) {
            n2 = (int)(this.current_fragment_end - this.streamPos);
        }
        this.source.readFully(byArray, n, n2);
        this.streamPos += (long)n2;
        return n2;
    }

    public int read() throws IOException {
        int n = this.read(this.one_byte_buf, 0, 1);
        return n < 0 ? n : this.one_byte_buf[0] & 0xFF;
    }

    public void seek(long l) throws IOException {
        Fragment fragment;
        if (l < 0L) {
            throw new IndexOutOfBoundsException("negative seek position");
        }
        if (this.current_fragment_end == 0L && this.addFragment()) {
            this.streamPos = l;
            this.current_fragment = -1;
            return;
        }
        for (int i = 0; i < this.fragments.size(); ++i) {
            Fragment fragment2 = (Fragment)this.fragments.get(i);
            if (l < fragment2.this_offset || l >= fragment2.this_offset + fragment2.length) continue;
            this.source.seek(fragment2.source_offset + (l - fragment2.this_offset));
            this.streamPos = l;
            this.current_fragment = i;
            this.current_fragment_end = fragment2.this_offset + fragment2.length;
            return;
        }
        do {
            fragment = (Fragment)this.fragments.get(this.fragments.size() - 1);
            this.source.seek(fragment.source_offset + fragment.length);
            this.streamPos = fragment.this_offset + fragment.length;
            if (!this.addFragment()) continue;
            this.current_fragment = -1;
            return;
        } while (l >= this.current_fragment_end);
        this.source.seek(fragment.source_offset + (l - fragment.this_offset));
        this.streamPos = l;
    }

    private final class Fragment {
        long this_offset;
        long source_offset;
        long length;

        private Fragment() {
        }
    }
}

