/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DicomReader;
import fr.apteryx.imageio.dicom.ReceivedObject;
import fr.apteryx.imageio.dicom.StorageSCP;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class DicomReaderSpi
extends ImageReaderSpi {
    private static final byte[] HEADER = "DICM".getBytes();
    private static final int PREAMBLE = 128;

    public DicomReaderSpi() {
        this.vendorName = "Apteryx";
        this.version = "1.10";
        this.names = new String[]{"dicom"};
        this.MIMETypes = new String[]{"application/dicom"};
        this.nativeStreamMetadataFormatClassName = "DicomMetadataFormat";
        this.nativeStreamMetadataFormatName = "fr_apteryx_imageio_dicom_1.0";
        this.pluginClassName = "fr.apteryx.imageio.dicom.DicomReader";
        this.suffixes = new String[]{"dcm"};
        this.supportsStandardStreamMetadataFormat = true;
        this.inputTypes = new Class[]{ImageInputStream.class, StorageSCP.class, ReceivedObject.class};
        this.writerSpiNames = new String[]{"fr.apteryx.imageio.dicom.DicomWriterSpi"};
    }

    public String getDescription(Locale locale) {
        return "DICOM V3.0 reader";
    }

    static boolean readHeader(ImageInputStream imageInputStream) throws IOException {
        if (imageInputStream.skipBytes(128) != 128) {
            return false;
        }
        byte[] byArray = new byte[HEADER.length];
        imageInputStream.readFully(byArray);
        return Arrays.equals(byArray, HEADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object object) throws IOException {
        if (object instanceof StorageSCP || object instanceof ReceivedObject) {
            return true;
        }
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            boolean bl = DicomReaderSpi.readHeader(imageInputStream);
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    public ImageReader createReaderInstance(Object object) {
        return new DicomReader(this);
    }
}

