/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLib;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DataSetReader;
import fr.apteryx.imageio.dicom.DicomColorSpace;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomMetadata;
import fr.apteryx.imageio.dicom.DicomObject;
import fr.apteryx.imageio.dicom.DicomReaderSpi;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.FragmentConcatenerImageInputStream;
import fr.apteryx.imageio.dicom.Operations;
import fr.apteryx.imageio.dicom.PixelData;
import fr.apteryx.imageio.dicom.RLEReader;
import fr.apteryx.imageio.dicom.RawReader;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.ReadRenderedImage;
import fr.apteryx.imageio.dicom.ReceivedObject;
import fr.apteryx.imageio.dicom.StorageSCP;
import fr.apteryx.imageio.dicom.TransferSyntax;
import fr.apteryx.imageio.dicom.Util;
import fr.apteryx.imageio.dicom.VOIDefaultColorModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.font.GlyphVector;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class DicomReader
extends ImageReader {
    private DicomObject obj;
    private ImageInfo info;
    private DataSet meta;
    private boolean metaRead;
    private ImageReader helper;
    final DicomWarningListener wl;
    RawValues rv = RawValues.NONE;
    static /* synthetic */ Class class$fr$apteryx$imageio$dicom$PixelData;
    static /* synthetic */ Class array$Ljava$lang$Number;
    static /* synthetic */ Class array$S;

    DicomReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
        this.wl = new DicomWarningListener(){

            public void warning(String string, String string2) {
                DicomReader.this.processWarningOccurred(DicomException.localize(string) + ": " + string2);
            }

            public void warning(int n, String string, String string2) {
                this.warning(string, string2);
            }
        };
    }

    public void setRawValues(RawValues rawValues) {
        this.rv = rawValues;
    }

    public void setRawMode(boolean bl) {
        this.rv = bl ? RawValues.ALL : RawValues.NONE;
    }

    static DataSet readMeta(ImageInputStream imageInputStream, DicomWarningListener dicomWarningListener) throws IOException {
        imageInputStream.mark();
        if (DicomReaderSpi.readHeader(imageInputStream)) {
            DataSetReader dataSetReader = new DataSetReader(imageInputStream, TransferSyntax.EXPLICIT_LITTLEENDIAN, dicomWarningListener, RawValues.NONE, false);
            return dataSetReader.readGroup();
        }
        imageInputStream.reset();
        return null;
    }

    private void readObj() throws IOException {
        if (this.obj == null) {
            int n;
            Object object;
            if (this.input instanceof ReceivedObject) {
                object = (ReceivedObject)this.input;
                this.obj = ((ReceivedObject)object).obj;
                ((ReceivedObject)object).warnings.dump(this.wl);
            } else if (this.input instanceof ImageInputStream) {
                this.obj = new DicomObject(this.getFileMetaElements(), (ImageInputStream)this.input, this.wl, this.rv);
            } else {
                ReceivedObject receivedObject;
                object = (StorageSCP)this.input;
                ((StorageSCP)object).start();
                try {
                    receivedObject = ((StorageSCP)object).receiveObject();
                }
                catch (InterruptedException interruptedException) {
                    InterruptedIOException interruptedIOException = new InterruptedIOException();
                    interruptedIOException.initCause(interruptedException);
                    throw interruptedIOException;
                }
                receivedObject.warnings.dump(this.wl);
                this.obj = receivedObject.obj;
            }
            if (!(this.obj.ds.findValue(2145386512) instanceof PixelData)) {
                n = 0;
            } else {
                n = this.obj.ds.findInt(0x280008);
                if (n == 0) {
                    n = this.obj.ds.findInt(2621456) > 0 ? 1 : 0;
                }
            }
            if (n > 0) {
                this.info = new ImageInfo(n, this.obj.ds);
            }
        }
    }

    public int getHeight(int n) throws IOException {
        this.readObj();
        return this.info == null ? 0 : this.info.height;
    }

    public int getWidth(int n) throws IOException {
        this.readObj();
        return this.info == null ? 0 : this.info.width;
    }

    public SampleModel getSampleModel(int n) throws IOException {
        this.readObj();
        return this.info == null ? null : this.info.sampleModel;
    }

    public ColorModel getColorModel(int n) throws IOException {
        this.readObj();
        return this.info == null ? null : this.info.colorModel;
    }

    public IIOMetadata getImageMetadata(int n) {
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return this.getDicomMetadata();
    }

    public DicomMetadata getDicomMetadata() throws IOException {
        this.readObj();
        return new DicomMetadata(this.obj);
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.readObj();
        if (this.info == null || n >= this.info.nbFrames) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        arrayList.add(new ImageTypeSpecifier(this.info.colorModel, this.info.sampleModel));
        return arrayList.iterator();
    }

    public Iterator getTransformedImageTypes(int n) throws IOException {
        this.readObj();
        if (this.info == null || n >= this.info.nbFrames) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        DicomObject.ApplyLUTTarget applyLUTTarget = new DicomObject.ApplyLUTTarget(this.info.sampleModel, this.info.colorModel);
        if (!this.obj.applyLUT(applyLUTTarget, n, this.wl)) {
            applyLUTTarget = new DicomObject.ApplyLUTTarget(this.read(n, null));
            this.obj.applyLUT(applyLUTTarget, n, this.wl);
        }
        arrayList.add(new ImageTypeSpecifier(applyLUTTarget.cm, applyLUTTarget.sm));
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) throws IOException {
        this.readObj();
        return this.info == null ? 0 : this.info.nbFrames;
    }

    private DataBufferShort changeUShortToShort(DataBuffer dataBuffer) {
        DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
        return new DataBufferShort(dataBufferUShort.getBankData(), dataBufferUShort.getSize(), dataBufferUShort.getOffsets());
    }

    public DataSet getFileMetaElements() throws IOException {
        if (this.input instanceof ImageInputStream) {
            if (!this.metaRead) {
                this.meta = DicomReader.readMeta((ImageInputStream)this.input, this.wl);
                this.metaRead = true;
            }
            return this.meta;
        }
        throw new IllegalArgumentException("input is not an ImageInputStream");
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.readObj();
        if (this.info == null || n < 0 || n >= this.info.nbFrames) {
            throw new IndexOutOfBoundsException();
        }
        BufferedImage bufferedImage = imageReadParam == null ? new BufferedImage(this.info.colorModel, Raster.createWritableRaster(this.info.sampleModel, null), this.info.colorModel.isAlphaPremultiplied(), null) : DicomReader.getDestination(imageReadParam, this.getImageTypes(n), this.getWidth(n), this.getHeight(n));
        this.info.read(bufferedImage.getRaster(), n);
        return bufferedImage;
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        this.readObj();
        if (this.info == null || n < 0 || n >= this.info.nbFrames) {
            throw new IndexOutOfBoundsException();
        }
        WritableRaster writableRaster = Raster.createWritableRaster(this.info.sampleModel, null);
        this.info.read(writableRaster, n);
        return writableRaster;
    }

    public boolean canReadRaster() {
        return true;
    }

    public RenderedImage readAsRenderedImage(int n, ImageReadParam imageReadParam) {
        return new ReadRenderedImage(this, n);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        this.obj = null;
        this.info = null;
        this.meta = null;
        this.metaRead = false;
        if (this.helper != null) {
            if (!(this.helper instanceof J2KImageReaderCodecLib) && !(this.helper instanceof J2KImageReader)) {
                this.helper.setInput(null);
            }
            this.helper = null;
        }
        if (!(object == null || object instanceof ImageInputStream || object instanceof StorageSCP || object instanceof ReceivedObject)) {
            throw new IllegalArgumentException("input is not an ImageInputStream nor a StorageSCP, nor a ReceivedObject");
        }
        super.setInput(object, bl, bl2);
    }

    public void reset() {
        super.reset();
        if (this.helper != null) {
            this.helper.reset();
        }
    }

    public void dispose() {
        if (this.helper != null) {
            this.helper.dispose();
        }
        this.setInput(null, false, false);
    }

    public void addIIOReadWarningListener(IIOReadWarningListener iIOReadWarningListener) {
        super.addIIOReadWarningListener(iIOReadWarningListener);
        if (this.helper != null) {
            this.helper.addIIOReadWarningListener(iIOReadWarningListener);
        }
    }

    public void addIIOReadProgressListener(IIOReadProgressListener iIOReadProgressListener) {
        super.addIIOReadProgressListener(iIOReadProgressListener);
        if (this.helper != null) {
            this.helper.addIIOReadProgressListener(iIOReadProgressListener);
        }
    }

    public void addIIOReadUpdateListener(IIOReadUpdateListener iIOReadUpdateListener) {
        super.addIIOReadUpdateListener(iIOReadUpdateListener);
        if (this.helper != null) {
            this.helper.addIIOReadUpdateListener(iIOReadUpdateListener);
        }
    }

    private class ImageInfo {
        final int nbFrames;
        final int bitsAllocated;
        int bitsStored;
        final int height;
        final int width;
        final int shift;
        final int pixelRepresentation;
        final PixelData data;
        final int type;
        final ColorModel colorModel;
        final SampleModel sampleModel;
        final long[] offsets;
        final int br_subsampled;
        boolean need_sign_propagation = false;
        int nextIndex;

        private int getType() throws DicomException {
            int n;
            if (this.bitsStored <= 8 && this.pixelRepresentation == 0) {
                n = 0;
            } else if (this.bitsStored <= 16 && this.pixelRepresentation == 0) {
                n = 1;
            } else if (this.bitsStored <= 16 && this.pixelRepresentation == 1) {
                n = 2;
            } else {
                throw new DicomException("Unsupported", "bitsStored=" + this.bitsStored + " and pixelRepresentation=" + this.pixelRepresentation);
            }
            if (this.bitsAllocated != 8 && this.bitsAllocated != 16) {
                throw new DicomException("Unsupported", "bitsAllocated=" + this.bitsAllocated);
            }
            return n;
        }

        ImageInfo(int n, DataSet dataSet) throws IOException {
            int n2;
            Object object;
            this.nbFrames = n;
            this.offsets = new long[n];
            int n3 = dataSet.findInt(0x280002);
            String string = dataSet.findString(2621444);
            int n4 = dataSet.findInt(2621446);
            this.height = dataSet.findInt(2621456);
            this.width = dataSet.findInt(2621457);
            this.bitsAllocated = dataSet.findInt(2621696);
            this.bitsStored = dataSet.findInt(2621697);
            int n5 = dataSet.findInt(2621698);
            this.pixelRepresentation = dataSet.findInt(2621699);
            this.shift = 1 + n5 - this.bitsStored;
            this.data = (PixelData)dataSet.findValue(2145386512, class$fr$apteryx$imageio$dicom$PixelData == null ? (class$fr$apteryx$imageio$dicom$PixelData = DicomReader.class$("fr.apteryx.imageio.dicom.PixelData")) : class$fr$apteryx$imageio$dicom$PixelData);
            if (this.data == null || this.data.stream == null) {
                throw new DicomException("ProtocoleViolation", "No Pixel Data");
            }
            if (this.shift != 0 && this.data.TS.encapsulated) {
                throw new DicomException("Unsupported", "Encapsulated transfer type and highBit != bitsStored-1");
            }
            this.type = this.getType();
            ColorModel colorModel = null;
            if (this.data.TS.encapsulated && this.data.TS != TransferSyntax.RLE_COMPRESSION) {
                DicomReader.this.helper = this.data.TS.getReader();
                if (DicomReader.this.helper == null) {
                    throw new DicomException("EnvironmentError", "Cannot create helper reader");
                }
                if (DicomReader.this.warningListeners != null) {
                    object = DicomReader.this.warningListeners.iterator();
                    while (object.hasNext()) {
                        DicomReader.this.helper.addIIOReadWarningListener((IIOReadWarningListener)object.next());
                    }
                }
                if (DicomReader.this.progressListeners != null) {
                    object = DicomReader.this.progressListeners.iterator();
                    while (object.hasNext()) {
                        DicomReader.this.helper.addIIOReadProgressListener((IIOReadProgressListener)object.next());
                    }
                }
                if (DicomReader.this.updateListeners != null) {
                    object = DicomReader.this.updateListeners.iterator();
                    while (object.hasNext()) {
                        DicomReader.this.helper.addIIOReadUpdateListener((IIOReadUpdateListener)object.next());
                    }
                }
                object = this.data.stream;
                object.seek(this.data.pos);
                n2 = (object.readShort() & 0xFFFF) << 16 | object.readShort() & 0xFFFF;
                if (n2 != -73728) {
                    throw new DicomException("ProtocoleViolation", "Item expected");
                }
                long l = (long)object.readInt() & 0xFFFFFFFFL;
                object.skipBytes(l);
                DicomReader.this.helper.setInput(new FragmentConcatenerImageInputStream((ImageInputStream)object));
                ImageTypeSpecifier imageTypeSpecifier = DicomReader.this.helper.getRawImageType(0);
                if (imageTypeSpecifier == null) {
                    imageTypeSpecifier = DicomReader.this.helper.getImageTypes(0).next();
                }
                SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
                colorModel = imageTypeSpecifier.getColorModel();
                if (colorModel instanceof ComponentColorModel && n3 == 1) {
                    colorModel = null;
                }
                if (sampleModel.getDataType() == 1 && this.type == 2) {
                    if (this.bitsStored < 16) {
                        this.need_sign_propagation = true;
                    }
                    sampleModel = Util.convertSampleModel(sampleModel, this.type);
                    colorModel = null;
                }
                this.sampleModel = sampleModel.getWidth() != DicomReader.this.helper.getWidth(0) || sampleModel.getHeight() != DicomReader.this.helper.getHeight(0) ? sampleModel.createCompatibleSampleModel(DicomReader.this.helper.getWidth(0), DicomReader.this.helper.getHeight(0)) : sampleModel;
            } else if (n4 == 0 || n3 == 1 || this.data.TS == TransferSyntax.RLE_COMPRESSION) {
                object = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    object[n2] = n2;
                }
                this.sampleModel = new PixelInterleavedSampleModel(this.type, this.width, this.height, n3, this.width * n3, (int[])object);
            } else {
                this.sampleModel = new BandedSampleModel(this.type, this.width, this.height, n3);
            }
            this.br_subsampled = string != null ? (string.endsWith("_422") ? 1 : (string.endsWith("_420") ? 2 : 0)) : 0;
            if (this.br_subsampled > 0 && !this.data.TS.encapsulated && (this.bitsAllocated != 8 && this.bitsAllocated != 16 || this.pixelRepresentation != 0 || n4 != 0 || this.shift != 0)) {
                throw new DicomException("ProtocoleViolation", "Pixel format not compatible with chrominance-subsampled photometric interpretation");
            }
            if (this.br_subsampled > 0 && !this.data.TS.encapsulated && this.width % 2 == 1) {
                throw new DicomException("Unsupported", "Odd image width and chrominance-subsampled photometric interpretation");
            }
            if (this.br_subsampled == 2 && this.data.TS == TransferSyntax.RLE_COMPRESSION) {
                throw new DicomException("ProtocoleViolation", "RLE Compression is not compatible with chrominance-subsampled photometric interpretation");
            }
            if (DicomReader.this.helper == null || colorModel == null || "PALETTE COLOR".equals(string)) {
                if ("PALETTE COLOR".equals(string)) {
                    if (this.pixelRepresentation == 1) {
                        DicomReader.this.wl.warning("Unsupported", "Palette with signed pixel values");
                    }
                    colorModel = DicomColorSpace.getIndexColorModel(this.bitsStored, new Number[][]{(Number[])dataSet.findValue(2625793, array$Ljava$lang$Number == null ? (array$Ljava$lang$Number = DicomReader.class$("[Ljava.lang.Number;")) : array$Ljava$lang$Number), (Number[])dataSet.findValue(2625794, array$Ljava$lang$Number == null ? (array$Ljava$lang$Number = DicomReader.class$("[Ljava.lang.Number;")) : array$Ljava$lang$Number), (Number[])dataSet.findValue(2625795, array$Ljava$lang$Number == null ? (array$Ljava$lang$Number = DicomReader.class$("[Ljava.lang.Number;")) : array$Ljava$lang$Number)}, new short[][]{(short[])dataSet.findValue(2626049, array$S == null ? (array$S = DicomReader.class$("[S")) : array$S), (short[])dataSet.findValue(2626050, array$S == null ? (array$S = DicomReader.class$("[S")) : array$S), (short[])dataSet.findValue(2626051, array$S == null ? (array$S = DicomReader.class$("[S")) : array$S)});
                } else {
                    object = new int[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        object[n2] = this.bitsStored;
                    }
                    ColorSpace colorSpace = DicomColorSpace.getInstance(string, n3);
                    colorModel = this.pixelRepresentation == 0 && colorSpace instanceof ICC_ColorSpace || n3 > 1 ? new ComponentColorModel(colorSpace, (int[])object, false, false, 1, this.type) : new VOIDefaultColorModel(this.type, (int)object[0], colorSpace);
                }
            }
            this.colorModel = colorModel;
            if (DicomReader.this.helper != null && !(DicomReader.this.helper instanceof J2KImageReaderCodecLib)) {
                DicomReader.this.helper.setInput(null);
            }
        }

        void read(WritableRaster writableRaster, int n) throws IOException {
            ImageInputStream imageInputStream = this.data.stream;
            if (n >= this.nextIndex) {
                long l;
                int n2;
                if (this.nextIndex == 0) {
                    if (this.data.TS.encapsulated) {
                        imageInputStream.seek(this.data.pos);
                        n2 = (imageInputStream.readShort() & 0xFFFF) << 16 | imageInputStream.readShort() & 0xFFFF;
                        if (n2 != -73728) {
                            throw new DicomException("ProtocoleViolation", "Item expected");
                        }
                        l = (long)imageInputStream.readInt() & 0xFFFFFFFFL;
                        if (l > 0L) {
                            if (l != (long)(4 * this.nbFrames)) {
                                throw new DicomException("ProtocoleViolation", "Incorrect size of basic offset table");
                            }
                            l += imageInputStream.getStreamPosition();
                            for (int i = 0; i < this.nbFrames; ++i) {
                                this.offsets[i] = l + ((long)imageInputStream.readInt() & 0xFFFFFFFFL);
                            }
                            this.nextIndex = this.nbFrames;
                        } else {
                            this.offsets[0] = imageInputStream.getStreamPosition();
                            this.nextIndex = 1;
                        }
                    } else {
                        for (n2 = 0; n2 < this.nbFrames; ++n2) {
                            this.offsets[n2] = this.data.pos + this.data.l / (long)this.nbFrames * (long)n2;
                        }
                        this.nextIndex = this.nbFrames;
                    }
                }
                while (this.nextIndex <= n) {
                    imageInputStream.seek(this.offsets[this.nextIndex - 1]);
                    n2 = (imageInputStream.readShort() & 0xFFFF) << 16 | imageInputStream.readShort() & 0xFFFF;
                    if (n2 != -73728) {
                        throw new DicomException("ProtocoleViolation", "Item expected");
                    }
                    l = (long)imageInputStream.readInt() & 0xFFFFFFFFL;
                    this.offsets[this.nextIndex++] = imageInputStream.getStreamPosition() + l;
                }
            }
            DicomReader.this.processImageStarted(n);
            imageInputStream.seek(this.offsets[n]);
            if (this.data.TS.encapsulated) {
                Object object;
                FragmentConcatenerImageInputStream fragmentConcatenerImageInputStream = new FragmentConcatenerImageInputStream(imageInputStream);
                if (this.data.TS == TransferSyntax.RLE_COMPRESSION) {
                    object = new RLEReader();
                    ((RLEReader)object).readRLEImage(fragmentConcatenerImageInputStream, writableRaster, this.bitsAllocated, this.br_subsampled);
                } else {
                    DicomReader.this.helper.setInput(fragmentConcatenerImageInputStream);
                    object = DicomReader.this.helper.getDefaultReadParam();
                    ((ImageReadParam)object).setDestination(new BufferedImage(this.colorModel, writableRaster, false, null));
                    DicomReader.this.helper.read(0, (ImageReadParam)object);
                    if (!(DicomReader.this.helper instanceof J2KImageReaderCodecLib)) {
                        DicomReader.this.helper.setInput(null);
                    }
                    if (this.need_sign_propagation) {
                        Operations.propagateSign(writableRaster, this.bitsStored);
                    }
                }
            } else {
                RawReader.readRaw(imageInputStream, writableRaster, this.data.TS.bigEndian, this.bitsAllocated, this.bitsStored, this.shift, this.data.VR.equals("OW"), this.pixelRepresentation == 1, this.br_subsampled);
            }
            BufferedImage bufferedImage = new BufferedImage(this.colorModel, writableRaster, false, null);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            String string = new String(new char[]{'D'});
            string = string + 'E';
            string = string + "MO";
            Font font = new Font("SansSerif", 0, Math.min(bufferedImage.getHeight(), bufferedImage.getWidth()) / 3);
            int n3 = graphics2D.getFontMetrics(font).stringWidth(string);
            int n4 = graphics2D.getFontMetrics(font).getAscent();
            GlyphVector glyphVector = font.createGlyphVector(graphics2D.getFontRenderContext(), string);
            int n5 = (bufferedImage.getWidth() - n3) / 2;
            int n6 = bufferedImage.getHeight() - (bufferedImage.getHeight() - n4) / 2;
            Rectangle rectangle = glyphVector.getPixelBounds(graphics2D.getFontRenderContext(), n5, n6);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, rectangle.y - rectangle.height / 10, bufferedImage.getWidth(), rectangle.height + rectangle.height / 5);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawGlyphVector(glyphVector, n5, n6);
            DicomReader.this.processImageComplete();
        }
    }
}

