/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.security.jaas;

import com.funambol.framework.core.Cred;
import com.funambol.framework.tools.Base64;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CredentialHandler
implements CallbackHandler {
    public static final String TYPE_BASIC = "syncml:auth-basic";
    public static final String TYPE_CLEAR = "syncml:auth-clear";
    public static final String SUPPORTED_TYPES = "syncml:auth-basic,syncml:auth-clear";
    private String login = null;
    private char[] password = null;
    protected static final Logger log = Logger.getLogger((String)CredentialHandler.class.getName());

    public CredentialHandler(Cred credential) throws IllegalArgumentException {
        String type = credential.getType();
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("credential: " + credential));
        }
        if (SUPPORTED_TYPES.indexOf(type) < 0) {
            throw new IllegalArgumentException("Authorization type '" + type + "' not supported");
        }
        if (TYPE_BASIC.equals(type)) {
            String s = new String(Base64.decode(credential.getData()));
            int p = s.indexOf(58);
            if (p == -1) {
                this.login = s;
                this.password = null;
            } else {
                this.login = p > 0 ? s.substring(0, p) : "";
                this.password = this.toChars(p == s.length() - 1 ? "" : s.substring(p + 1));
            }
        } else if (TYPE_CLEAR.equals(type)) {
            String s = credential.getData();
            int p = s.indexOf(58);
            if (p == -1) {
                this.login = s;
                this.password = null;
            } else {
                this.login = p > 0 ? s.substring(0, p) : "";
                this.password = this.toChars(p == s.length() - 1 ? "" : s.substring(p + 1));
            }
        }
    }

    public String getLogin() {
        return this.login;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        block5: for (int i = 0; i < callbacks.length; ++i) {
            Callback nc;
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("Handling " + callbacks[i]));
            }
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        if (!log.isEnabledFor((Priority)Level.INFO)) continue block5;
                        log.info((Object)toc.getMessage());
                        break;
                    }
                    case 2: {
                        if (!log.isEnabledFor((Priority)Level.FATAL)) continue block5;
                        log.fatal((Object)toc.getMessage());
                        break;
                    }
                    case 1: {
                        if (!log.isEnabledFor((Priority)Level.WARN)) continue block5;
                        log.warn((Object)toc.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + toc.getMessageType());
                    }
                }
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                nc = (NameCallback)callbacks[i];
                ((NameCallback)nc).setName(this.login);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                nc = (PasswordCallback)callbacks[i];
                ((PasswordCallback)nc).setPassword(this.password);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    private char[] toChars(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return new char[0];
        }
        int l = str.length();
        char[] ret = new char[l];
        str.getChars(0, l, ret, 0);
        return ret;
    }
}

