/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.parser;

import java.io.IOException;
import java.util.List;
import org.kxml.io.ParseException;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.StartTag;

public abstract class AbstractXmlParser {
    protected boolean processNamespaces = true;

    public void ignoreTree() throws IOException {
        this.readTree(null);
    }

    public void readTree(List buf) throws IOException {
        StartTag start = (StartTag)this.read();
        block4: while (true) {
            ParseEvent event = this.peek();
            if (buf != null) {
                buf.add(event);
            }
            switch (event.getType()) {
                case 64: {
                    this.readTree(buf);
                    continue block4;
                }
                case 8: 
                case 16: {
                    this.read();
                    return;
                }
            }
            this.read();
        }
    }

    public int getLineNumber() throws IOException {
        return this.peek().getLineNumber();
    }

    public abstract ParseEvent read() throws IOException;

    public ParseEvent read(int type, String namespace, String name) throws IOException {
        if (this.peek(type, namespace, name)) {
            return this.read();
        }
        throw new ParseException("unexpected: " + this.peek(), null, this.peek().getLineNumber(), -1);
    }

    public boolean peek(int type, String namespace, String name) throws IOException {
        ParseEvent pe = this.peek();
        return !(pe.getType() != type || namespace != null && !namespace.equals(pe.getNamespace()) || name != null && !name.equals(pe.getName()));
    }

    public void skip() throws IOException {
        int type;
        while ((type = this.peek().getType()) == 1 || type == 2 || type == 32 || type == 256) {
            this.read();
        }
    }

    public abstract ParseEvent peek() throws IOException;

    public void setProcessNamespaces(boolean processNamespaces) {
        this.processNamespaces = processNamespaces;
    }

    public String readText() throws IOException {
        StringBuffer buf = new StringBuffer();
        block5: while (true) {
            ParseEvent event = this.peek();
            switch (event.getType()) {
                case 2: 
                case 8: 
                case 64: {
                    throw new RuntimeException("Illegal event: " + event);
                }
                case 128: 
                case 256: {
                    this.read();
                    buf.append(event.getText());
                    continue block5;
                }
                case 16: {
                    return buf.toString();
                }
            }
            this.read();
        }
    }
}

