/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.protocols.PerfHeader;
import org.jgroups.protocols.PerfObserver;
import org.jgroups.stack.Protocol;

public class PERF
extends Protocol {
    boolean details = false;
    Vector members = new Vector();
    Vector protocols = null;
    static final String name = "PERF";

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("details");
        if (str != null) {
            this.details = new Boolean(str);
            props.remove("details");
        }
        if (props.size() > 0) {
            System.err.println("PERF.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        this.protocols = this.stack != null ? this.stack.getProtocols() : null;
        this.setupObservers();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                PerfHeader hdr = this.removePerfHeader(msg);
                if (hdr == null) break;
                hdr.setEndTime();
                hdr.setDone(name, 1);
                if (!Trace.trace) break;
                Trace.info("PERF.up()", hdr.printContents(this.details, this.protocols) + "\n---------------------------------\n");
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        for (int i = 0; i < new_members.size(); ++i) {
                            this.members.addElement(new_members.elementAt(i));
                        }
                    }
                }
                this.passDown(evt);
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                this.initializeMessage(msg);
            }
        }
        this.passDown(evt);
    }

    void setupObservers() {
        Protocol p = null;
        Vector prots = this.protocols;
        PerfObserver po = null;
        if (prots == null) {
            System.err.println("PERF.setupObservers(): protocol stack is null");
            return;
        }
        for (int i = 0; i < prots.size(); ++i) {
            p = (Protocol)prots.elementAt(i);
            String pname = p.getName();
            if (pname == null) continue;
            po = new PerfObserver(pname);
            po.setProtocol(p);
            p.setObserver(po);
        }
    }

    void initializeMessage(Message msg) {
        PerfHeader hdr = new PerfHeader(msg.getSrc(), msg.getDest());
        String pname = null;
        if (this.protocols == null) {
            System.err.println("PERF.initializeMessage(): 'protocols' variable is null");
            return;
        }
        for (int i = 0; i < this.protocols.size(); ++i) {
            Protocol p = (Protocol)this.protocols.elementAt(i);
            pname = p.getName();
            if (pname == null) continue;
            hdr.addEntry(pname);
        }
        hdr.setReceived(name, 2);
        msg.putHeader(name, hdr);
    }

    PerfHeader removePerfHeader(Message m) {
        Header hdr = null;
        if (m == null || (hdr = m.removeHeader(name)) == null) {
            return null;
        }
        return (PerfHeader)hdr;
    }
}

