/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.GetStateEvent;
import org.jgroups.Header;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SetStateEvent;
import org.jgroups.SuspectEvent;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.util.Util;

public class PullPushAdapter
implements Runnable {
    protected Transport transport = null;
    protected MessageListener listener = null;
    protected List membership_listeners = new ArrayList();
    protected Thread receiver_thread = null;
    protected HashMap listeners = new HashMap();
    static final String PULL_HEADER = "PULL_HEADER";

    public PullPushAdapter(Transport transport) {
        this.transport = transport;
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l) {
        this.transport = transport;
        this.setListener(l);
        this.start();
    }

    public PullPushAdapter(Transport transport, MembershipListener ml) {
        this.transport = transport;
        this.addMembershipListener(ml);
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l, MembershipListener ml) {
        this.transport = transport;
        this.setListener(l);
        this.addMembershipListener(ml);
        this.start();
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void start() {
        if (this.receiver_thread == null) {
            this.receiver_thread = new Thread((Runnable)this, "PullPushAdapterThread");
            this.receiver_thread.setDaemon(true);
            this.receiver_thread.start();
        }
    }

    public void stop() {
        Thread tmp = null;
        if (this.receiver_thread != null && this.receiver_thread.isAlive()) {
            tmp = this.receiver_thread;
            this.receiver_thread = null;
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.receiver_thread = null;
    }

    public void send(Serializable identifier, Message msg) throws Exception {
        if (msg == null) {
            Trace.error("PullPushAdapter.send()", "msg is null");
            return;
        }
        if (identifier == null) {
            this.transport.send(msg);
        } else {
            msg.putHeader(PULL_HEADER, new PullHeader(identifier));
            this.transport.send(msg);
        }
    }

    public void send(Message msg) throws Exception {
        this.send(null, msg);
    }

    public void setListener(MessageListener l) {
        this.listener = l;
    }

    public void registerListener(Serializable identifier, MessageListener l) {
        if (l == null || identifier == null) {
            Trace.error("PullPushAdapter.registerListener()", "message listener or identifier is null");
            return;
        }
        if (this.listeners.containsKey(identifier)) {
            Trace.error("PullPushAdapter.registerListener()", "listener with identifier=" + identifier + " already exists, choose a different identifier");
        }
        this.listeners.put(identifier, l);
    }

    public void setMembershipListener(MembershipListener ml) {
        this.addMembershipListener(ml);
    }

    public void addMembershipListener(MembershipListener l) {
        if (l != null && !this.membership_listeners.contains(l)) {
            this.membership_listeners.add(l);
        }
    }

    public void run() {
        while (this.receiver_thread != null) {
            try {
                Object obj = this.transport.receive(0L);
                if (obj == null) continue;
                if (obj instanceof Message) {
                    this.handleMessage((Message)obj);
                    continue;
                }
                if (obj instanceof GetStateEvent) {
                    if (this.listener == null) continue;
                    if (this.transport instanceof Channel) {
                        ((Channel)this.transport).returnState(this.listener.getState());
                        continue;
                    }
                    Trace.error("PullPushAdapter.run()", "underlying transport is not a Channel, but a " + this.transport.getClass().getName() + ": cannot fetch state using returnState()");
                    continue;
                }
                if (obj instanceof SetStateEvent) {
                    if (this.listener == null) continue;
                    try {
                        this.listener.setState(((SetStateEvent)obj).getArg());
                    }
                    catch (ClassCastException cast_ex) {
                        Trace.error("PullPushAdapter.run()", "received SetStateEvent, but argument " + ((SetStateEvent)obj).getArg() + " is not serializable ! Discarding message.");
                    }
                    continue;
                }
                if (obj instanceof View) {
                    this.notifyViewChange((View)obj);
                    continue;
                }
                if (obj instanceof SuspectEvent) {
                    this.notifySuspect((Address)((SuspectEvent)obj).getMember());
                    continue;
                }
                if (!(obj instanceof BlockEvent)) continue;
                this.notifyBlock();
            }
            catch (ChannelNotConnectedException conn) {
                Address local_addr = ((Channel)this.transport).getLocalAddress();
                Trace.warn("PullPushAdapter.run()", "[" + (local_addr == null ? "<null>" : local_addr.toString()) + "] channel not connected, exception is " + conn);
                Util.sleep(1000L);
                break;
            }
            catch (ChannelClosedException closed_ex) {
                Address local_addr = ((Channel)this.transport).getLocalAddress();
                Trace.warn("PullPushAdapter.run()", "[" + (local_addr == null ? "<null>" : local_addr.toString()) + "] channel closed, exception is " + closed_ex);
                Util.sleep(1000L);
                break;
            }
            catch (Throwable throwable) {
            }
        }
    }

    protected void handleMessage(Message msg) {
        Serializable identifier;
        PullHeader hdr = (PullHeader)msg.getHeader(PULL_HEADER);
        if (hdr != null && (identifier = hdr.getIdentifier()) != null) {
            MessageListener l = (MessageListener)this.listeners.get(identifier);
            if (l == null) {
                Trace.error("PullPushAdapter.handleMessage()", "received a messages tagged with identifier=" + identifier + ", but there is no registration for that identifier. Will drop message");
            } else {
                l.receive(msg);
            }
        } else if (this.listener != null) {
            this.listener.receive(msg);
        }
    }

    protected void notifyViewChange(View v) {
        if (v == null) {
            return;
        }
        Iterator it = this.membership_listeners.iterator();
        while (it.hasNext()) {
            MembershipListener l = (MembershipListener)it.next();
            try {
                l.viewAccepted(v);
            }
            catch (Throwable ex) {
                Trace.error("PullPushAdapter.notifyViewChange()", "exception notifying " + l + ": " + ex);
            }
        }
    }

    protected void notifySuspect(Address suspected_mbr) {
        if (suspected_mbr == null) {
            return;
        }
        Iterator it = this.membership_listeners.iterator();
        while (it.hasNext()) {
            MembershipListener l = (MembershipListener)it.next();
            try {
                l.suspect(suspected_mbr);
            }
            catch (Throwable ex) {
                Trace.error("PullPushAdapter.notifySuspect()", "exception notifying " + l + ": " + ex);
            }
        }
    }

    protected void notifyBlock() {
        Iterator it = this.membership_listeners.iterator();
        while (it.hasNext()) {
            MembershipListener l = (MembershipListener)it.next();
            try {
                l.block();
            }
            catch (Throwable ex) {
                Trace.error("PullPushAdapter.block()", "exception notifying " + l + ": " + ex);
            }
        }
    }

    public static final class PullHeader
    extends Header {
        Serializable identifier = null;

        public PullHeader() {
        }

        public PullHeader(Serializable identifier) {
            this.identifier = identifier;
        }

        public Serializable getIdentifier() {
            return this.identifier;
        }

        public long size() {
            return 128L;
        }

        public String toString() {
            return "PullHeader";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.identifier);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.identifier = (Serializable)in.readObject();
        }
    }
}

