/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.kxml.Attribute;
import org.kxml.io.ParseException;
import org.kxml.parser.AbstractXmlParser;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.StartTag;
import org.kxml.parser.Tag;

public class XmlParser
extends AbstractXmlParser {
    static final String UNEXPECTED_EOF = "Unexpected EOF";
    private char[] buf;
    private boolean eof;
    private int bufPos;
    private int bufCount;
    private Reader reader;
    private boolean relaxed;
    private int line = 1;
    private int column = 1;
    List qNames = new ArrayList();
    boolean immediateClose = false;
    StartTag current;
    String closePending;
    protected ParseEvent next;

    int peekChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.bufPos >= this.bufCount) {
            if (this.buf.length == 1) {
                int c = this.reader.read();
                if (c == -1) {
                    this.eof = true;
                    return -1;
                }
                this.bufCount = 1;
                this.buf[0] = (char)c;
            } else {
                this.bufCount = this.reader.read(this.buf, 0, this.buf.length);
                if (this.bufCount == -1) {
                    this.eof = true;
                    return -1;
                }
            }
            this.bufPos = 0;
        }
        return this.buf[this.bufPos];
    }

    int readChar() throws IOException {
        int p = this.peekChar();
        ++this.bufPos;
        ++this.column;
        if (p == 10) {
            ++this.line;
            this.column = 1;
        }
        return p;
    }

    void skipWhitespace() throws IOException {
        while (!this.eof && this.peekChar() <= 32) {
            this.readChar();
        }
    }

    public String readName() throws IOException {
        int c = this.readChar();
        if (!(c >= 128 || c == 95 || c == 58 || c >= 97 && c <= 122 || c >= 65 && c <= 90)) {
            throw new ParseException("name expected!", null, this.line, this.column);
        }
        StringBuffer buf = new StringBuffer();
        buf.append((char)c);
        while (!this.eof && ((c = this.peekChar()) >= 128 || c == 95 || c == 45 || c == 58 || c == 46 || c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90)) {
            buf.append((char)this.readChar());
        }
        return buf.toString();
    }

    public StringBuffer readTo(char stopChar, StringBuffer buf) throws IOException {
        while (!this.eof && this.peekChar() != stopChar) {
            buf.append((char)this.readChar());
        }
        return buf;
    }

    public XmlParser(Reader reader) throws IOException {
        this(reader, Runtime.getRuntime().freeMemory() >= 0x100000L ? 8192 : 1);
    }

    public XmlParser(Reader reader, int bufSize) throws IOException {
        this.reader = reader;
        this.buf = new char[bufSize];
    }

    public String resolveCharacterEntity(String name) throws IOException {
        throw new ParseException("Undefined: &" + name + ";", null, this.line, this.column);
    }

    ParseEvent parseComment() throws IOException {
        int cnt;
        StringBuffer buf = new StringBuffer();
        if (this.readChar() != 45) {
            throw new ParseException("'-' expected", null, this.line, this.column);
        }
        while (true) {
            int lst;
            this.readTo('-', buf);
            if (this.readChar() == -1) {
                throw new ParseException(UNEXPECTED_EOF, null, this.line, this.column);
            }
            cnt = 0;
            do {
                lst = this.readChar();
                ++cnt;
            } while (lst == 45);
            if (lst == 62 && cnt >= 2) break;
            while (cnt-- > 0) {
                buf.append('-');
            }
            buf.append((char)lst);
        }
        while (cnt-- > 2) {
            buf.append('-');
        }
        return new ParseEvent(1, buf.toString());
    }

    ParseEvent parseDoctype() throws IOException {
        StringBuffer buf = new StringBuffer();
        int nesting = 1;
        while (true) {
            int i = this.readChar();
            switch (i) {
                case -1: {
                    throw new ParseException(UNEXPECTED_EOF, null, this.line, this.column);
                }
                case 60: {
                    ++nesting;
                    break;
                }
                case 62: {
                    if (--nesting != 0) break;
                    return new ParseEvent(2, buf.toString());
                }
            }
            buf.append((char)i);
        }
    }

    ParseEvent parseCData() throws IOException {
        StringBuffer buf = this.readTo('[', new StringBuffer());
        if (!buf.toString().equals("CDATA")) {
            throw new ParseException("Invalid CDATA start!", null, this.line, this.column);
        }
        buf.setLength(0);
        this.readChar();
        int c0 = this.readChar();
        int c1 = this.readChar();
        while (true) {
            int c2;
            if ((c2 = this.readChar()) == -1) {
                throw new ParseException(UNEXPECTED_EOF, null, this.line, this.column);
            }
            if (c0 == 93 && c1 == 93 && c2 == 62) break;
            buf.append((char)c0);
            c0 = c1;
            c1 = c2;
        }
        return new ParseEvent(128, buf.toString());
    }

    ParseEvent parseEndTag() throws IOException {
        this.skipWhitespace();
        this.closePending = this.readName();
        this.skipWhitespace();
        if (this.readChar() != 62) {
            throw new ParseException("'>' expected", null, this.line, this.column);
        }
        return this.checkEndTag();
    }

    public ParseEvent checkEndTag() throws IOException {
        int last = this.qNames.size();
        if (last == 0) {
            throw new ParseException("tagstack empty parsing </" + this.closePending + ">", null, this.line, this.column);
        }
        String qName = (String)this.qNames.get(--last);
        this.qNames.remove(last);
        if (qName.equals(this.closePending) || this.relaxed && qName.toLowerCase().equals(this.closePending.toLowerCase())) {
            this.closePending = null;
        } else if (!this.relaxed) {
            throw new ParseException("StartTag <" + qName + "> does not match end tag </" + this.closePending + ">", null, this.line, this.column);
        }
        Tag result = new Tag(16, this.current, this.current.namespace, this.current.name);
        this.current = this.current.parent;
        return result;
    }

    ParseEvent parsePI() throws IOException {
        StringBuffer buf = new StringBuffer();
        this.readTo('?', buf);
        this.readChar();
        while (this.peekChar() != 62) {
            buf.append('?');
            int r = this.readChar();
            if (r == -1) {
                throw new ParseException(UNEXPECTED_EOF, null, this.line, this.column);
            }
            buf.append((char)r);
            this.readTo('?', buf);
            this.readChar();
        }
        this.readChar();
        return new ParseEvent(32, buf.toString());
    }

    StartTag parseStartTag() throws IOException {
        String qname = this.readName();
        ArrayList<Attribute> attributes = null;
        this.immediateClose = false;
        while (true) {
            this.skipWhitespace();
            int c = this.peekChar();
            if (c == -1) {
                throw new ParseException(UNEXPECTED_EOF, null, this.line, this.column);
            }
            if (c == 47) {
                this.immediateClose = true;
                this.readChar();
                this.skipWhitespace();
                if (this.readChar() == 62) break;
                throw new ParseException("illegal element termination", null, this.line, this.column);
            }
            if (c == 62) {
                this.readChar();
                break;
            }
            String attrName = this.readName();
            if (attrName.length() == 0) {
                throw new ParseException("illegal char / attr", null, this.line, this.column);
            }
            this.skipWhitespace();
            if (this.readChar() != 61) {
                throw new ParseException("Attribute name " + attrName + "must be followed by '='!", null, this.line, this.column);
            }
            this.skipWhitespace();
            int delimiter = this.readChar();
            if (delimiter != 39 && delimiter != 34) {
                if (!this.relaxed) {
                    throw new ParseException("<" + qname + ">: invalid delimiter: " + (char)delimiter, null, this.line, this.column);
                }
                delimiter = 32;
            }
            StringBuffer buf = new StringBuffer();
            this.readText(buf, (char)delimiter);
            if (attributes == null) {
                attributes = new ArrayList<Attribute>();
            }
            attributes.add(new Attribute(null, attrName, buf.toString()));
            if (delimiter == 32) continue;
            this.readChar();
        }
        try {
            this.current = new StartTag(this.current, "", qname, attributes, this.immediateClose, this.processNamespaces);
        }
        catch (Exception e) {
            throw new ParseException(e.toString(), e, this.line, this.column);
        }
        if (!this.immediateClose) {
            this.qNames.add(qname);
        }
        return this.current;
    }

    int readText(StringBuffer buf, char delimiter) throws IOException {
        int nextChar;
        int type = 256;
        while ((nextChar = this.peekChar()) != -1 && nextChar != delimiter && (delimiter != ' ' || nextChar != 62 && nextChar >= 32)) {
            this.readChar();
            if (nextChar == 38) {
                String code = this.readTo(';', new StringBuffer()).toString();
                this.readChar();
                if (code.charAt(0) == '#') {
                    int n = nextChar = code.charAt(1) == 'x' ? Integer.parseInt(code.substring(2), 16) : Integer.parseInt(code.substring(1));
                    if (nextChar > 32) {
                        type = 128;
                    }
                    buf.append((char)nextChar);
                    continue;
                }
                if (code.equals("lt")) {
                    buf.append('<');
                } else if (code.equals("gt")) {
                    buf.append('>');
                } else if (code.equals("apos")) {
                    buf.append('\'');
                } else if (code.equals("quot")) {
                    buf.append('\"');
                } else if (code.equals("amp")) {
                    buf.append('&');
                } else {
                    buf.append(this.resolveCharacterEntity(code));
                }
                type = 128;
                continue;
            }
            if (nextChar > 32) {
                type = 128;
            }
            buf.append((char)nextChar);
        }
        return type;
    }

    ParseEvent parseSpecial() throws IOException {
        switch (this.peekChar()) {
            case -1: {
                throw new ParseException(UNEXPECTED_EOF, null, this.line, this.column);
            }
            case 33: {
                this.readChar();
                switch (this.peekChar()) {
                    case 45: {
                        this.readChar();
                        return this.parseComment();
                    }
                    case 91: {
                        this.readChar();
                        return this.parseCData();
                    }
                }
                return this.parseDoctype();
            }
            case 63: {
                this.readChar();
                return this.parsePI();
            }
            case 47: {
                this.readChar();
                return this.parseEndTag();
            }
        }
        return this.parseStartTag();
    }

    @Override
    public ParseEvent read() throws IOException {
        if (this.next == null) {
            this.peek();
        }
        ParseEvent result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public ParseEvent peek() throws IOException {
        if (this.next == null) {
            if (this.immediateClose) {
                this.next = new Tag(16, this.current, this.current.namespace, this.current.name);
                this.current = this.current.getParent();
                this.immediateClose = false;
            } else if (this.closePending != null) {
                this.next = this.checkEndTag();
            } else {
                switch (this.peekChar()) {
                    case 60: {
                        this.readChar();
                        this.next = this.parseSpecial();
                        break;
                    }
                    case -1: {
                        if (this.current != null && !this.relaxed) {
                            throw new ParseException("End tag missing for: " + this.current, null, this.line, this.column);
                        }
                        this.next = new ParseEvent(8, null);
                        break;
                    }
                    default: {
                        StringBuffer buf = new StringBuffer();
                        int type = this.readText(buf, '<');
                        this.next = new ParseEvent(type, buf.toString());
                    }
                }
            }
        }
        return this.next;
    }

    public void setRelaxed(boolean relaxed) {
        this.relaxed = relaxed;
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }
}

