/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.log.Trace;
import org.jgroups.stack.Interval;
import org.jgroups.util.TimeScheduler;

public class AckMcastSenderWindow {
    private static final long SEC = 1000L;
    private static final long[] RETRANSMIT_TIMEOUTS = new long[]{2000L, 3000L, 5000L, 8000L};
    private static final long SUSPEND_TIMEOUT = 2000L;
    private Hashtable msgs = new Hashtable();
    private LinkedList suspects = new LinkedList();
    private int max_suspects = 20;
    private Vector stable_msgs = new Vector();
    private boolean waiting = false;
    private boolean retransmitter_owned;
    private TimeScheduler retransmitter = null;
    private long[] retransmit_intervals;
    private RetransmitCommand cmd = null;

    private static String _toString(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retransmit(Entry entry) {
        Entry entry2 = entry;
        synchronized (entry2) {
            Enumeration e = entry.senders.keys();
            while (e.hasMoreElements()) {
                Address sender = (Address)e.nextElement();
                boolean received = (Boolean)entry.senders.get(sender);
                if (received) continue;
                if (this.suspects.contains(sender)) {
                    if (Trace.trace) {
                        Trace.warn("AckMcastSenderWindow._retransmit()", "removing " + sender + " from retransmit list as it is in the suspect list");
                    }
                    this.remove(sender);
                    continue;
                }
                if (Trace.trace) {
                    Trace.info("AckMcastSenderWindow", "--> retransmitting msg #" + entry.seqno + " to " + sender);
                }
                this.cmd.retransmit(entry.seqno, entry.msg.copy(), sender);
            }
        }
    }

    private void init(RetransmitCommand cmd, long[] retransmit_intervals, TimeScheduler sched, boolean sched_owned) {
        if (cmd == null) {
            Trace.error("AckMcastSenderWindow", "command is null. Cannot retransmit messages !");
            throw new IllegalArgumentException("cmd");
        }
        this.retransmitter_owned = sched_owned;
        this.retransmitter = sched;
        this.retransmit_intervals = retransmit_intervals;
        this.cmd = cmd;
        this.start();
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, long[] retransmit_intervals, TimeScheduler sched) {
        this.init(cmd, retransmit_intervals, sched, false);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, TimeScheduler sched) {
        this.init(cmd, RETRANSMIT_TIMEOUTS, sched, false);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd, long[] retransmit_intervals) {
        this.init(cmd, retransmit_intervals, new TimeScheduler(2000L), true);
    }

    public AckMcastSenderWindow(RetransmitCommand cmd) {
        this(cmd, RETRANSMIT_TIMEOUTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long seqno, Message msg, Vector receivers) {
        if (this.waiting) {
            return;
        }
        if (receivers.size() == 0) {
            return;
        }
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            if (this.msgs.get(new Long(seqno)) != null) {
                return;
            }
            Entry e = new Entry(seqno, msg, receivers, this.retransmit_intervals);
            this.msgs.put(new Long(seqno), e);
            this.retransmitter.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(long seqno, Address sender) {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            Entry entry = (Entry)this.msgs.get(new Long(seqno));
            if (entry == null) {
                return;
            }
            Object object = entry;
            synchronized (object) {
                Boolean received = (Boolean)entry.senders.get(sender);
                if (received == null || received.booleanValue()) {
                    return;
                }
                entry.senders.put(sender, new Boolean(true));
                ++entry.num_received;
                if (!entry.allReceived()) {
                    return;
                }
            }
            object = this.stable_msgs;
            synchronized (object) {
                entry.cancel();
                this.msgs.remove(new Long(seqno));
                this.stable_msgs.add(new Long(seqno));
            }
            this.msgs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Address obj) {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            Enumeration e = this.msgs.keys();
            while (e.hasMoreElements()) {
                Long key = (Long)e.nextElement();
                Entry entry = (Entry)this.msgs.get(key);
                Object object = entry;
                synchronized (object) {
                    Boolean received = (Boolean)entry.senders.remove(obj);
                    if (received == null) {
                        continue;
                    }
                    if (received.booleanValue()) {
                        --entry.num_received;
                    }
                    if (!entry.allReceived()) {
                        continue;
                    }
                }
                object = this.stable_msgs;
                synchronized (object) {
                    entry.cancel();
                    this.msgs.remove(key);
                    this.stable_msgs.add(key);
                }
                this.msgs.notify();
            }
        }
    }

    public void suspect(Address suspected) {
        if (Trace.trace) {
            Trace.info("AckMcastSenderWindow.suspect()", "suspect is " + suspected);
        }
        this.remove(suspected);
        this.suspects.add(suspected);
        if (this.suspects.size() >= this.max_suspects) {
            this.suspects.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getStableMessages() {
        Vector retval;
        Vector vector = this.stable_msgs;
        synchronized (vector) {
            Vector vector2 = retval = this.stable_msgs.size() > 0 ? (Vector)this.stable_msgs.clone() : null;
            if (this.stable_msgs.size() > 0) {
                this.stable_msgs.clear();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStableMessages() {
        Vector vector = this.stable_msgs;
        synchronized (vector) {
            this.stable_msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            return this.msgs.size();
        }
    }

    public long getNumberOfResponsesExpected(long seqno) {
        Entry entry = (Entry)this.msgs.get(new Long(seqno));
        if (entry != null) {
            return entry.senders.size();
        }
        return -1L;
    }

    public long getNumberOfResponsesReceived(long seqno) {
        Entry entry = (Entry)this.msgs.get(new Long(seqno));
        if (entry != null) {
            return entry.num_received;
        }
        return -1L;
    }

    public String printDetails(long seqno) {
        Entry entry = (Entry)this.msgs.get(new Long(seqno));
        if (entry != null) {
            return entry.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAllAcksReceived(long timeout) {
        Hashtable hashtable;
        Iterator it = this.suspects.iterator();
        while (it.hasNext()) {
            Address suspect = (Address)it.next();
            this.remove(suspect);
        }
        long time_to_wait = timeout;
        this.waiting = true;
        if (timeout <= 0L) {
            hashtable = this.msgs;
            synchronized (hashtable) {
                while (this.msgs.size() > 0) {
                    try {
                        this.msgs.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        long start_time = System.currentTimeMillis();
        hashtable = this.msgs;
        synchronized (hashtable) {
            long current_time;
            while (this.msgs.size() > 0 && (time_to_wait = timeout - ((current_time = System.currentTimeMillis()) - start_time)) > 0L) {
                try {
                    this.msgs.wait(time_to_wait);
                }
                catch (InterruptedException ex) {
                    Trace.warn("AckMcastSenderWindow.waitUntilAllAcksReceived()", ex.toString());
                }
            }
        }
        this.waiting = false;
    }

    public void start() {
        if (this.retransmitter_owned) {
            this.retransmitter.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            if (this.retransmitter_owned) {
                try {
                    this.retransmitter.stop();
                }
                catch (InterruptedException ex) {
                    Trace.error("AckMcastSenderWindow.stop()", AckMcastSenderWindow._toString(ex));
                }
            } else {
                Enumeration e = this.msgs.elements();
                while (e.hasMoreElements()) {
                    Entry entry = (Entry)e.nextElement();
                    entry.cancel();
                }
            }
            this.msgs.clear();
            this.msgs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.waiting) {
            return;
        }
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            Enumeration e = this.msgs.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                entry.cancel();
            }
            this.msgs.clear();
            this.msgs.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer ret = new StringBuffer();
        Hashtable hashtable = this.msgs;
        synchronized (hashtable) {
            ret.append("msgs: (" + this.msgs.size() + ")");
            Enumeration e = this.msgs.keys();
            while (e.hasMoreElements()) {
                Long key = (Long)e.nextElement();
                Entry entry = (Entry)this.msgs.get(key);
                ret.append("key = " + key + ", value = " + entry + "\n");
            }
            Vector vector = this.stable_msgs;
            synchronized (vector) {
                ret.append("\nstable_msgs: " + this.stable_msgs);
            }
        }
        return ret.toString();
    }

    private class Entry
    extends Task {
        public long seqno;
        public Message msg = null;
        public Hashtable senders = new Hashtable();
        public int num_received = 0;

        public Entry(long seqno, Message msg, Vector dests, long[] intervals) {
            super(intervals);
            this.seqno = seqno;
            this.msg = msg;
            for (int i = 0; i < dests.size(); ++i) {
                this.senders.put(dests.elementAt(i), new Boolean(false));
            }
        }

        boolean allReceived() {
            return this.num_received >= this.senders.size();
        }

        public void run() {
            AckMcastSenderWindow.this._retransmit(this);
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("num_received = " + this.num_received + ", received msgs = " + this.senders);
            return buff.toString();
        }
    }

    private static abstract class Task
    implements TimeScheduler.Task {
        private Interval intervals;
        private boolean cancelled;

        protected Task(long[] intervals) {
            this.intervals = new Interval(intervals);
            this.cancelled = false;
        }

        public long nextInterval() {
            return this.intervals.next();
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean cancelled() {
            return this.cancelled;
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3, Address var4);
    }
}

