/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.LockingException;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.ReplicationData;
import org.jgroups.blocks.ReplicationReceiver;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.UpdateException;
import org.jgroups.blocks.Xid;
import org.jgroups.log.Trace;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class ReplicationManager
implements RequestHandler {
    Address local_addr = null;
    ReplicationReceiver receiver = null;
    protected MessageDispatcher disp = null;

    public ReplicationManager(Channel channel, MessageListener ml, MembershipListener l, ReplicationReceiver receiver) {
        this.setReplicationReceiver(receiver);
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            this.disp = new MessageDispatcher(channel, ml, l, this, true);
        }
    }

    public ReplicationManager(PullPushAdapter adapter, Serializable id, MessageListener ml, MembershipListener l, ReplicationReceiver receiver) {
        if (adapter != null && adapter.getTransport() != null && adapter.getTransport() instanceof Channel) {
            this.local_addr = ((Channel)adapter.getTransport()).getLocalAddress();
        }
        this.setReplicationReceiver(receiver);
        this.disp = new MessageDispatcher(adapter, id, ml, l, this);
        this.disp.setDeadlockDetection(true);
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
        }
    }

    public Xid begin() throws Exception {
        return this.begin(1);
    }

    public Xid begin(int transaction_mode) throws Exception {
        return Xid.create(this.local_addr, transaction_mode);
    }

    public void setReplicationReceiver(ReplicationReceiver handler) {
        this.receiver = handler;
    }

    public void setMembershipListener(MembershipListener l) {
        if (l == null) {
            return;
        }
        if (this.disp == null) {
            Trace.error("ReplicationManager.setMembershipListener()", "dispatcher is null, cannot set MembershipListener");
        } else {
            this.disp.setMembershipListener(l);
        }
    }

    public RspList send(Address dest, byte[] data, boolean synchronous, long synchronous_timeout, Xid transaction, byte[] lock_info, long lock_acquisition_timeout, long lock_lease_timeout, boolean use_locks) {
        ReplicationData d = new ReplicationData(1, data, transaction, lock_info, lock_acquisition_timeout, lock_lease_timeout, use_locks);
        if (Trace.trace) {
            Trace.info("ReplicationManager.send()", "data is " + d + " (synchronous=" + synchronous + ")");
        }
        Message msg = new Message(dest, null, d);
        if (synchronous) {
            return this.disp.castMessage(null, msg, 2, synchronous_timeout);
        }
        this.disp.castMessage(null, msg, 6, 0L);
        return null;
    }

    public void commit(Xid transaction) {
        this.sendMessage(2, transaction);
    }

    public void rollback(Xid transaction) {
        this.sendMessage(3, transaction);
    }

    public Object handle(Message msg) {
        ReplicationData data;
        Object retval = null;
        if (msg == null) {
            Trace.error("ReplicationManager.handle()", "received message was null");
            return null;
        }
        byte[] buf = msg.getBuffer();
        if (buf == null) {
            Trace.error("ReplicationManager.handle()", "payload of received message was null");
            return null;
        }
        try {
            data = (ReplicationData)Util.objectFromByteBuffer(buf);
        }
        catch (Throwable ex) {
            Trace.error("ReplicationManager.handle()", "failure unmarshalling message: " + ex);
            return null;
        }
        switch (data.getType()) {
            case 1: {
                try {
                    return this.handleSend(data);
                }
                catch (Throwable ex) {
                    Trace.error("ReplicationManager.handle()", "failed handling update: " + ex);
                    return ex;
                }
            }
            case 2: {
                this.handleCommit(data.getTransaction());
                break;
            }
            case 3: {
                this.handleRollback(data.getTransaction());
                break;
            }
            default: {
                Trace.error("ReplicationManager.handle()", "received incorrect replication message: " + data);
                return null;
            }
        }
        return retval;
    }

    protected Object handleSend(ReplicationData data) throws UpdateException, LockingException {
        try {
            if (this.receiver == null) {
                Trace.warn("ReplicationManager.handleSend()", "receiver is not set");
                return null;
            }
            return this.receiver.receive(data.getTransaction(), data.getData(), data.getLockInfo(), data.getLockAcquisitionTimeout(), data.getLockLeaseTimeout(), data.useLocks());
        }
        catch (Throwable ex) {
            return ex;
        }
    }

    protected void handleCommit(Xid transaction) {
        if (this.receiver == null) {
            Trace.warn("ReplicationManager.handleCommit()", "receiver is not set");
        } else {
            this.receiver.commit(transaction);
        }
    }

    protected void handleRollback(Xid transaction) {
        if (this.receiver == null) {
            Trace.warn("ReplicationManager.handleRollback()", "receiver is not set");
        } else {
            this.receiver.rollback(transaction);
        }
    }

    void sendMessage(int type, Xid transaction) {
        ReplicationData data = new ReplicationData(type, null, transaction, null, 0L, 0L, false);
        Message msg = new Message(null, null, data);
        this.disp.castMessage(null, msg, 6, 0L);
    }
}

